<?php
/*
Template Name: ارسال تصویر رسید
*/
include 'actions/action_arrived.php';
if (!isset($_GET['action_show']) || empty($_GET['action_show'])) {
    get_template_part("404");
    exit;
} else {
    $invoice_id = $_GET['action_show'];
    $row = get_result_invoice($invoice_id);
    if (!$row || $row->id != $invoice_id) {
        get_template_part("404");
        exit;
    }
}
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ارسال رسید</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item active" aria-current="page">رسال رسید</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-regular fa-building-columns custom-icon"></i>
                            ارسال رسید
                        </div>
                    </div>
                    <?php
                    $result = get_result_arrived($invoice_id);
                    if (!empty($result)) { // بررسی می‌کنیم که مقدار null یا خالی نباشد
                        $images = explode(",", $result->img_arrived); // مستقیم مقدار رشته را به explode می‌دهیم
                    } else {
                        $images = []; // مقدار پیش‌فرض برای جلوگیری از خطا
                    }
                    ?>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-bank" action="" method="post" enctype="multipart/form-data">
                            <div class="col-12">
                                <div class="mb-4 main-content-label">تصویر رسید</div>
                                <input type="hidden" name="user_id" value="<?= custom_session_id(); ?>">
                                <input type="hidden" name="invoice_id" value="<?= $row->id ?>">
                                <input type="file" name="arrived_images[]" id="imageUpload" class="form-control"
                                    multiple>
                                <div class="container-preview text-center img-fluid">
                                    <?php if ($result) { ?>
                                    <div id="preview" style="display: inline;" class="mt-2 img-prev">
                                        <?php foreach ($images as $img): ?>
                                        <div class="text-center" style="position: relative;left:40%">
                                        <img class="preview-image img-fluid" style="max-width: 200px; margin: 5px;" src="<?= $img ?>" alt="">
                                        </div>
                                        <?php endforeach ?>
                                    </div>
                                    <?php } else { ?>
                                    <div id="preview" class="mt-2 img-prev">
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="send_img_arrived" style="width:100%"
                                    class="btn btn-primary btn-lg text">
                                    ارسال رسید</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->