<?php
/*
Template Name: ثبت مدت زمان سررسید
*/
include 'actions/action_invoice.php';
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ثبت مدت زمان سررسید</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">مدیریت فاکتور ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ثبت مدت زمان سررسید</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-light fa-file-invoice custom-icon"></i>
                            ثبت مدت زمان سررسید
                        </div>
                    </div>
                    <?php $row = select_invoice_time();?>
                    <div class="card-body">
                        <form class="row g-3 mt-0" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                            value="<?php if(!empty($row)){echo $row->key_protection;}elseif(!empty(old('key_protection')))
                            {echo old('key_protection');}else{echo md5(time());} ?>">
                            <div class="col-md-12">
                                <label class="form-label">تعداد روز مورد نظر را وارد نمایید<span
                                        class="required">*</span></label>
                                <input type="text" name="invoice_time" class="form-control days_invoice"
                                    placeholder="مدت زمان قسط را وارد نمایید"
                                    value="<?php if(!empty($row)){ echo $row->invoice_time;}else{echo old("invoice_time");} ?>">
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="save_invoice_time"
                                    class="btn btn-primary btn-lg text">ثبت</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->