<?php
/*
Template Name: لیست محصولات ثبت سفارش
*/
if (isset($_SESSION['user_info'])) {
    $user_info = $_SESSION['user_info'];
    $session_id = $user_info['id'];
}
if($user_info['user_role'] == 'representative'){
    $session_id = $user_info['id'];

    if (!isset($_GET['bank_name']) &&  !isset($_GET['aghsat'])) {
        get_template_part('404');
        exit;
    } else {
        
        $aghsat = $_GET['aghsat'];
        $res = get_sood_by_slug($aghsat);
        if (!$res || $res->slug != $aghsat) {
            get_template_part('404');
            exit;
        }
        $bank_name = $_GET['bank_name'];
        $res2 = get_result_slug_bank($bank_name);
        if (!$res2 || $res2->slug != $bank_name) {
            get_template_part('404');
            exit;
        }
    }
}else{
    if (!isset($_GET['bank_name']) && !isset($_GET['agent']) &&  !isset($_GET['aghsat'])) {
        get_template_part('404');
        exit;
    } else {
        
        $aghsat = $_GET['aghsat'];
        $res = get_sood_by_slug($aghsat);
        if (!$res || $res->slug != $aghsat) {
            get_template_part('404');
            exit;
        }
        $username = $user_info['username'];
        if(isset($_GET['agent'])){
            $agent = $_GET['agent'];
        }else{
            header("location: Register-Proforma-Invoice?error_message=ghesmat_namayandeh_khalist");
        }
        $us = get_user_by_username($agent);
        if (!$us || $us->username != $_GET['agent'] || $us->parent_id != $session_id) {
            get_template_part('404');
            exit;
        }
        if ($us->user_role == 'admin' || $us->user_role == 'admin_site' || $us->user_role == 'regional_manager') {
            get_template_part('404');
            exit;
        }
        $bank_name = $_GET['bank_name'];
        $res2 = get_result_slug_bank($bank_name);
        if (!$res2 || $res2->slug != $bank_name) {
            get_template_part('404');
            exit;
        }
    }
}


get_header();
get_sidebar();
?>

<div class="main-content app-content">
    <div class="container-fluid">

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">لیست محصولات</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">محصولات</a></li>
                    <li class="breadcrumb-item active" aria-current="page">لیست محصولات</li>
                </ol>
            </div>
        </div>

        <div class="row">
            <?php
            $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
            $posts_per_page = 10;

            $data = get_result_products_orders('custom_products', $paged, $posts_per_page);
            $results = $data['results'];
            $total_pages = $data['total_pages'];

            if ($results) {
                foreach ($results as $row):
                    // تبدیل قیمت به عددی معتبر
                    $price = isset($row->price) ? floatval($row->price) : 0;

                    // دریافت درصد سود
                    $sood_obj = get_sood_by_slug($_GET['aghsat']);
                    $sood = isset($sood_obj->sood) ? floatval($sood_obj->sood) : 0; // استخراج مقدار عددی سود



                    // بررسی عددی بودن مقدار سود
                    if (!is_numeric($sood)) {
                        $sood = 0;
                    }

                    // محاسبه قیمت نهایی
                    $final_price = $price * (1 + $sood / 100);
                    $final_price = number_format(round($final_price), 0, '.', ','); // فرمت نهایی قیمت

            ?>
                    <div class="col-sm-12 col-xl-3">
                        <form action="" method="post">
                            <div class="card custom-card">
                                <input type="text" name="product_id" hidden value="<?php echo $row->id; ?>">
                                <input type="text" name="bank_id" hidden value="<?php echo $res2->id; ?>">
                                <input type="text" name="ghest_id" hidden value="<?php echo $res->id; ?>">
                                <input type="text" name="price" hidden value="<?php echo $final_price; ?>">
                                <?php if($user_info['user_role'] == 'regional_manager' ) { ?>
                                <input type="text" name="agent" hidden value="<?php echo $us->id ; ?>">
                                <?php } else{ echo '';} ?>
                                <div class="logo_product text-center">
                                    <img class="img_logo img-fluid rounded"
                                        src="<?php echo htmlspecialchars($row->img_product); ?>"
                                        alt="<?php echo htmlspecialchars($row->slug); ?>">
                                </div>
                                <div class="card-title title_card">
                                    <span class="title_product"><?php echo htmlspecialchars($row->name_product); ?></span>
                                </div>
                                <input type="hidden" name="slug" value="<?php echo htmlspecialchars($row->slug); ?>">
                                <div class="info_product">
                                    <?php if ($row->count_product) { ?>
                                        <span class="count_product">موجودی : <?php echo $row->count_product; ?></span>
                                        <span class="priced"><?php echo $final_price; ?> تومان</span>
                                    <?php } else { ?>
                                        <span class="count_product">موجودی کافی نیست</span>
                                        <span class="priced">0 تومان</span>
                                    <?php } ?>
                                </div>
                                <br>
                                <div class="selprice">
                                    <?php if ($row->count_product) { ?>
                                        <div class="quantity-container">
                                            <button type="button" class="quantity-btn decrease">-</button>
                                            <input type="text" name="quantity" class="quantity-input quantity" value="1" readonly>
                                            <button type="button" class="quantity-btn increase" id="">+</button>
                                        </div>
                                    <?php } else { ?>
                                        <div class="quantity-container">
                                            <button disabled type="button" class="quantity-btn decrease">-</button>
                                            <input disabled type="text" name="quantity" class="quantity-input quantity" value="1" readonly>
                                            <button disabled type="button" class="quantity-btn increase" id="">+</button>
                                        </div>
                                    <?php } ?>
                                    <?php if ($row->count_product) { ?>
                                        <div class="buttn_send product_order">
                                            <button type="submit" name="add_to_cart_item"
                                                class="btn btn-success buy_order add_to_cart_item">
                                                <i class="fa-light fa-basket-shopping-simple cart_icon"></i>
                                                افزودن به سبد خرید</button>
                                        <?php } else { ?>
                                            <div class="buttn_send btn_disabled product_order">
                                                <button disabled type="submit" name="add_to_cart_item"
                                                    class="btn btn-success buy_order add_to_cart_item">
                                                    <i class="fa-light fa-basket-shopping-simple cart_icon"></i>
                                                    افزودن به سبد خرید</button>
                                            <?php } ?>
                                            </div>
                                        </div>
                                        <br>
                                </div>
                        </form>
                    </div>
                <?php endforeach; ?>
            <?php } else { ?>
                <span class="badge badge-warning">هیچ محصولی یافت نشد</span>
            <?php } ?>
            <!-- Pagination -->
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center">
                    <?php
                    $pagination_links = paginate_links([
                        'total' => $total_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'array',
                        'end_size' => 1,
                        'mid_size' => 2,
                        'prev_next' => true,
                        'prev_text' => __('قبلی'),
                        'next_text' => __('بعدی'),
                        'add_args' => false,
                        'add_fragment' => '',
                    ]);

                    if ($pagination_links) {
                        foreach ($pagination_links as $link) {
                            $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                            echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                        }
                    }
                    ?>
                </ul>
            </nav>
            <!-- End Pagination -->
        </div>

    </div>
</div>

<script>
    function changeQuantity(amount, btn) {
        let input = btn.parentElement.querySelector(".quantity-input");
        let newValue = Math.max(1, parseInt(input.value) + amount);
        input.value = newValue;
    }
</script>

<?php get_footer(); ?>