<?php
/*
Template Name: لیست محصولات
*/
echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
if (isset($_GET['action_delete']) && !empty($_GET['action_delete'])) {
    $table = "custom_products";
    $cand_delete = can_delete_item("product", $_GET['action_delete']);
    if ($cand_delete !== true) {
        $cand_delete_escaped = json_encode($cand_delete, JSON_UNESCAPED_UNICODE);
        echo "
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    html: $cand_delete_escaped,
                    confirmButtonText: 'متوجه شدم',
                    willClose: () => {
                        document.body.classList.remove('swal-open');
                        document.querySelector('.swal-overlay').remove();
                    },
                }).then(() => {
                    // حذف کوئری استرینگ بدون رفرش صفحه
                    const newUrl = window.location.origin + window.location.pathname;
                    history.replaceState(null, '', newUrl);
                });
            });
        </script>
        ";
    }
    else{
    $delete = get_delete($table, $_GET['action_delete']);
    if ($delete) {
        header("Location:" . site_url('products/?delete=success'));
        exit;
    }
}
}
if (isset($_GET['delete']) && $_GET['delete'] == 'success') {
    echo "
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
            document.body.classList.add('swal-open'); 
            Swal.fire({
                icon: 'success',
                title: 'حذف موفقیت آمیز!',
                text: 'محصول با موفقیت حذف شد',
                confirmButtonText: 'متوجه شدم',
                timer: 5000,
                timerProgressBar: true,
                willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
            }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
        });
    </script>
    ";
}?>
<title>محصولات</title>
<?php
$user_info = $_SESSION['user_info'];
$role = $user_info['user_role'];
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">لیست محصولات</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">محصولات</a></li>
                    <li class="breadcrumb-item active" aria-current="page">لیست محصولات</li>
                </ol>
            </div>
        </div>
        <!-- Page Header Close -->

        <!-- Start::row-1 -->
        <div class="row">
            <div class="search_box">
                <div class="titr_filter">جست و جو کنید بر اساس نیاز خود</div>
                <form action="" method="get" class="search-form">
                    <div class="row">
                        <div class="col-xl-6 col-xs-12 eleman_search">
                            <select class="js-example-basic-single" name="status" data-trigger>
                                <option value="" hidden selected>انتخاب بر اساس</option>
                                <option value="active">فعال</option>
                                <option value="deactive">غیر فعال</option>
                            </select>
                        </div>
                        <div class="col-xl-6 col-xs-12 eleman_search">
                            <input type="text" class="form-control" name="q" placeholder="جست و جو کنید" id="">
                        </div>
                        <div class="buttn_filter">
                            <button type="submit" class="btn btn-primary">جست و جو کنید</button>
                        </div>
                    </div>
                </form>
            </div>
            <?php
                    $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                    $posts_per_page = 10;

                    $status = isset($_GET['status']) ? $_GET['status'] : '';
                    $q = isset($_GET['q']) ? $_GET['q'] : '';

                    $data = get_result_products('custom_products', $q, $status, $paged, $posts_per_page);
                    $results = $data['results'];
                    $total_pages = $data['total_pages'];
                    if (empty($results)) {
                        echo '<div class="alert alert-danger" style="font-size:20px">محصولی یافت نشد</div>';
                    }
                    ?>
            <?php foreach($results as $row): ?>
            <div class="col-xl-3 col-xs-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <form action="" class="form" method="post">
                            <div class="img_card">
                                <?php if ($role == "admin" || $role == "admin_site") { ?>
                                <div class="action_product">
                                    <a target="_blank" href="edit-product/?action_edit=<?= $row->key_protection ?>"
                                        data-tooltip="ویرایش محصول" class="tooltip-icon btn_icon">
                                        <i class="fa-regular fa-edit"></i>
                                    </a>
                                    <a href="#<?= $row->id ?>" data-bs-toggle="modal"
                                        data-url="<?= site_url("products/?action_delete=$row->id") ?>"
                                        data-tooltip="حذف محصول" class="tooltip-icon btn_icon delete-btn">
                                        <i class="fa-regular fa-trash"></i>
                                    </a>
                                </div>
                                <?php }?>
                                <img style="max-width: 100%;" class="img-fluid" src="<?= $row->img_product ?>"
                                    alt="<?= $row->name_product ?>">
                                <div class="info_img_card">
                                    <div class="titr_card"><?= $row->name_product ?></div>
                                    <div
                                        class="status_product badge <?= ($row->status == 'active') ? 'bg-success' : 'bg-warning' ?>">
                                        <?= ($row->status == 'active') ? 'فعال' : 'غیر فعال' ?>
                                    </div>
                                </div>
                            </div>
                            <div class="info_card">
                                <div class="quantity_card"> موجودی : <?= $row->count_product ?></div>
                                <div class="price_product"><?= number_format($row->price) ?> تومان</div>
                            </div>
                            <!-- Pagination -->
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-center">
                                    <?php
                                $pagination_links = paginate_links([
                                    'total' => $total_pages,
                                    'current' => $paged,
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'array',
                                    'end_size' => 1,
                                    'mid_size' => 2,
                                    'prev_next' => true,
                                    'prev_text' => __('قبلی'),
                                    'next_text' => __('بعدی'),
                                    'add_args' => false,
                                    'add_fragment' => '',
                                ]);

                                if ($pagination_links) {
                                    foreach ($pagination_links as $link) {
                                        $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                                        echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                                    }
                                }
                                ?>
                                </ul>
                            </nav>
                            <!-- End Pagination -->

                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach ?>
        </div>
        <!-- End::row-1 -->

    </div>
</div>
<!-- End::app-content -->

<!-- message sweetalert -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".delete-btn").forEach(button => {
        button.addEventListener("click", function(event) {
            event.preventDefault(); // جلوگیری از رفتن به لینک مستقیماً

            let deleteUrl = this.getAttribute("data-url"); // گرفتن لینک حذف

            Swal.fire({
                title: "آیا مطمئن هستید؟",
                text: "این عملیات قابل بازگشت نیست!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#db4040",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "بله، حذف شود!",
                cancelButtonText: "لغو"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href =
                        deleteUrl; // انتقال به لینک حذف در صورت تأیید
                }
            });
        });
    });
});
</script>
<!-- end message sweetalert -->

<!-- Footer Start -->
<?php get_footer(); ?>
<!-- Footer End -->