<!-- app-header -->
<?php
/*
Template Name: مدیریت اعلان
*/
check_access();
echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
if (isset($_GET['action_delete']) && !empty($_GET['action_delete'])) {
    $table = "custom_notifications";
    $cand_delete = can_delete_item("user", $_GET['action_delete']);
    if ($cand_delete !== true) {
        $cand_delete_escaped = json_encode($cand_delete, JSON_UNESCAPED_UNICODE);
        echo "
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    html: $cand_delete_escaped,
                    confirmButtonText: 'متوجه شدم',
                    willClose: () => {
                        document.body.classList.remove('swal-open');
                        document.querySelector('.swal-overlay').remove();
                    },
                }).then(() => {
                    // حذف کوئری استرینگ بدون رفرش صفحه
                    const newUrl = window.location.origin + window.location.pathname;
                    history.replaceState(null, '', newUrl);
                });
            });
        </script>
        ";
    }
    else{
    $delete = get_delete($table, $_GET['action_delete']);
    if ($delete) {
        header("Location:" . site_url('notifications/?delete=success'));
        exit;
    }
}
}
if (isset($_GET['delete']) && $_GET['delete'] == 'success') {
    echo "
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
            document.body.classList.add('swal-open'); 
            Swal.fire({
                icon: 'success',
                title: 'حذف موفقیت آمیز!',
                text: 'اعلان با موفقیت حذف شد',
                confirmButtonText: 'متوجه شدم',
                timer: 5000,
                timerProgressBar: true,
                willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
            }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
        });
    </script>
    ";
}
?>
<title>لیست اعلان ها</title>

<?php get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">لیست اعلان ها</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">اعلان ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">لیست اعلان ها</li>
                </ol>
            </div>
        </div>

        <!-- Page Header Close -->

        <!-- Start::row-1 -->
        <div class="row">
            <div class="card custom-card">
                <div class="card-body">
                    <div class="row rows">
                        <div class="col-xl-4 searched">
                            <form action="" name="search" method="get" class="search-form">
                                <div class="input-group slector">
                                    <div class="input-group-btn search-panel">
                                        <select class="js-example-basic-single" name="type" data-trigger>
                                            <option value="" disabled selected>انتخاب بر اساس</option>
                                            <option value="active">فعال</option>
                                            <option value="deactive">غیر فعال</option>
                                        </select>
                                    </div>
                                    <input type="text" class="form-control" name="q" id="typehead"
                                        placeholder="جست و جو کنید..." autocomplete="off">
                                    <button type="submit" class="btn btn-primary"><i class="fe fe-search"
                                            aria-hidden="true"></i></button>
                                </div>
                            </form>
                        </div>
                        <!-- <div class="col-xl-4 delete">
                                        <button type="submit" class="btn btn-delete" target="#">
                                            <i class="ri-delete-bin-5-line"></i>
                                        </button>
                                    </div> -->
                    </div>
                    <?php
                    $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                    $posts_per_page = 10;

                    $type = isset($_GET['type']) ? $_GET['type'] : '';
                    $q = isset($_GET['q']) ? $_GET['q'] : '';

                    $data = get_notifications('custom_notifications', $q, $type, $paged, $posts_per_page);
                    $results = $data['results'];
                    $total_pages = $data['total_pages'];
                    ?>
                    <form action="" class="form-users" method="post">
                        <div class="table-responsive custom-scrollbar">
                            <table class="table text-nowrap table-bordered text-nowrap table-hover">
                                <thead class="head-users-table">
                                    <tr>
                                        <!-- <th>
                                                    <span class="check-slector">
                                                        <input
                                                            class="form-check-input form-checked-success all-selected"
                                                            type="checkbox" value="" id="all-slected" checked="">
                                                        <label for="all-slected">شناسه کاربری</label>
                                                    </span>
                                                </th> -->
                                        <th>عنوان</th>
                                        <th>توضیحات</th>
                                        <th>ارسال کننده</th>
                                        <th>ارسال شده برای</th>
                                        <th>وضعیت</th>
                                        <th>تاریخ انتشار</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($results) { ?>
                                    <?php foreach ($results as $row) : ?>
                                    <tr>
                                        <!-- <td style="width:0">
                                                    <span class="check-slector">
                                                        <input
                                                            class="form-check-input form-checked-success all-selected"
                                                            type="checkbox" value="" id="checked1">
                                                        <label for="checked1">#1</label>
                                                    </span>
                                                </td> -->
                                        <th scope="row">
                                            <?= $row->title ?>
                                        </th>
                                        <td>
                                            <a data-bs-toggle="modal" href="#show_<?= $row->key_protection ?>"
                                                class="btn tooltip-icon" data-tooltip="مشاهده توضیحات اعلان">
                                                <i class="fa-regular fa-eye"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <?= $row->sender_name ?>
                                        </td>
                                        <td>
                                            <?= $row->receiver_name ? $row->receiver_name : 'ارسال برای همه' ?>
                                        </td>
                                        <td> <span
                                                class="badge <?= ($row->status == 'active') ? 'bg-success' : 'bg-warning' ?>">
                                                <?= ($row->status == 'active') ? 'فعال' : 'غیر فعال' ?>
                                            </span></td>
                                        <td><?= jdate("Y/m/d", strtotime($row->created_at)) ?></td>
                                        <td>
                                            <div class="hstack gap-2 flex-wrap">
                                                <a href="<?= site_url("edit-notification/?action_edit=$row->key_protection") ?>"
                                                    class="text-info fs-14 lh-1"><i class="ri-edit-line"></i></a>
                                                <a href="#" class="text-danger fs-14 lh-1 delete-btn"
                                                    data-url="<?= site_url("notifications/?action_delete=$row->id") ?>">
                                                    <i class="ri-delete-bin-5-line"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- مودال مشاهده توضیحات -->
                                    <div class="modal fade" id="show_<?= $row->key_protection ?>" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="exampleModalLabel"> <?= $row->title ?></h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?= $row->description ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- پایان مودال مشاهده توضیحات -->
                                    <?php endforeach ?>
                                    <?php } else { ?>
                                    <tr>
                                        <td colspan="6" class="alert alert-danger">هیچ اعلانی یافت نشد</td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </form>
                    <!-- Pagination -->
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php
                                $pagination_links = paginate_links([
                                    'total' => $total_pages,
                                    'current' => $paged,
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'array',
                                    'end_size' => 1,
                                    'mid_size' => 2,
                                    'prev_next' => true,
                                    'prev_text' => __('قبلی'),
                                    'next_text' => __('بعدی'),
                                    'add_args' => false,
                                    'add_fragment' => '',
                                ]);

                                if ($pagination_links) {
                                    foreach ($pagination_links as $link) {
                                        $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                                        echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                                    }
                                }
                                ?>
                        </ul>
                    </nav>
                    <!-- End Pagination -->
                </div>
            </div>
        </div>
        <!--End::row-1 -->

    </div>
</div>
<!-- End::app-content -->
<!-- message sweetalert -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".delete-btn").forEach(button => {
        button.addEventListener("click", function(event) {
            event.preventDefault(); // جلوگیری از رفتن به لینک مستقیماً

            let deleteUrl = this.getAttribute("data-url"); // گرفتن لینک حذف

            Swal.fire({
                title: "آیا مطمئن هستید؟",
                text: "این عملیات قابل بازگشت نیست!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#db4040",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "بله، حذف شود!",
                cancelButtonText: "لغو"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href =
                        deleteUrl; // انتقال به لینک حذف در صورت تأیید
                }
            });
        });
    });
});
</script>
<!-- end message sweetalert -->
<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->