<?php
/*
Template Name: ایجاد اعلان جدید
*/
include 'actions/action_notification.php';
check_access();
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ایحاد اعلان جدید</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">اعلان ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ایجاد اعلان جدید</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-light fa-bell custom-icon"></i>
                            ایجاد اعلان جدید
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-bank" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                                value="<?php echo md5(time()) ?>">
                                <input type="text" name="send_id" hidden class="form-control"
                                value="<?= custom_session_id(); ?>">
                            <div class="col-md-6">
                                <label class="form-label">اسم اعلان<span class="required">*</span></label>
                                <input id="title_input" type="text" name="title" class="form-control"
                                    placeholder="عنوان اعلان را وارد نمایید" value="<?= old('title') ?>">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label">نامک اعلان<span class="required">*</span></label>
                                <input id="slug_input" type="text" name="slug" class="form-control nofarsi"
                                    placeholder="نامک اعلان را وارد نمایید" value="<?= old('slug') ?>">
                            </div>
                            <div class=" col-md-12">
                                <label class="form-label">توضیحات اعلان<span class="required">*</span></label>
                                <textarea type="text" name="description" class="form-control"
                                    placeholder="توضیحات اعلان را وارد نمایید"><?= old("description") ?></textarea>
                            </div>
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">ارسال برای</label>
                                <select name="send_for" id="inputState" class="form-select form-select-lg">
                                    <option value="all" <?= old('send_for')=== 'all' ? 'selcted' : '' ?>>همه</option>
                                    <?php $rows = get_all_users();
                                    foreach($rows as $row) { ?>
                                    <option value="<?= $row->id ?>" <?= old('send_for') === $row->id ? 'selcted' : '' ?>><?= $row->fl_name ?></option>
                                <?php } ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">وضعیت</label>
                                <select name="status" id="inputState" class="form-select form-select-lg">
                                    <option value="active" <?= old('status')=== 'active' ? 'selcted' : '' ?>>فعال</option>
                                    <option value="deactive" <?= old('status') === 'deactive' ? 'selcted' : '' ?>>غیر فعال</option>
                                </select>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="save_notif" class="btn btn-primary btn-lg text">ثبت
                                    اعلان جدید</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->