<?php
/*
Template Name: مشاهده فاکتور
*/

if (!isset($_GET['action_show']) || empty($_GET['action_show'])) {
    get_template_part("404");
    exit;
}

check_access();
$key = sanitize_text_field($_GET['action_show']);
$table = "custom_orders";
$row = get_result_orders_by_transaction_id($table, $key);

if (!$row || $row->transaction_id != $key) {
    get_template_part("404");
    exit;
}

// تغییر عنوان صفحه داینامیک
add_filter('wp_title', fn($title) => 'مشاهده فاکتور شماره (' . $row->transaction_id . ')');
add_filter('the_title', fn($title) => 'مشاهده فاکتور شماره (' . $row->transaction_id . ')');

get_header();
get_sidebar();
?>

<div class="main-content app-content">
    <div class="container-fluid">

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">فاکتور شماره : <?= esc_html($row->transaction_id) ?></h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="#">فاکتور ها</a></li>
                    <li class="breadcrumb-item active">فاکتور شماره : <?= esc_html($row->transaction_id) ?></li>
                </ol>
            </div>
        </div>

        <div class="row row-sm" id="invoice">
            <div class="col-lg-12 col-md-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="d-lg-flex">
                            <h2 class="main-content-label mb-1">#<?= esc_html($row->transaction_id) ?></h2>
                            <div class="ms-auto">
                                <?php $in = get_result_invoice_by_transaction_id($key); ?>
                                <p class="mb-1"><span class="fw-semibold"> تاریخ ثبت فاکتور :</span>
                                    <?= jdate("Y/m/d", strtotime($in->created_at)). ' '. date("H:i", strtotime($in->created_at)) ?>
                                </p>
                                <p class="mb-0"><span class="fw-semibold"> تاریخ سررسید فاکتور :</span>
                                    <?= jdate("Y/m/d", strtotime($in->due_date)). ' '. date("H:i", strtotime($in->due_date)) ?>
                                </p>

                            </div>
                        </div>

                        <hr class="mg-b-40">

                        <div class="row row-sm">
                            <div class="col-lg-6">
                                <p class="h3">فاکتور از طرف:</p>
                                <?php $user = select_order($key); ?>
                                <address>
                                    <?= esc_html($user->name) ?> <br>
                                    <strong>آدرس:</strong> <?= esc_html($user->address) ?>
                                </address>
                            </div>
                            <div class="col-lg-6 text-end">
                                <p class="h3">فاکتور برای:</p>
                                <address>
                                    <?= get_bloginfo('name') ?>
                                </address>
                            </div>
                        </div>

                        <div class="table-responsive mg-t-40" style="font-size: 20px;">
                            <table class="table table-invoice table-bordered">
                                <thead>
                                    <tr>
                                        <th>نام محصول</th>
                                        <th>تصویر محصول</th>
                                        <th class="tx-center">تعداد</th>
                                        <th class="tx-right">قیمت</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $results = select_orders($key);
                                    $total_price = 0;
                                    foreach ($results as $res):
                                        $total_price += $res->price;
                                    ?>
                                    <tr>
                                        <td><?= esc_html($res->product_name) ?></td>
                                        <td class="tx-center"><img src="<?= esc_url($res->img_product) ?>" width="90">
                                        </td>
                                        <td class="tx-center"><?= esc_html($res->quantity) ?></td>
                                        <td class="tx-right"><?= number_format($res->price) ?> تومان</td>
                                    </tr>
                                    <?php endforeach; ?>
                                    <tr>
                                        <td colspan="2" rowspan="4">
                                            <div class="invoice-notes">
                                                <label class="main-content-label tx-13">بانک و قسط انتخاب شده
                                                    :</label><br>
                                                <p class="text-center"><img src="<?= esc_url($res->img_bank) ?>"
                                                        width="90"></p>
                                                <p class="text-center"><?= esc_html($res->ghest_time) ?> ماهه</p>
                                            </div>
                                        </td>
                                    <tr>
                                        <td class="tx-right tx-bold">مبلغ کل</td>
                                        <td class="tx-right">
                                            <h4 class="tx-bold"><?= number_format($total_price) ?> تومان</h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="card-footer text-end">
                        <button type="button" class="btn ripple btn-info mb-1 no-print" onclick="print_invoice();">
                            <i class="fe fe-printer me-1"></i> پرینت فاکتور
                        </button>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>

<?php get_footer(); ?>