<?php
/*
Template Name: ویرایش قسط
*/
include 'actions/action-aghsat.php';
if (!isset($_GET['action_edit']) || empty($_GET['action_edit']) && !isset($_GET['update']) && empty($_GET['update'])) {
    header('Location: ' . site_url('aghsat'));
    exit;
} else {
    $key = $_GET['action_edit'];
    $table = "custom_aghsat";
    $row = get_result_key($table, $key);
    if (!$row || $row->key_protection != $key) {
        header("location:aghsat");
    }
    // Set the dynamic title
    add_filter('wp_title', function ($title) use ($row) {
        return 'ویرایش قسط ' . "($row->ghest_time ماهه)";
    });

    add_filter('the_title', function ($title) use ($row) {
        return 'ویرایش قسط ' . "($row->ghest_time ماهه)";
    });
}
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ویرایش قسط (<?= $row->ghest_time ?> ماهه)</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">اقساط</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ویرایش قسط</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        timer: 5000,
                        timerProgressBar: true,
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-light fa-tablet-rugged custom-icon"></i>
                            ویرایش قسط <?= $row->ghest_time ?> ماهه
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-ghest" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                                value="<?= $row->key_protection ?>">
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">بانک ها</label>
                                <select name="bank_id" id="inputState" class="form-select form-select-lg">
                                    <?php $results = bank_results();
                                    if(!$results){
                                        echo '<option value="">هیچ بانک فعالی وجود ندارد</option>';
                                    }else{
                                        foreach ($results as $result):
                                    ?>
                                    <option value="<?= $result->id ?>"
                                        <?= $row->bank_id === $result->id ? 'selected' : '' ?>>
                                        <?= $result->bank_name ?>
                                    </option>
                                    <?php
                                    endforeach;
                            } ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">مدت زمان قسط <sup>بر اساس ماه</sup><span
                                        class="required">*</span></label>
                                <input type="text" id="title_input" name="ghest_time" class="form-control"
                                    placeholder="اسم قسط را وارد نمایید" value="<?= $row->ghest_time ?>">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label">نامک قسط<span class="required">*</span></label>
                                <input type="text" id="slug_input" name="slug" class="form-control nofarsi"
                                    placeholder="نامک قسط را وارد نمایید" value="<?= $row->slug ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">درصد سود<span class="required">*</span></label>
                                <input type="text" name="sood" class="form-control nofarsi sood"
                                    placeholder="درصد سود را وارد نمایید" value="<?= $row->sood ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">وضعیت</label>
                                <select name="status" id="inputState" class="form-select form-select-lg">
                                    <option value="active" <?= $row->status == 'active' ? 'selected' : '' ?>>فعال
                                    </option>
                                    <option value="deactive" <?= $row->status == 'deactive' ? 'selected' : '' ?>>غیر
                                        فعال</option>
                                </select>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="save-ghest" class="btn btn-primary btn-lg text">ویرایش
                                    قسط</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->