<?php get_header();
get_sidebar();
$role = $_SESSION['user_info']['user_role'];
?>
<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Start::page-header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">به پنل خوش آمدید</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">پیشخوان</a></li>
                </ol>
            </div>
        </div>

        <!-- End::page-header -->

        <!-- Start::row-1 -->
        <div class="row row-sm">
            <div class="col-sm-12 col-lg-12 col-xl-12">
                <div class="row row-sm">
                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="115px"
                                            height="115px" viewBox="0 0 24 24" fill="none">

                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />

                                            <g id="SVGRepo_iconCarrier">
                                                <path opacity="0.5"
                                                    d="M3.04492 11.75C3.17074 12.4643 3.34793 13.2912 3.55493 14.2572L3.9835 16.2572C4.47047 18.5297 4.71396 19.666 5.53903 20.333C6.3641 21 7.52617 21 9.85031 21H14.1493C16.4735 21 17.6355 21 18.4606 20.333C19.2857 19.666 19.5292 18.5297 20.0161 16.2572L20.4447 14.2572C20.6517 13.2912 20.8289 12.4643 20.9547 11.75H3.04492Z"
                                                    fill="#1C274C" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M9.25 14C9.25 13.5858 9.58579 13.25 10 13.25H14C14.4142 13.25 14.75 13.5858 14.75 14C14.75 14.4142 14.4142 14.75 14 14.75H10C9.58579 14.75 9.25 14.4142 9.25 14Z"
                                                    fill="#1C274C" />
                                                <path
                                                    d="M8.32934 2.6646C8.51459 2.29412 8.96509 2.14395 9.33557 2.32919C9.70606 2.51443 9.85623 2.96494 9.67098 3.33542L7.83606 7.00527C8.31924 7 8.84645 7 9.42196 7H14.5781C15.1537 7 15.681 7 16.1643 7.00527L14.3293 3.33542C14.1441 2.96494 14.2943 2.51443 14.6648 2.32919C15.0352 2.14395 15.4857 2.29412 15.671 2.6646L17.8721 7.06693C19.2252 7.17088 20.0742 7.43629 20.6221 8.11397C21.0575 8.65254 21.1984 9.32259 21.1466 10.25H21.0002C21.0501 10.25 21.0989 10.2549 21.146 10.2642C21.1209 10.6988 21.0538 11.1898 20.9552 11.75H3.04537C2.94669 11.1898 2.8796 10.6988 2.85449 10.2641C2.90163 10.2549 2.95036 10.25 3.00023 10.25H2.85346C2.80168 9.32259 2.94261 8.65254 3.378 8.11397C3.92588 7.43625 4.77501 7.17084 6.12819 7.0669L8.32934 2.6646Z"
                                                    fill="#1C274C" />
                                            </g>

                                        </svg>
                                    </div>
                                    <div class="card-item-title mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">تعداد
                                            محصولات</label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد محصولاتی که در سایت
                                            موجود است</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">
                                                <?php if ($role == "admin_site" || $role == "admin" || $role == "regional_manager") { ?>
                                                <a
                                                    href="<?= site_url('products') ?>"><?php echo get_count("custom_products") ?></a>
                                                <?php } else { ?>
                                                <?php echo get_count("custom_products") ?>
                                                <?php } ?>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg width="115px" height="115px" viewBox="0 0 1024 1024" version="1.1"
                                            xmlns="http://www.w3.org/2000/svg" fill="#000000">

                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />

                                            <g id="SVGRepo_iconCarrier">

                                                <path
                                                    d="M594.7 800.4H272.4c-10.7 0-19.4 8.7-19.4 19.4s8.7 19.4 19.4 19.4h322.3c10.7 0 19.4-8.7 19.4-19.4 0-10.8-8.7-19.4-19.4-19.4z"
                                                    fill="#005BFF" />

                                                <path d="M912.9 771.4v39H968c-8.1-22.7-29.7-39-55.1-39z"
                                                    fill="#E6E6E6" />

                                                <path
                                                    d="M815.6 675.9V235.2c0-16.1-13.1-29.1-29.1-29.1H80.6c-16.1 0-29.1 13.1-29.1 29.1v440.7c0 16.1 13.1 29.1 29.1 29.1h705.9c16.1 0.1 29.1-13 29.1-29.1z m-43.9-42c0 16-13.1 29.1-29.1 29.1h-618c-16 0-29.1-13.1-29.1-29.1V277.3c0-16 13.1-29.1 29.1-29.1h618c16 0 29.1 13.1 29.1 29.1v356.6z"
                                                    fill="#FFFFFF" />

                                                <path
                                                    d="M742.6 248.2h-618c-16 0-29.1 13.1-29.1 29.1v356.6c0 16 13.1 29.1 29.1 29.1h618c16 0 29.1-13.1 29.1-29.1V277.3c0-16-13.1-29.1-29.1-29.1z m-523.3 32.2c0-1.6 1.3-2.8 2.8-2.8h61.3c1.6 0 2.8 1.3 2.8 2.8v17.5c0 1.6-1.3 2.8-2.8 2.8h-61.3c-1.6 0-2.8-1.3-2.8-2.8v-17.5z m-30.3-3.5c6.6 0 11.9 5.3 11.9 11.9s-5.3 11.9-11.9 11.9c-6.6 0-11.9-5.3-11.9-11.9s5.4-11.9 11.9-11.9z m-39 0c6.6 0 11.9 5.3 11.9 11.9s-5.3 11.9-11.9 11.9c-6.6 0-11.9-5.3-11.9-11.9s5.3-11.9 11.9-11.9z m237.3 181.7c0 67.8-55.2 123-123 123s-123-55.2-123-123 55.2-123 123-123h9.7v113.3h113.3v9.7z m-90.1-38.7v-94.7c52.3 0 94.7 42.4 94.7 94.7h-94.7z m373.6 148.9H530.1c-5.4 0-9.7-4.3-9.7-9.7 0-5.4 4.3-9.7 9.7-9.7h140.7c5.4 0 9.7 4.3 9.7 9.7 0 5.3-4.3 9.7-9.7 9.7z m0-73.3H525.2c-5.4 0-9.7-4.3-9.7-9.7s4.3-9.7 9.7-9.7h145.6c5.4 0 9.7 4.3 9.7 9.7s-4.3 9.7-9.7 9.7z m0-73.4H461.2c-5.4 0-9.7-4.3-9.7-9.7s4.3-9.7 9.7-9.7h209.7c5.4 0 9.7 4.3 9.7 9.7s-4.4 9.7-9.8 9.7z m0-73.3H461.2c-5.4 0-9.7-4.3-9.7-9.7s4.3-9.7 9.7-9.7h209.7c5.4 0 9.7 4.3 9.7 9.7s-4.4 9.7-9.8 9.7z"
                                                    fill="#E6E6E6" />

                                                <path
                                                    d="M254.6 355.5c-52.6 4.9-93.9 49.3-93.9 103.1 0 57.1 46.5 103.6 103.6 103.6 53.8 0 98.2-41.3 103.1-93.9H254.6V355.5z"
                                                    fill="#FFFFFF" />

                                                <path
                                                    d="M274 335.6h-9.7c-67.8 0-123 55.2-123 123s55.2 123 123 123 123-55.2 123-123v-9.7H274V335.6z m93.4 132.8c-4.9 52.6-49.3 93.9-103.1 93.9-57.1 0-103.6-46.5-103.6-103.6 0-53.8 41.3-98.2 93.9-103.1v112.8h112.8z"
                                                    fill="#005BFF" />

                                                <path d="M297.2 325.2v94.7h94.7c0-52.3-42.4-94.7-94.7-94.7z"
                                                    fill="#005BFF" />

                                                <path
                                                    d="M150 288.8m-11.9 0a11.9 11.9 0 1 0 23.8 0 11.9 11.9 0 1 0-23.8 0Z"
                                                    fill="#FFFFFF" />

                                                <path
                                                    d="M189 288.8m-11.9 0a11.9 11.9 0 1 0 23.8 0 11.9 11.9 0 1 0-23.8 0Z"
                                                    fill="#FFFFFF" />

                                                <path
                                                    d="M222.1 300.7h61.3c1.6 0 2.8-1.3 2.8-2.8v-17.5c0-1.6-1.3-2.8-2.8-2.8h-61.3c-1.6 0-2.8 1.3-2.8 2.8v17.5c0 1.6 1.3 2.8 2.8 2.8z"
                                                    fill="#FFFFFF" />

                                                <path
                                                    d="M912.9 732.5c-47 0-86.3 33.5-95.3 77.8H701.9c-11.7 0-20.2-2.3-23.2-6.3-2-2.7-2-7-2-9v-51.1h109.9c37.5 0 67.9-30.5 67.9-67.9V235.2c0-37.5-30.5-67.9-67.9-67.9h-706c-37.5 0-67.9 30.5-67.9 67.9v440.7c0 37.5 30.5 67.9 67.9 67.9h557.2V795c0 4.8 0 19.3 9.9 32.4 10.9 14.4 29.1 21.7 54.2 21.7h308.2v-19.4c0-53.6-43.6-97.2-97.2-97.2zM80.6 705.1c-16.1 0-29.1-13.1-29.1-29.1V235.2c0-16.1 13.1-29.1 29.1-29.1h705.9c16.1 0 29.1 13.1 29.1 29.1v440.7c0 16.1-13.1 29.1-29.1 29.1H80.6z m832.3 105.2h-55.1c8-22.7 29.7-39 55.1-39s47.1 16.3 55.1 39h-55.1z"
                                                    fill="#005BFF" />

                                                <path
                                                    d="M670.8 329.4H461.2c-5.4 0-9.7 4.3-9.7 9.7s4.3 9.7 9.7 9.7h209.7c5.4 0 9.7-4.3 9.7-9.7s-4.4-9.7-9.8-9.7z"
                                                    fill="#005BFF" />

                                                <path
                                                    d="M670.8 402.7H461.2c-5.4 0-9.7 4.3-9.7 9.7s4.3 9.7 9.7 9.7h209.7c5.4 0 9.7-4.3 9.7-9.7s-4.4-9.7-9.8-9.7zM670.8 476.1H525.2c-5.4 0-9.7 4.3-9.7 9.7s4.3 9.7 9.7 9.7h145.6c5.4 0 9.7-4.3 9.7-9.7s-4.3-9.7-9.7-9.7z"
                                                    fill="#06F3FF" />

                                                <path
                                                    d="M670.8 549.4H530.1c-5.4 0-9.7 4.3-9.7 9.7 0 5.4 4.3 9.7 9.7 9.7h140.7c5.4 0 9.7-4.3 9.7-9.7 0-5.4-4.3-9.7-9.7-9.7z"
                                                    fill="#005BFF" />

                                            </g>

                                        </svg>
                                    </div>
                                    <div class="card-item-title  mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">طرح های
                                            فعال</label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد طرح های فعال</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">
                                                <?php if ($role == "admin_site" || $role == "admin" || $role == "regional_manager") { ?>
                                                <a
                                                    href="<?= site_url('aghsat') ?>"><?php echo get_count("custom_banks") ?></a>
                                                <?php } else { ?>
                                                <?php echo get_count("custom_banks") ?>
                                                <?php } ?>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if ($role == "admin" || $role == "admin_site" || $role == "regional_manager") { ?>
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg width="115px" height="115px" class="icon" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />
                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <g id="SVGRepo_iconCarrier">
                                                <path opacity="0.1" fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M18.1554 18.5659L18.087 18.4067C17.6996 17.3756 17.0535 16.6988 16.0488 16.2901C15.0618 15.8886 13.7385 15.75 12.0001 15.75C10.275 15.75 8.95912 15.8972 7.97442 16.3031C6.97373 16.7156 6.32558 17.3909 5.93304 18.4043L5.85652 18.5771C4.09876 16.9345 3 14.5956 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12C21 14.5897 19.9062 16.9239 18.1554 18.5659ZM8.75 10C8.75 8.20507 10.2051 6.75 12 6.75C13.7949 6.75 15.25 8.20507 15.25 10C15.25 11.7949 13.7949 13.25 12 13.25C10.2051 13.25 8.75 11.7949 8.75 10Z"
                                                    fill="#323232" />
                                                <path
                                                    d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z"
                                                    stroke="#323232" stroke-width="2" />
                                                <path
                                                    d="M15 10C15 11.6569 13.6569 13 12 13C10.3431 13 9 11.6569 9 10C9 8.34315 10.3431 7 12 7C13.6569 7 15 8.34315 15 10Z"
                                                    stroke="#323232" stroke-width="2" />
                                                <path
                                                    d="M6.16406 18.5C6.90074 16.5912 8.56373 16 12.0001 16C15.4661 16 17.128 16.5578 17.855 18.5"
                                                    stroke="#323232" stroke-width="2" stroke-linecap="round" />
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="card-item-title  mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">تعداد
                                            کاربران</label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد کاربران سایت</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">
                                                <a href="users">
                                                    <?php if ($role == "admin_site" || $role == "admin") {
                                                            echo get_count("custom_users");
                                                        } else {
                                                            echo get_count("custom_users", ['parent_id' => custom_session_id()]);
                                                        } ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } else { ?>
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg width="64px" height="64px" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">

                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />

                                            <g id="SVGRepo_iconCarrier">
                                                <path
                                                    d="M7.5 18C8.32843 18 9 18.6716 9 19.5C9 20.3284 8.32843 21 7.5 21C6.67157 21 6 20.3284 6 19.5C6 18.6716 6.67157 18 7.5 18Z"
                                                    stroke="#1C274C" stroke-width="1.5" />
                                                <path
                                                    d="M16.5 18.0001C17.3284 18.0001 18 18.6716 18 19.5001C18 20.3285 17.3284 21.0001 16.5 21.0001C15.6716 21.0001 15 20.3285 15 19.5001C15 18.6716 15.6716 18.0001 16.5 18.0001Z"
                                                    stroke="#1C274C" stroke-width="1.5" />
                                                <path d="M11 10.8L12.1429 12L15 9" stroke="#1C274C" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path
                                                    d="M2 3L2.26121 3.09184C3.5628 3.54945 4.2136 3.77826 4.58584 4.32298C4.95808 4.86771 4.95808 5.59126 4.95808 7.03836V9.76C4.95808 12.7016 5.02132 13.6723 5.88772 14.5862C6.75412 15.5 8.14857 15.5 10.9375 15.5H12M16.2404 15.5C17.8014 15.5 18.5819 15.5 19.1336 15.0504C19.6853 14.6008 19.8429 13.8364 20.158 12.3075L20.6578 9.88275C21.0049 8.14369 21.1784 7.27417 20.7345 6.69708C20.2906 6.12 18.7738 6.12 17.0888 6.12H11.0235M4.95808 6.12H7"
                                                    stroke="#1C274C" stroke-width="1.5" stroke-linecap="round" />
                                            </g>

                                        </svg>
                                    </div>
                                    <div class="card-item-title  mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">تعداد
                                            سفارشات</label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد سفارشات ثبت شده شما</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">

                                                <a href="manager_invoice">
                                                    <?= number_format(get_count("custom_orders", ['agent_id' => custom_session_id()])) ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg height="115px" width="115px" version="1.1" id="Layer_1"
                                            xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 392.533 392.533"
                                            xml:space="preserve" fill="#000000">

                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />

                                            <g id="SVGRepo_iconCarrier">
                                                <path style="fill:#FFFFFF;"
                                                    d="M266.667,329.568V32.711c0-6.012-4.848-10.925-10.925-10.925H32.711 c-6.012,0-10.925,4.848-10.925,10.925v296.857c0,22.691,18.489,41.18,41.18,41.18h219.087 C272.485,359.693,266.667,345.341,266.667,329.568z" />
                                                <path style="fill:#194F82;"
                                                    d="M81.519,224.84c8.857,0,16.097,7.176,16.097,16.097c0,6.012,4.848,10.925,10.925,10.925 c6.077,0,10.925-4.848,10.925-10.925c0-17.067-11.378-31.547-26.958-36.267v-7.111c0-6.012-4.848-10.925-10.925-10.925 c-6.077,0-10.925,4.848-10.925,10.925v7.111c-15.58,4.719-26.958,19.135-26.958,36.267c0,20.881,17.002,37.883,37.883,37.883 c-0.323,0.065,0,0,0.065,0c8.21,0.776,15.968,7.564,15.968,15.903c0,8.857-7.176,16.097-16.097,16.097s-16.097-7.176-16.097-16.097 c0-6.012-4.848-10.925-10.925-10.925s-10.925,4.849-10.925,10.925c0,17.067,11.378,31.547,26.958,36.267v7.046 c0,6.012,4.848,10.925,10.925,10.925c6.012,0,10.925-4.848,10.925-10.925v-7.046c15.58-4.719,26.958-19.135,26.958-36.267 c0-20.881-18.36-37.818-39.305-37.818c0.323-0.065,0,0-0.065,0c-8.21-0.776-14.545-7.628-14.545-15.968 C65.422,232.016,72.663,224.84,81.519,224.84z" />
                                                <path style="fill:#FFC10D;"
                                                    d="M359.822,164.525h-71.37v165.107c0,22.691,18.489,41.18,41.18,41.18l1.875-0.065 c0.065,0,0.065,0,0.129,0c21.786-1.099,39.176-19.006,39.176-41.051V175.386C370.747,169.374,365.834,164.525,359.822,164.525z" />
                                                <path style="fill:#56ACE0;"
                                                    d="M212.105,65.422H76.347c-6.012,0-10.925,4.848-10.925,10.925v55.467 c0,6.012,4.848,10.925,10.925,10.925h135.758c6.012,0,10.925-4.848,10.925-10.925V76.347 C223.03,70.335,218.117,65.422,212.105,65.422z" />
                                                <g>
                                                    <path style="fill:#194F82;"
                                                        d="M212.105,43.572H76.347c-18.036,0-32.711,14.675-32.711,32.711v55.467 c0,18.036,14.675,32.711,32.711,32.711h135.758c18.036,0,32.711-14.675,32.711-32.711V76.283 C244.816,58.246,230.141,43.572,212.105,43.572z M223.03,131.749c0,6.012-4.848,10.925-10.925,10.925H76.347 c-6.012,0-10.925-4.848-10.925-10.925V76.283c0-6.012,4.848-10.925,10.925-10.925h135.758c6.012,0,10.925,4.848,10.925,10.925 V131.749z" />
                                                    <path style="fill:#194F82;"
                                                        d="M233.891,228.396h-80.162c-6.012,0-10.925,4.848-10.925,10.925c0,6.012,4.848,10.925,10.925,10.925 h80.162c6.012,0,10.925-4.848,10.925-10.925C244.816,233.309,239.903,228.396,233.891,228.396z" />
                                                    <path style="fill:#194F82;"
                                                        d="M233.891,275.135h-80.162c-6.012,0-10.925,4.848-10.925,10.925c0,6.012,4.848,10.925,10.925,10.925 h80.162c6.012,0,10.925-4.849,10.925-10.925C244.816,280.048,239.903,275.135,233.891,275.135z" />
                                                    <path style="fill:#194F82;"
                                                        d="M359.822,142.61h-71.37V32.711C288.453,14.675,273.778,0,255.741,0H32.711 C14.675,0,0,14.675,0,32.711v296.857c0,34.78,28.186,62.966,62.966,62.966h266.667h2.457c0.388,0,0.776-0.129,1.164-0.129 c32.97-1.939,59.281-29.285,59.281-62.772V175.386C392.533,157.349,377.859,142.61,359.822,142.61z M62.966,370.747 c-22.691,0-41.18-18.489-41.18-41.18V32.711c0-6.012,4.848-10.925,10.925-10.925h223.03c6.012,0,10.925,4.848,10.925,10.925 v296.857c0,15.774,5.883,30.125,15.451,41.18H62.966z M370.747,329.568c0,22.044-17.39,40.016-39.176,41.051 c-0.065,0-0.065,0-0.129,0l-1.875,0.065c-22.691,0-41.18-18.489-41.18-41.18V164.525h30.19v147.459 c0,6.012,4.849,10.925,10.925,10.925s10.925-4.849,10.925-10.925V164.525h19.329c6.012,0,10.925,4.848,10.925,10.925v154.182h0.065 V329.568z" />
                                                </g>
                                            </g>

                                        </svg>
                                    </div>
                                    <div class="card-item-title  mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">فاکتور های تایید
                                            شده</label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد فاکتور های تایید
                                            شده</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">
                                                <a href="manager_invoice">
                                                    <?php if ($role == "admin_site" || $role == "admin") {
                                                        echo get_count("custom_invoices", ['status' => 'approved']);
                                                    } elseif ($role == "regional_manager") {
                                                        echo get_count("custom_invoices", ['user_id' => custom_session_id(), 'status' => 'approved']);
                                                    } else {
                                                        echo get_count("custom_invoices", ['agent_id' => custom_session_id(), 'status' => 'approved']);
                                                    } ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg height="115px" width="115px" version="1.1" id="Layer_1"
                                            xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 390.723 390.723"
                                            xml:space="preserve" fill="#000000">

                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />

                                            <g id="SVGRepo_iconCarrier">
                                                <path style="fill:#FFFFFF;"
                                                    d="M297.976,36.848c-6.465,6.529-15.709,10.861-25.471,10.861c-9.762,0-18.941-3.814-25.471-10.861 c-6.529,6.529-15.709,10.861-25.471,10.861c-9.762,0-18.941-3.814-25.471-10.861c-6.529,6.529-15.709,10.861-25.471,10.861 c-9.762,0-18.941-3.814-25.471-10.861c-6.465,6.529-15.709,10.861-25.471,10.861c-9.762,0-18.941-3.814-25.471-10.861 c-6.529,6.529-15.709,10.861-25.471,10.861c-3.232,0-5.947-0.517-9.244-1.099v298.085c2.715-0.517,5.947-1.099,9.244-1.099 c9.762,0,18.941,3.814,25.471,10.861c6.529-6.529,15.709-10.861,25.471-10.861s18.941,3.814,25.471,10.861 c6.529-6.529,15.709-10.861,25.471-10.861c9.762,0,18.941,3.814,25.471,10.861c6.529-6.529,15.709-10.861,25.471-10.861 c9.762,0,18.941,3.814,25.471,10.861c6.529-6.529,15.709-10.861,25.471-10.861c9.762,0,18.941,3.814,25.471,10.861 c6.529-6.529,15.709-10.861,25.471-10.861c3.232,0,5.947,0.517,9.244,1.099V46.093c-2.715,0.517-5.947,1.099-9.244,1.099 C313.75,47.127,305.023,43.378,297.976,36.848z" />
                                                <path style="fill:#194F82;"
                                                    d="M347.301,16.808c-4.331-1.616-9.244,0-11.895,3.232c-2.715,3.814-7.046,5.43-11.378,5.43 c-8.145,0-14.61-6.529-14.61-14.61C309.419,4.913,304.57,0,298.558,0c-5.947,0-10.861,4.848-10.861,10.861 c0,8.145-6.529,14.61-14.61,14.61c-8.663,0-15.192-6.529-15.192-14.61C257.895,4.913,253.047,0,247.035,0 c-5.947,0-10.861,4.848-10.861,10.861c0,8.145-6.529,14.61-14.61,14.61c-8.145,0-14.61-6.529-14.61-14.61 C206.954,4.913,202.106,0,196.093,0c-5.947,0-10.861,4.848-10.861,10.861c0,8.145-6.529,14.61-14.61,14.61 c-8.663,0-15.709-6.529-15.709-14.61C154.914,4.913,150.065,0,144.053,0c-5.947,0-10.861,4.848-10.861,10.861 c0,8.145-6.529,14.61-14.61,14.61s-14.61-6.529-14.61-14.61C103.972,4.913,99.124,0,93.112,0c-5.947,0-10.861,4.848-10.861,10.861 c0,8.145-6.529,14.61-14.61,14.61c-4.331,0-8.663-2.198-11.378-5.43c-2.715-3.814-7.564-4.848-11.895-3.232 c-4.331,1.616-7.046,5.43-7.046,10.279v336.549c0,4.331,2.715,8.663,7.046,10.279c4.331,1.616,9.244,0,11.895-3.232 c2.715-3.814,7.046-5.43,11.378-5.43c8.145,0,14.61,6.529,14.61,14.61c0,5.947,4.848,10.861,10.861,10.861 c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61s14.61,6.529,14.61,14.61c0,5.947,4.848,10.861,10.861,10.861 c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61c8.145,0,14.61,6.529,14.61,14.61 c0,5.947,4.848,10.861,10.861,10.861c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61s14.61,6.529,14.61,14.61 c0,5.947,4.848,10.861,10.861,10.861c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61 c8.145,0,14.61,6.529,14.61,14.61c0,5.947,4.848,10.861,10.861,10.861c5.948,0,10.861-4.848,10.861-10.861 c0-8.145,6.529-14.61,14.61-14.61c4.331,0,8.663,2.198,11.378,5.43c2.715,3.814,7.564,4.848,11.895,3.232 c4.331-1.616,7.046-5.43,7.046-10.279V26.57C354.93,22.238,351.633,17.907,347.301,16.808z M333.209,344.113 c-2.715-0.517-5.947-1.099-9.244-1.099c-9.762,0-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861 s-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861c-9.762,0-18.941,3.814-25.471,10.861 c-6.529-6.529-15.709-10.861-25.471-10.861c-9.762,0-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861 s-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861c-3.232,0-5.947,0.517-9.244,1.099V46.093 c2.715,0.517,5.947,1.099,9.244,1.099c9.762,0,18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861 c9.762,0,18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861c9.762,0,18.941-3.814,25.471-10.861 c6.529,6.529,15.709,10.861,25.471,10.861c9.762,0,18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861 s18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861c3.232,0,5.947-0.517,9.244-1.099V344.113z" />
                                                <path style="fill:#FFC10D;"
                                                    d="M93.499,327.37c-4.331-2.198-8.663-3.814-12.994-4.848V67.749c4.331-1.099,9.244-2.715,12.994-4.848 c7.564,3.814,16.291,5.947,25.471,5.947c9.244,0,17.907-2.198,25.471-5.947c7.564,3.814,16.291,5.947,25.471,5.947 c9.244,0,17.907-2.198,25.471-5.947c7.564,3.814,16.291,5.947,25.471,5.947c9.244,0,17.907-2.198,25.471-5.947 c7.564,3.814,16.291,5.947,25.471,5.947c9.244,0,17.907-2.198,25.471-5.947c4.331,2.198,8.663,3.814,12.994,4.848v254.707 c-4.331,1.099-9.244,2.715-12.994,4.848c-7.564-3.814-16.291-5.947-25.471-5.947c-9.244,0-17.907,2.198-25.471,5.947 c-7.564-3.814-16.291-5.947-25.471-5.947c-9.244,0-17.907,2.198-25.471,5.947c-7.564-3.814-16.291-5.947-25.471-5.947 c-9.244,0-17.907,2.198-25.471,5.947c-7.564-3.814-16.291-5.947-25.471-5.947C109.726,321.358,101.063,323.556,93.499,327.37z" />
                                                <g>
                                                    <path style="fill:#194F82;"
                                                        d="M102.356,88.889h19.523c5.947,0,10.861-4.848,10.861-10.861s-4.848-10.861-10.861-10.861h-19.523 c-5.947,0-10.861,4.848-10.861,10.861S96.409,88.889,102.356,88.889z" />
                                                    <path style="fill:#194F82;"
                                                        d="M121.879,183.725c5.947,0,10.861-4.848,10.861-10.861c0-5.947-4.848-10.861-10.861-10.861h-19.523 c-5.947,0-10.861,4.848-10.861,10.861c0,5.947,4.848,10.861,10.861,10.861H121.879z" />
                                                    <path style="fill:#194F82;"
                                                        d="M205.338,162.069h-19.523c-5.947,0-10.861,4.848-10.861,10.861c0,6.012,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.848,10.861-10.861C216.198,166.917,211.285,162.069,205.338,162.069z" />
                                                    <path style="fill:#194F82;"
                                                        d="M288.796,162.069h-19.523c-5.948,0-10.861,4.848-10.861,10.861c0,6.012,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.848,10.861-10.861C299.657,166.917,294.744,162.069,288.796,162.069z" />
                                                    <path style="fill:#194F82;"
                                                        d="M288.796,231.952h-19.523c-5.948,0-10.861,4.848-10.861,10.861c0,5.947,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.848,10.861-10.861C299.657,236.865,294.744,231.952,288.796,231.952z" />
                                                    <path style="fill:#194F82;"
                                                        d="M288.796,295.887h-19.523c-5.948,0-10.861,4.849-10.861,10.861c0,6.012,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.849,10.861-10.861C299.657,300.735,294.744,295.887,288.796,295.887z" />
                                                    <path style="fill:#194F82;"
                                                        d="M102.356,128.97h63.935c5.947,0,10.861-4.848,10.861-10.861s-4.848-10.861-10.861-10.861h-63.935 c-5.947,0-10.861,4.848-10.861,10.861S96.409,128.97,102.356,128.97z" />
                                                    <path style="fill:#194F82;"
                                                        d="M178.768,231.952h-66.651c-5.947,0-10.861,4.848-10.861,10.861c0,5.947,4.848,10.861,10.861,10.861 h66.651c5.947,0,10.861-4.848,10.861-10.861C189.629,236.865,184.716,231.952,178.768,231.952z" />
                                                </g>
                                            </g>

                                        </svg>
                                    </div>
                                    <div class="card-item-title  mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">فاکتور های در
                                            انتظار تایید
                                        </label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد فاکتور های در انتظار
                                            تایید</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">
                                                <a href="manager_invoice">
                                                    <?php if ($role == "admin_site" || $role == "admin") {
                                                        echo get_count("custom_invoices", ['status' => 'pending']);
                                                    } elseif ($role == "regional_manager") {
                                                        echo get_count("custom_invoices", ['user_id' => custom_session_id(), 'status' => 'pending']);
                                                    } else {
                                                        echo get_count("custom_invoices", ['agent_id' => custom_session_id(), 'status' => 'pending']);
                                                    } ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-4">
                        <div class="card custom-card">
                            <div class="card-body">
                                <div class="card-item">
                                    <div class="card-item-icon card-icon">
                                        <svg height="115px" width="115px" version="1.1" id="Layer_1"
                                            xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 390.723 390.723"
                                            xml:space="preserve" fill="#000000">

                                            <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round"
                                                stroke-linejoin="round" />

                                            <g id="SVGRepo_iconCarrier">
                                                <path style="fill:#FFFFFF;"
                                                    d="M297.976,36.848c-6.465,6.529-15.709,10.861-25.471,10.861c-9.762,0-18.941-3.814-25.471-10.861 c-6.529,6.529-15.709,10.861-25.471,10.861c-9.762,0-18.941-3.814-25.471-10.861c-6.529,6.529-15.709,10.861-25.471,10.861 c-9.762,0-18.941-3.814-25.471-10.861c-6.465,6.529-15.709,10.861-25.471,10.861c-9.762,0-18.941-3.814-25.471-10.861 c-6.529,6.529-15.709,10.861-25.471,10.861c-3.232,0-5.947-0.517-9.244-1.099v298.085c2.715-0.517,5.947-1.099,9.244-1.099 c9.762,0,18.941,3.814,25.471,10.861c6.529-6.529,15.709-10.861,25.471-10.861s18.941,3.814,25.471,10.861 c6.529-6.529,15.709-10.861,25.471-10.861c9.762,0,18.941,3.814,25.471,10.861c6.529-6.529,15.709-10.861,25.471-10.861 c9.762,0,18.941,3.814,25.471,10.861c6.529-6.529,15.709-10.861,25.471-10.861c9.762,0,18.941,3.814,25.471,10.861 c6.529-6.529,15.709-10.861,25.471-10.861c3.232,0,5.947,0.517,9.244,1.099V46.093c-2.715,0.517-5.947,1.099-9.244,1.099 C313.75,47.127,305.023,43.378,297.976,36.848z" />
                                                <path style="fill:#194F82;"
                                                    d="M347.301,16.808c-4.331-1.616-9.244,0-11.895,3.232c-2.715,3.814-7.046,5.43-11.378,5.43 c-8.145,0-14.61-6.529-14.61-14.61C309.419,4.913,304.57,0,298.558,0c-5.947,0-10.861,4.848-10.861,10.861 c0,8.145-6.529,14.61-14.61,14.61c-8.663,0-15.192-6.529-15.192-14.61C257.895,4.913,253.047,0,247.035,0 c-5.947,0-10.861,4.848-10.861,10.861c0,8.145-6.529,14.61-14.61,14.61c-8.145,0-14.61-6.529-14.61-14.61 C206.954,4.913,202.106,0,196.093,0c-5.947,0-10.861,4.848-10.861,10.861c0,8.145-6.529,14.61-14.61,14.61 c-8.663,0-15.709-6.529-15.709-14.61C154.914,4.913,150.065,0,144.053,0c-5.947,0-10.861,4.848-10.861,10.861 c0,8.145-6.529,14.61-14.61,14.61s-14.61-6.529-14.61-14.61C103.972,4.913,99.124,0,93.112,0c-5.947,0-10.861,4.848-10.861,10.861 c0,8.145-6.529,14.61-14.61,14.61c-4.331,0-8.663-2.198-11.378-5.43c-2.715-3.814-7.564-4.848-11.895-3.232 c-4.331,1.616-7.046,5.43-7.046,10.279v336.549c0,4.331,2.715,8.663,7.046,10.279c4.331,1.616,9.244,0,11.895-3.232 c2.715-3.814,7.046-5.43,11.378-5.43c8.145,0,14.61,6.529,14.61,14.61c0,5.947,4.848,10.861,10.861,10.861 c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61s14.61,6.529,14.61,14.61c0,5.947,4.848,10.861,10.861,10.861 c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61c8.145,0,14.61,6.529,14.61,14.61 c0,5.947,4.848,10.861,10.861,10.861c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61s14.61,6.529,14.61,14.61 c0,5.947,4.848,10.861,10.861,10.861c5.947,0,10.861-4.848,10.861-10.861c0-8.145,6.529-14.61,14.61-14.61 c8.145,0,14.61,6.529,14.61,14.61c0,5.947,4.848,10.861,10.861,10.861c5.948,0,10.861-4.848,10.861-10.861 c0-8.145,6.529-14.61,14.61-14.61c4.331,0,8.663,2.198,11.378,5.43c2.715,3.814,7.564,4.848,11.895,3.232 c4.331-1.616,7.046-5.43,7.046-10.279V26.57C354.93,22.238,351.633,17.907,347.301,16.808z M333.209,344.113 c-2.715-0.517-5.947-1.099-9.244-1.099c-9.762,0-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861 s-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861c-9.762,0-18.941,3.814-25.471,10.861 c-6.529-6.529-15.709-10.861-25.471-10.861c-9.762,0-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861 s-18.941,3.814-25.471,10.861c-6.529-6.529-15.709-10.861-25.471-10.861c-3.232,0-5.947,0.517-9.244,1.099V46.093 c2.715,0.517,5.947,1.099,9.244,1.099c9.762,0,18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861 c9.762,0,18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861c9.762,0,18.941-3.814,25.471-10.861 c6.529,6.529,15.709,10.861,25.471,10.861c9.762,0,18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861 s18.941-3.814,25.471-10.861c6.529,6.529,15.709,10.861,25.471,10.861c3.232,0,5.947-0.517,9.244-1.099V344.113z" />
                                                <path style="fill:#FFC10D;"
                                                    d="M93.499,327.37c-4.331-2.198-8.663-3.814-12.994-4.848V67.749c4.331-1.099,9.244-2.715,12.994-4.848 c7.564,3.814,16.291,5.947,25.471,5.947c9.244,0,17.907-2.198,25.471-5.947c7.564,3.814,16.291,5.947,25.471,5.947 c9.244,0,17.907-2.198,25.471-5.947c7.564,3.814,16.291,5.947,25.471,5.947c9.244,0,17.907-2.198,25.471-5.947 c7.564,3.814,16.291,5.947,25.471,5.947c9.244,0,17.907-2.198,25.471-5.947c4.331,2.198,8.663,3.814,12.994,4.848v254.707 c-4.331,1.099-9.244,2.715-12.994,4.848c-7.564-3.814-16.291-5.947-25.471-5.947c-9.244,0-17.907,2.198-25.471,5.947 c-7.564-3.814-16.291-5.947-25.471-5.947c-9.244,0-17.907,2.198-25.471,5.947c-7.564-3.814-16.291-5.947-25.471-5.947 c-9.244,0-17.907,2.198-25.471,5.947c-7.564-3.814-16.291-5.947-25.471-5.947C109.726,321.358,101.063,323.556,93.499,327.37z" />
                                                <g>
                                                    <path style="fill:#194F82;"
                                                        d="M102.356,88.889h19.523c5.947,0,10.861-4.848,10.861-10.861s-4.848-10.861-10.861-10.861h-19.523 c-5.947,0-10.861,4.848-10.861,10.861S96.409,88.889,102.356,88.889z" />
                                                    <path style="fill:#194F82;"
                                                        d="M121.879,183.725c5.947,0,10.861-4.848,10.861-10.861c0-5.947-4.848-10.861-10.861-10.861h-19.523 c-5.947,0-10.861,4.848-10.861,10.861c0,5.947,4.848,10.861,10.861,10.861H121.879z" />
                                                    <path style="fill:#194F82;"
                                                        d="M205.338,162.069h-19.523c-5.947,0-10.861,4.848-10.861,10.861c0,6.012,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.848,10.861-10.861C216.198,166.917,211.285,162.069,205.338,162.069z" />
                                                    <path style="fill:#194F82;"
                                                        d="M288.796,162.069h-19.523c-5.948,0-10.861,4.848-10.861,10.861c0,6.012,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.848,10.861-10.861C299.657,166.917,294.744,162.069,288.796,162.069z" />
                                                    <path style="fill:#194F82;"
                                                        d="M288.796,231.952h-19.523c-5.948,0-10.861,4.848-10.861,10.861c0,5.947,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.848,10.861-10.861C299.657,236.865,294.744,231.952,288.796,231.952z" />
                                                    <path style="fill:#194F82;"
                                                        d="M288.796,295.887h-19.523c-5.948,0-10.861,4.849-10.861,10.861c0,6.012,4.848,10.861,10.861,10.861 h19.523c5.947,0,10.861-4.849,10.861-10.861C299.657,300.735,294.744,295.887,288.796,295.887z" />
                                                    <path style="fill:#194F82;"
                                                        d="M102.356,128.97h63.935c5.947,0,10.861-4.848,10.861-10.861s-4.848-10.861-10.861-10.861h-63.935 c-5.947,0-10.861,4.848-10.861,10.861S96.409,128.97,102.356,128.97z" />
                                                    <path style="fill:#194F82;"
                                                        d="M178.768,231.952h-66.651c-5.947,0-10.861,4.848-10.861,10.861c0,5.947,4.848,10.861,10.861,10.861 h66.651c5.947,0,10.861-4.848,10.861-10.861C189.629,236.865,184.716,231.952,178.768,231.952z" />
                                                </g>
                                            </g>

                                        </svg>
                                    </div>
                                    <div class="card-item-title  mb-2">
                                        <label class="main-content-label fs-13 fw-bold mb-1">فاکتور های
                                            رد شده
                                        </label>
                                        <span class="d-block fs-12 mb-0 text-muted">تعداد فاکتور های که
                                            رد شده</span>
                                    </div>
                                    <div class="card-item-body">
                                        <div class="card-item-stat">
                                            <h4 class="fw-bold">
                                                <a href="manager_invoice">
                                                    <?php if ($role == "admin_site" || $role == "admin") {
                                                        echo get_count("custom_invoices", ['status' => 'rejected']);
                                                    } elseif ($role == "regional_manager") {
                                                        echo get_count("custom_invoices", ['user_id' => custom_session_id(), 'status' => 'rejected']);
                                                    } else {
                                                        echo get_count("custom_invoices", ['agent_id' => custom_session_id(), 'status' => 'rejected']);
                                                    } ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Start::row -->
                <div class="row row-sm banner-img">
                    <div class="col-sm-12 col-lg-12 col-xl-6">
                        <div class="card custom-card card-dashboard-calendar custom_card_dashboard">
                            <label class="main-content-label mb-2 pt-1">پرفروش‌ ترین محصولات</label>
                            <span class="d-block fs-12 mb-2 text-muted">۵ مورد از پر فروش ترین محصولات</span>
                            <marquee direction="up">
                                <div class="table-responsive">
                                    <table class="table m-b-0 transcations mt-2">
                                        <tbody>
                                            <?php
                                            $rows = count_product_sales_statistics();
                                            foreach ($rows as $row):
                                            ?>
                                            <tr>
                                                <td class="wd-5p">
                                                    <div class="main-img-user avatar-md">
                                                        <img alt="avatar" class="rounded-circle me-3"
                                                            src="<?= $row->img_product ?>">
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-middle ms-3">
                                                        <div class="d-inline-block">
                                                            <h6 class="mb-1"><?= $row->name_product ?></h6>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <?= number_format($row->price) ?> تومان</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-end">
                                                    <div class="d-inline-block">
                                                        <h6 class="mb-2 fs-15 fw-semibold"><?= $row->total_sales ?> فروش
                                                        </h6>
                                                        <p class="mb-0 tx-11 text-muted">
                                                            <?= jdate("Y/m/d", strtotime($row->created)) ?></p>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach ?>
                                        </tbody>
                                    </table>
                                </div>
                            </marquee>
                        </div>
                    </div>
                    <div class="col-sm-12 col-lg-12 col-xl-6">
                        <div class="card custom-card card-dashboard-calendar custom_card_dashboard">
                            <label class="main-content-label mb-2 pt-1"> مدیران منطقه فعال در طرح های مختلف
                            </label>
                            <span class="d-block fs-12 mb-2 text-muted">۵ مورد از مدیران فعال منطقه</span>
                            <marquee direction="up">
                                <div class="table-responsive">
                                    <table class="table text-nowrap table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th scope="col">نام طرح</th>
                                                <th scope="col">نام نماینده</th>
                                                <th scope="col">استان یا شهرستان</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $rows = select_namaynde();
                                            foreach ($rows as $row):
                                            ?>
                                            <tr>
                                                <th scope="row"><?= $row->bank_name ?></th>
                                                <td>
                                                    <?= $row->user_name ?>
                                                </td>
                                                <td><span
                                                        class="badge bg-success-transparent"><?= $row->province . '-' . $row->city ?></span>
                                                </td>
                                            </tr>
                                            <?php endforeach ?>
                                        </tbody>
                                    </table>
                                </div>
                            </marquee>
                        </div>
                    </div>
                    <div class="col-sm-12 col-lg-12 col-xl-12">
                        <div class="card custom-card overflow-hidden">
                            <div class="card-body">
                                <h2>آمار فروش سال جاری</h2>
                                <canvas id="salesChart" class="icon" width="400" height="200"></canvas>
                                <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    const apiUrl =
                                        "<?php echo esc_url(get_site_url()); ?>/wp-json/chart/v1/sales/";
                                    fetch(apiUrl)
                                        .then(response => response.json())
                                        .then(data => {
                                            const mah = data.mah; // ماه‌های ایرانی
                                            const sales = data.sales; // داده‌های فروش

                                            const ctx = document.getElementById('salesChart').getContext(
                                                '2d');
                                            const salesChart = new Chart(ctx, {
                                                type: 'bar',
                                                data: {
                                                    labels: mah,
                                                    datasets: [{
                                                        label: 'آمار فروش',
                                                        data: sales,
                                                        fill: true,
                                                        borderColor: 'rgb(75, 192, 192)',
                                                        tension: 0.1
                                                    }]
                                                },
                                                options: {
                                                    responsive: true,
                                                    scales: {
                                                        y: {
                                                            beginAtZero: true,
                                                            ticks: {
                                                                callback: function(value) {
                                                                    return value
                                                                        .toLocaleString(); // نمایش هزارگان بدون تومان در محور y
                                                                },
                                                                font: {
                                                                    family: 'fa', // فونت فارسی
                                                                    size: 14, // اندازه فونت
                                                                    weight: 'normal', // ضخامت فونت
                                                                    lineHeight: 1.5 // فاصله بین خطوط
                                                                }
                                                            }
                                                        },
                                                        x: {
                                                            ticks: {
                                                                font: {
                                                                    family: 'fa', // فونت فارسی
                                                                    size: 14, // اندازه فونت
                                                                    weight: 'normal', // ضخامت فونت
                                                                    lineHeight: 1.5 // فاصله بین خطوط
                                                                }
                                                            }
                                                        }
                                                    },
                                                    plugins: {
                                                        tooltip: {
                                                            callbacks: {
                                                                label: function(tooltipItem) {
                                                                    return tooltipItem.raw
                                                                        .toLocaleString() +
                                                                        ' تومان'; // اضافه کردن تومان به tooltip
                                                                }
                                                            },
                                                            bodyFont: {
                                                                family: 'fa', // فونت فارسی در tooltip
                                                                size: 14, // اندازه فونت
                                                                weight: 'normal', // ضخامت فونت
                                                                lineHeight: 1.5 // فاصله بین خطوط
                                                            },
                                                            titleFont: {
                                                                family: 'fa', // فونت فارسی در عنوان tooltip
                                                                size: 16, // اندازه فونت عنوان tooltip
                                                                weight: 'bold', // ضخامت فونت عنوان tooltip
                                                                lineHeight: 1.5 // فاصله بین خطوط عنوان tooltip
                                                            }
                                                        }
                                                    }
                                                }
                                            });
                                        })
                                        .catch(error => console.error('خطا در دریافت داده‌ها:', error));
                                });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End::row -->


            </div><!-- col end -->


        </div>
        <!-- End::row-1 -->

    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php include 'footer.php' ?>
<!-- Footer End -->