<?php
session_start();

require_once get_template_directory() . '/inc/jalalitime/fa_time.php';
function old($field_name, $type = 'text')
{
    if ($type === 'file' && isset($_FILES[$field_name]) && $_FILES[$field_name]['error'] === UPLOAD_ERR_OK) {
        $upload_dir = wp_upload_dir();
        $upload_file = $upload_dir['path'] . '/' . basename($_FILES[$field_name]['name']);
        move_uploaded_file($_FILES[$field_name]['tmp_name'], $upload_file);
        return $upload_file;
    }

    return isset($_POST[$field_name]) ? htmlspecialchars($_POST[$field_name], ENT_QUOTES, 'UTF-8') : '';
}

function dd($value)
{
    echo "<pre>";
    print_r($value);
    echo "</pre>";
    exit;
}

function create_custom_tables()
{
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();

    $tables = [
        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_aghsat` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `key_protection` VARCHAR(255) NOT NULL,
            `bank_id` BIGINT(20) NOT NULL,
            `ghest_time` BIGINT(20) NOT NULL,
            `slug` VARCHAR(255) NOT NULL,
            `sood` VARCHAR(255) NOT NULL,
            `status` ENUM('active','deactive') NOT NULL,
            `created_at` TIMESTAMP NOT NULL DEFAULT current_timestamp(),
            `updated_at` TIMESTAMP NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_arrived` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `user_id` BIGINT(20) NOT NULL,
            `invoice_id` BIGINT(20) NOT NULL,
            `img_arrived` VARCHAR(1000) NOT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            `updated_at` DATETIME NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_banks` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `key_protection` VARCHAR(255) NOT NULL,
            `bank_name` VARCHAR(255) NOT NULL,
            `slug` VARCHAR(255) NOT NULL,
            `logo_url` VARCHAR(255) NOT NULL,
            `status` ENUM('active','inactive') NOT NULL,
            `created_at` DATETIME DEFAULT current_timestamp(),
            `updated_at` DATETIME NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_cart_item` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `product_id` BIGINT(20) NOT NULL,
            `bank_id` BIGINT(20) NOT NULL,
            `ghest_id` BIGINT(20) NOT NULL,
            `quantity` BIGINT(20) NOT NULL,
            `price` BIGINT(255) NOT NULL,
            `session_id` BIGINT(20) NOT NULL,
            `agent_id` BIGINT(20) DEFAULT NULL,
            `created_at` TIMESTAMP NOT NULL DEFAULT current_timestamp(),
            `updated_at` TIMESTAMP NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_invoices` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `transaction_id` BIGINT(20) NOT NULL,
            `user_id` BIGINT(20) NOT NULL,
            `agent_id` BIGINT(20) NOT NULL,
            `seen` ENUM('noseen','seen') NOT NULL,
            `status` ENUM('pending','rejected','approved') NOT NULL,
            `total_price` BIGINT(255) NOT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            `due_date` DATETIME NOT NULL DEFAULT current_timestamp(),
            `updated_at` DATETIME NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_orders` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `transaction_id` BIGINT(20) NOT NULL,
            `product_id` BIGINT(20) NOT NULL,
            `bank_id` BIGINT(20) NOT NULL,
            `ghest_id` BIGINT(20) NOT NULL,
            `quantity` BIGINT(20) NOT NULL,
            `price` BIGINT(255) NOT NULL,
            `session_id` BIGINT(20) NOT NULL,
            `agent_id` BIGINT(20) NOT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            `update_at` DATETIME NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_products` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `key_protection` VARCHAR(255) NOT NULL,
            `name_product` VARCHAR(255) NOT NULL,
            `slug` VARCHAR(255) NOT NULL,
            `price` BIGINT(255) NOT NULL DEFAULT 0,
            `count_product` INT(255) NOT NULL DEFAULT 0,
            `img_product` VARCHAR(255) NOT NULL,
            `status` ENUM('active','deactive') NOT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            `updated_at` TIMESTAMP NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_rejected_notif` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `transaction_id` BIGINT(20) NOT NULL,
            `user_id` BIGINT(20) NOT NULL,
            `description` VARCHAR(255) NOT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            `updated_at` DATETIME NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_statistics` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `year` INT(11) NOT NULL,
            `month` INT(11) NOT NULL,
            `total_sales` INT(11) DEFAULT 0,
            `total_revenue` BIGINT(20) DEFAULT 0,
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_users` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `key_protection` VARCHAR(255) NOT NULL,
            `parent_id` INT(111) NOT NULL DEFAULT 0,
            `fl_name` VARCHAR(255) NOT NULL,
            `postal_code` VARCHAR(10) NOT NULL,
            `phone` VARCHAR(10) NOT NULL,
            `email` VARCHAR(255) NOT NULL,
            `username` VARCHAR(255) NOT NULL,
            `password` VARCHAR(255) NOT NULL,
            `province` VARCHAR(255) NOT NULL,
            `city` VARCHAR(255) NOT NULL,
            `zipcode` VARCHAR(10) NOT NULL,
            `address` VARCHAR(255) NOT NULL,
            `madrak` ENUM('diploma','associate','bachelor','master','phd') NOT NULL,
            `user_role` ENUM('admin_site','admin','regional_manager','representative') NOT NULL,
            `profile` VARCHAR(600) DEFAULT NULL,
            `created_at` TIMESTAMP NOT NULL DEFAULT current_timestamp(),
            `updated_at` TIMESTAMP NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
            PRIMARY KEY (`id`)
        ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_notifications` (
        `id` bigint(20) NOT NULL AUTO_INCREMENT,
        `key_protection` varchar(255) NOT NULL,
        `title` varchar(1000) NOT NULL,
        `slug` varchar(1200) NOT NULL,
        `description` varchar(10000) NOT NULL,
        `send_id` bigint(20) NOT NULL,
        `send_for` varchar(255) NOT NULL,
        `status` enum('active','deactive') NOT NULL,
        `created_at` datetime NOT NULL DEFAULT current_timestamp(),
        `update_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        PRIMARY KEY (`id`)
    ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_notification_reads` (
        `id` bigint(20) NOT NULL AUTO_INCREMENT,
        `notification_id` bigint(20) NOT NULL,
        `user_id` bigint(20) NOT NULL,
        `seen_at` datetime NOT NULL DEFAULT current_timestamp(),
        PRIMARY KEY (`id`)
    ) $charset_collate;",

        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_invoice_time` (
        `id` bigint(20) NOT NULL AUTO_INCREMENT,
        `key_protection` varchar(1000) NOT NULL,
        `invoice_time` bigint(11) NOT NULL,
        PRIMARY KEY (`id`)
    ) $charset_collate;",


        "CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}custom_customers` (
        `id` bigint(20) NOT NULL AUTO_INCREMENT,
        `key_protection` varchar(1000) NOT NULL,
        `fl_name` varchar(1000) NOT NULL,
        `postal_code` bigint(11) NOT NULL,
        `phone_number` bigint(11) NOT NULL,
        `zipcode` bigint(11) NOT NULL,
        `address` varchar(2000) NOT NULL,
        `invoice_id` bigint(255) NOT NULL,
        `created_at` datetime NOT NULL DEFAULT current_timestamp(),
        `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        PRIMARY KEY (`id`)
    ) $charset_collate;"


    ];

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    foreach ($tables as $table) {
        dbDelta($table);
    }
}


add_action('after_setup_theme', 'create_custom_tables');




add_theme_support('post-thumbnails');


function my_theme_enqueue_scripts()
{
    $scripts = array('main', 'custom', 'index', 'script', 'dataTables.min', 'apexcharts', 'chart', 'custom-switcher.min');

    foreach ($scripts as $script) {
        wp_enqueue_script("my-theme-$script", get_template_directory_uri() . "assets/js/$script.js", array('jquery'), null, true);
    }
}
add_action('wp_enqueue_scripts', 'my_theme_enqueue_scripts');

function my_theme_enqueue_styles()
{
    $styles = array('style', 'icons', 'icons.min');

    foreach ($styles as $style) {
        wp_enqueue_style("my-theme-$style", get_template_directory_uri() . "assets/css/$style.css", array(), null, 'all');
    }
}
add_action('wp_enqueue_scripts', 'my_theme_enqueue_styles');

function my_theme_activation_notice()
{
    // بررسی اینکه آیا این اعلان قبلاً نمایش داده شده است یا نه
    if (get_transient('my_theme_activation_notice')) {
        return;
    }

    // تنظیم متغیر ورژن قالب
    $theme_version = wp_get_theme()->get('Version');

    // تنظیم پیام اعلان
    $message = '<div class="info notice is-dismissible">';
    $message .= '<p><strong>خوش آمدید!</strong> شما در حال استفاده از سیستم مدیریت فروش اعتباری هستید</p>';
    $message .= '<p> نسخه ی قالب :  ' . esc_html($theme_version) . '</p>';
    $message .= '</div>';

    // نمایش پیام
    echo $message;

    // تنظیم ترنزینت برای عدم نمایش اعلان در هر بار بارگذاری
    set_transient('my_theme_activation_notice', true, 1 * 1 * 1); // این اعلان فقط یک بار در 24 ساعت نمایش داده می‌شود
}
add_action('admin_notices', 'my_theme_activation_notice');

function my_theme_activation_hook()
{
    // پس از فعال شدن قالب، ترنزینت تنظیم می‌شود
    delete_transient('my_theme_activation_notice');
}
add_action('after_switch_theme', 'my_theme_activation_hook');



// فراخوانی تابع در زمان فعالسازی قالب
add_action('after_switch_theme', 'create_custom_tables');


// function check_license() {
//     $domain = $_SERVER['HTTP_HOST']; // دریافت دامنه
//     $license_key = '123456789'; // لایسنس این دامنه
//     $license_server = 'https://blogscripts.ir/api/license.php?domain='. $domain .'&license='.$license_key; // ارسال فقط دامنه بدون مسیر    

//        $response = wp_remote_get($license_server);

//        $body = wp_remote_retrieve_body($response);
//        $data = json_decode($body, true);

//        if (!isset($data['status']) || $data['status'] !== 'valid') {
//            wp_die("لایسنس این قالب معتبر نیست! لطفاً با پشتیبانی تماس بگیرید.");
//        }
//    }


// add_action('after_setup_theme', 'check_license');



function mytheme_check_theme_update()
{
    $current_theme = wp_get_theme();
    $current_version = $current_theme->get('Version');
    $stored_version = get_option('mytheme_version');

    if ($stored_version !== $current_version) {
        update_option('mytheme_version', $current_version);
        // حالا بفرستش به صفحه‌ی changelog
        set_transient('mytheme_show_changelog', true, 60);
    }
}
add_action('admin_init', 'mytheme_check_theme_update');


function mytheme_redirect_to_changelog()
{
    if (get_transient('mytheme_show_changelog')) {
        delete_transient('mytheme_show_changelog');
        wp_safe_redirect(admin_url('themes.php?page=mytheme-changelog'));
        exit;
    }
}
add_action('admin_init', 'mytheme_redirect_to_changelog');



add_action('admin_menu', function () {
    add_theme_page(
        '🚀 تغییرات قالب',
        '🚀 تغییرات قالب',
        'manage_options',
        'mytheme-changelog',
        'mytheme_changelog_page'
    );
});

function mytheme_changelog_page()
{
    $content = mytheme_get_changelog_content();

    echo '<div class="wrap mytheme-changelog-wrap">';
    echo '<h1 style="margin-bottom: 20px;">📋 لیست تغییرات قالب</h1>';
    echo '<div class="changelog-box">' . $content . '</div>';
    echo '<a href="' . admin_url() . '" class="back-btn">🔙 بازگشت به پیشخوان</a>';
    echo '</div>';
}

function mytheme_enqueue_changelog_assets($hook)
{
    // اگه صفحه مورد نظر نبود، برنگرده
    if (!isset($_GET['page']) || $_GET['page'] !== 'mytheme-changelog') return;

    // بارگذاری فونت وزیر
    wp_enqueue_style('vazirmatn-font', 'https://cdn.fontcdn.ir/Font/Persian/Vazirmatn/Vazirmatn.css');

    // استایل سفارشی
    wp_add_inline_style('vazirmatn-font', '
        .mytheme-changelog-wrap {
            font-family: Vazirmatn, Tahoma, sans-serif;
        }
        .changelog-box {
            background: #fff;
            border-left: 4px solid #0073aa;
            padding: 20px;
            border-radius: 6px;
            margin-bottom: 20px;
        }
        .back-btn {
            display: inline-block;
            background: #0073aa;
            color: #fff;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 4px;
            transition: 0.3s;
        }
        .back-btn:hover {
            background: #005177;
            color: #fff;
        }
    ');
}
add_action('admin_enqueue_scripts', 'mytheme_enqueue_changelog_assets');




if (!defined('MYTHEME_CHANGELOG_SOURCE')) {
    define('MYTHEME_CHANGELOG_SOURCE', 'https://blogscripts.ir/version/downloads/CHANGELOG.md'); // یا مسیر فایل محلی
}

function mytheme_get_changelog_content()
{
    $source = MYTHEME_CHANGELOG_SOURCE;

    if (filter_var($source, FILTER_VALIDATE_URL)) {
        $response = wp_remote_get($source);
        if (is_wp_error($response)) {
            return '<div style="color: red;">❌ دریافت فایل changelog با خطا مواجه شد.</div>';
        }
        $raw = wp_remote_retrieve_body($response);
    } else {
        if (!file_exists($source)) {
            return '<div style="color: red;">❌ فایل changelog پیدا نشد.</div>';
        }
        $raw = file_get_contents($source);
    }

    $lines = explode("\n", $raw);
    $html = '';
    $is_ul_open = false;

    foreach ($lines as $line) {
        $line = trim($line);

        if (preg_match('/^## (.+)$/', $line, $match)) {
            if ($is_ul_open) {
                $html .= '</ul>';
                $is_ul_open = false;
            }
            $html .= '<h2 style="border-bottom: 1px solid #ddd; padding-bottom: 5px; margin-top: 30px;">📌 ' . esc_html($match[1]) . '</h2>';
        } elseif (preg_match('/^- (.+)$/', $line, $match)) {
            if (!$is_ul_open) {
                $html .= '<ul style="list-style: none; padding: 0; margin-top: 10px;">';
                $is_ul_open = true;
            }
            $html .= '<li style="margin-bottom: 8px;">🔹 ' . esc_html($match[1]) . '</li>';
        } elseif ($line === '') {
            if ($is_ul_open) {
                $html .= '</ul>';
                $is_ul_open = false;
            }
        }
    }

    // اگر فایل با یک لیست تموم شده باشه
    if ($is_ul_open) {
        $html .= '</ul>';
    }

    return $html;
}




function handleFormSubmission($table, $fields = [], $labels = [], $rules = [])
{
    $errors = [];

    foreach ($fields as $field) {
        $label = isset($labels[$field]) ? $labels[$field] : $field;
        $isRequired = isset($rules[$field]['required']) ? $rules[$field]['required'] : true; // پیش‌فرض: اجباری

        // اگر فیلد از نوع فایل باشد
        if (isset($_FILES[$field])) {
            if ($_FILES[$field]['error'] === UPLOAD_ERR_NO_FILE) {
                if ($isRequired) {
                    $errors[] = "فیلد <b>$label</b> اجباریست و باید یک فایل معتبر انتخاب کنید.";
                }
                continue;
            }

            // بررسی فرمت فایل
            $allowedFormats = ['jpg', 'jpeg', 'png'];
            $fileExtension = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));

            if (!in_array($fileExtension, $allowedFormats)) {
                $errors[] = "فیلد <b>$label</b> باید یکی از فرمت‌های jpg, jpeg, png باشد.";
            }

            // بررسی حجم فایل (مثلاً حداکثر ۵MB)
            if ($_FILES[$field]['size'] > 5 * 1024 * 1024) {
                $errors[] = "فیلد <b>$label</ب> نباید بیشتر از ۵ مگابایت باشد.";
            }
        } else { // اگر فیلد از نوع متن باشد
            $value = $_POST[$field] ?? '';

            if ($isRequired && empty($value)) {
                $errors[] = "فیلد <b>$label</b> اجباریست";
                continue;
            }

            // در صورتی که فیلد اختیاری باشد و خالی است، دیگر نیازی به ادامه اعتبارسنجی نیست
            if (!$isRequired && empty($value)) {
                continue;
            }

            // بررسی سایر قوانین (عدد بودن، طول مشخص و ...)
            if (isset($rules[$field])) {
                if (isset($rules[$field]['numeric']) && $rules[$field]['numeric'] && !ctype_digit($value)) {
                    $errors[] = "فیلد <b>$label</ب> باید عدد باشد.";
                }

                if (isset($rules[$field]['length']) && strlen($value) !== $rules[$field]['length']) {
                    $errors[] = "فیلد <b>$label</b> باید دقیقا {$rules[$field]['length']} رقم باشد.";
                }

                if (isset($rules[$field]['min_length']) && strlen($value) < $rules[$field]['min_length']) {
                    $errors[] = "فیلد <b>$label</b>  نباید کمتر از {$rules[$field]['min_length']} رقم باشد.";
                }

                if (isset($rules[$field]['max_length']) && strlen($value) > $rules[$field]['max_length']) {
                    $errors[] = "فیلد <b>$label</ب> نباید بیشتر از {$rules[$field]['max_length']} کاراکتر باشد.";
                }
            }
        }
    }

    if (!empty($errors)) {
        $errorMessages = implode('<br>', $errors);
        echo "<script>
                document.addEventListener('DOMContentLoaded', function() {
                 document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$errorMessages',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>";
        return; // اگر خطا وجود دارد، از تابع خارج شو
    }

    // اگر همه چیز خوب بود، داده‌ها را به دیتابیس وارد کنید
    global $wpdb;

    $data = [];
    $format = [];
    // جمع‌آوری داده‌ها
    foreach ($fields as $field) {
        // اگر فیلد آپلودی است و فایل آپلود شده موجود است
        if (isset($_FILES[$field]) && !empty($_FILES[$field]['name']) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {
            // آپلود فایل
            $upload_dir = wp_upload_dir();
            $upload_file = $upload_dir['path'] . '/' . basename($_FILES[$field]['name']);

            if (move_uploaded_file($_FILES[$field]['tmp_name'], $upload_file)) {
                // تبدیل مسیر مطلق به مسیر نسبی
                $relative_path = str_replace(ABSPATH, site_url('/'), $upload_file);
                $data[$field] = $relative_path; // مسیر فایل جدید
                $format[] = '%s';
            } else {
                echo "خطا در آپلود فایل <b>$field</b>";
            }
        } elseif (isset($_POST[$field])) {
            // دریافت مقدار متنی از فرم (برای فیلدهای غیر فایل)
            $value = sanitize_text_field($_POST[$field]);
            if ($field === 'password') {
                $value = password_hash($value, PASSWORD_DEFAULT); // هش کردن رمز عبور
            }
            $data[$field] = $value;
            $format[] = '%s';
        } else {
            $data[$field] = null;
            $format[] = '%s';
        }
    }

    // انجام عملیات INSERT یا UPDATE
    $query = $wpdb->get_var($wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE key_protection = %s", $_POST['key_protection']));
    if ($query !== null) {
        // بروزرسانی رکورد موجود
        $wpdb->update("{$wpdb->prefix}$table", $data, ['key_protection' => $_POST['key_protection']], $format, ['%s']);
        $message = "اطلاعات با موفقیت بروزرسانی شد.";
    } else {
        // درج رکورد جدید
        $wpdb->insert("{$wpdb->prefix}$table", $data, $format);
        $message = "اطلاعات با موفقیت ثبت شد.";
    }

    echo "<script>
    document.addEventListener('DOMContentLoaded', function() {
    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
    document.body.classList.add('swal-open'); 
        Swal.fire({
            icon: 'success',
            title: 'موفق!',
            text: '$message',
            confirmButtonText: 'باشه',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                document.querySelector('.swal2-container').classList.add('swal-active'); 
            },
            willClose: () => {
                document.body.classList.remove('swal-open');
                document.querySelector('.swal-overlay').remove();
            },
        });
    });
</script>";
}



function changer_password($user_id, $new_password)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_users";

    // مقدارهای جدیدی که قرار است آپدیت شوند
    $data = ['password' => $new_password];

    // شرط برای یافتن کاربر
    $where = ['id' => $user_id];

    // اجرای کوئری آپدیت
    $updated = $wpdb->update($table, $data, $where);
    $message = "رمز عبور با موفقیت تغییر کرد";

    echo "<script>
    document.addEventListener('DOMContentLoaded', function() {
    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
    document.body.classList.add('swal-open'); 
        Swal.fire({
            icon: 'success',
            title: 'موفق!',
            text: '$message',
            confirmButtonText: 'باشه',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                document.querySelector('.swal2-container').classList.add('swal-active'); 
            },
            willClose: () => {
                document.body.classList.remove('swal-open');
                document.querySelector('.swal-overlay').remove();
            },
        });
    });
</script>";

    return $updated !== false; // اگر موفق شد true، در غیر این صورت false
}

function custom_session_id()
{
    if (isset($_SESSION['user_info'])) {
        $user_info = $_SESSION['user_info'];
        $session_id = $user_info['id'];
        return $session_id;
    }
}

function update_user_session($user_id)
{

    global $wpdb;
    $table_users = $wpdb->prefix . 'custom_users';

    // دریافت اطلاعات جدید کاربر
    $user_data = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_users WHERE id = %d", $user_id), ARRAY_A);

    if ($user_data) {
        // بروزرسانی اطلاعات در SESSION
        $_SESSION['user_info'] = $user_data;
    }
}
update_user_session(custom_session_id());


add_filter('site_transient_update_themes', 'mylux_check_for_theme_update');
function mylux_check_for_theme_update($transient)
{
    if (empty($transient->checked)) return $transient;

    $theme_slug = 'MyLux_Credit_Sales_Management_System';
    $remote = wp_remote_get('https://blogscripts.ir/version/downloads/update.json');

    if (!is_wp_error($remote) && isset($remote['response']['code']) && $remote['response']['code'] == 200) {
        $data = json_decode(wp_remote_retrieve_body($remote));
        if (isset($data->new_version) && version_compare(wp_get_theme($theme_slug)->get('Version'), $data->new_version, '<')) {
            $transient->response[$theme_slug] = array(
                'theme'       => $theme_slug,
                'new_version' => $data->new_version,
                'url'         => 'https://blogscripts.ir/', // صفحه معرفی قالب
                'package'     => $data->download_url,
            );
        }
    }

    return $transient;
}


// pdoructs
function get_result_products($table, $name = '', $status = '', $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;
    $query = "SELECT * FROM {$wpdb->prefix}$table WHERE 1=1";

    if (!empty($name)) {
        $query .= $wpdb->prepare(" AND `name_product` LIKE %s", '%' . $wpdb->esc_like($name) . '%');
    }

    if ($status !== '') {
        $query .= $wpdb->prepare(" AND `status` = %s", $status);
    }

    // Check if the logged-in user is a Regional Manager
    if (isset($_SESSION['user_info']) && $_SESSION['user_info']['user_role'] === 'RegionalManager') {
        $regional_manager_id = $_SESSION['user_info']['id'];
        $query .= $wpdb->prepare(" AND `parent_id` = %d", $regional_manager_id);
    }

    $query .= " ORDER BY updated_at DESC";

    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ($query) AS total");
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);
    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}

// Product sales statistics

function count_product_sales_statistics()
{
    global $wpdb;
    $table_orders = $wpdb->prefix . "custom_orders";
    $table_product = $wpdb->prefix . "custom_products";

    $query = "
        SELECT
        p.id AS product_id,
        p.name_product AS name_product,
        p.img_product AS img_product,
        p.price AS price,
        p.created_at AS created,
        COALESCE(SUM(o.quantity), 0) AS total_sales
        FROM $table_product p
        LEFT JOIN $table_orders o ON p.id = o.product_id
        GROUP BY p.id
        ORDER BY total_sales DESC
        LIMIT 5";

    $results = $wpdb->get_results($query);

    return $results;
}

function select_namaynde()
{
    global $wpdb;
    $table_orders = $wpdb->prefix . "custom_orders";
    $table_users = $wpdb->prefix . "custom_users";
    $table_banks = $wpdb->prefix . "custom_banks";

    $query = "
        SELECT
        o.session_id AS session_id,
        o.bank_id AS bank_id,
        u.id AS user_id,
        u.fl_name AS user_name,
        u.user_role AS role_user,
        u.province AS province,
        u.city AS city,
        b.bank_name AS bank_name
        FROM $table_orders o
        INNER JOIN $table_users u ON o.session_id = u.id
        INNER JOIN $table_banks b ON o.bank_id = b.id
        WHERE u.user_role = 'regional_manager'
        AND o.id = (
            SELECT MAX(id) FROM $table_orders 
            WHERE session_id = o.session_id
        )
        LIMIT 5";

    $results = $wpdb->get_results($query);

    return $results;
}





// products orders
function get_result_products_orders($table, $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;
    $query = "SELECT * FROM {$wpdb->prefix}$table WHERE 1=1";


    $query .= " ORDER BY price ASC";

    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ($query) AS total");
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);
    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}

// users
function get_result_users($table, $name = '', $role = '', $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;
    $query = "SELECT * FROM {$wpdb->prefix}$table WHERE 1=1";

    if (!empty($name)) {
        $query .= $wpdb->prepare(" AND `fl_name` LIKE %s", '%' . $wpdb->esc_like($name) . '%');
    }

    if ($role !== '') {
        $query .= $wpdb->prepare(" AND `user_role` = %s", $role);
    }

    // گرفتن اطلاعات کاربر لاگین‌شده
    if (isset($_SESSION['user_info'])) {
        $current_user_role = $_SESSION['user_info']['user_role'];
        $current_user_id = $_SESSION['user_info']['id'];

        // اگر کاربر مدیر کل (admin) بود، اطلاعات admin_site رو نبینه
        if ($current_user_role === 'admin') {
            $query .= " AND `user_role` != 'admin_site'";
        }
        if ($current_user_role === 'representative') {
            $query .= " AND `user_role` = 'representative'";
        }

        // اگر کاربر مدیر منطقه (regional_manager) بود، فقط کاربران زیرمجموعه خودش رو ببینه
        if ($current_user_role === 'regional_manager') {
            $query .= $wpdb->prepare(" AND (`parent_id` = %d OR `id` = %d)", $current_user_id, $current_user_id);
        }
    }

    $query .= " ORDER BY id DESC";

    // اصلاح شمارش تعداد کل آیتم‌ها
    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ({$query}) AS total_query");

    // اضافه کردن محدودیت صفحه‌بندی
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);

    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}

function count_parent_user($id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_users";
    $query = $wpdb->prepare("SELECT COUNT(*) FROM $table WHERE parent_id = %d", $id);
    $result = $wpdb->get_var($query);
    return $result;
}

function get_namayandeh($parent_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_users";
    $query = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table WHERE parent_id = %d", $parent_id));
    return $query;
}

// banks
function get_result_banks($table, $name = '', $status = '', $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;
    $query = "SELECT * FROM {$wpdb->prefix}$table WHERE 1=1";

    if (!empty($name)) {
        $query .= $wpdb->prepare(" AND `bank_name` LIKE %s", '%' . $wpdb->esc_like($name) . '%');
    }

    if ($status !== '') {
        $query .= $wpdb->prepare(" AND `status` = %s", $status);
    }


    $query .= " ORDER BY id DESC";

    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ($query) AS total");
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);
    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}



function get_result_banks_orders($table, $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;
    $query = "SELECT * FROM {$wpdb->prefix}$table WHERE `status` = 'active'";
    $query .= "ORDER BY id DESC";
    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ($query) AS total");
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);
    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}

function bank_results()
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_banks";
    $query = $wpdb->prepare("SELECT * FROM $table");
    $results = $wpdb->get_results($query);
    return $results;
}

// aghsat
function get_result_aghsat($table, $name = '', $status = '', $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;

    // افزودن JOIN برای دریافت نام بانک از جدول custom_banks
    $query = "SELECT a.*, b.bank_name 
              FROM {$wpdb->prefix}$table AS a
              LEFT JOIN {$wpdb->prefix}custom_banks AS b ON a.bank_id = b.id
              WHERE 1=1";

    if (!empty($name)) {
        $query .= $wpdb->prepare(" AND a.ghest_time LIKE %s", '%' . $wpdb->esc_like($name) . '%');
    }

    if ($status !== '') {
        $query .= $wpdb->prepare(" AND a.status = %s", $status);
    }

    $query .= " ORDER BY a.bank_id ASC";

    // دریافت تعداد کل اقساط
    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}$table AS a WHERE 1=1");

    // اعمال محدودیت صفحه‌بندی
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);

    // دریافت نتایج
    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}


function InsertOrUpdateGhest($table, $fields = [], $labels = [], $rules = [])
{
    $errors = [];

    foreach ($fields as $field) {
        $label = isset($labels[$field]) ? $labels[$field] : $field;
        $isRequired = isset($rules[$field]['required']) ? $rules[$field]['required'] : true; // پیش‌فرض: اجباری

        $value = $_POST[$field] ?? '';

        if ($isRequired && empty($value)) {
            $errors[] = "فیلد <b>$label</b> اجباریست";
            continue;
        }

        if (!$isRequired && empty($value)) {
            continue;
        }

        // بررسی سایر قوانین (عدد بودن، طول و ...)
        if (isset($rules[$field])) {
            if (isset($rules[$field]['numeric']) && $rules[$field]['numeric']) {
                $errors[] = "فیلد <b>$label</b> باید عدد باشد.";
            }

            if (isset($rules[$field]['length']) && strlen($value) !== $rules[$field]['length']) {
                $errors[] = "فیلد <b>$label</b> باید دقیقا {$rules[$field]['length']} رقم باشد.";
            }

            if (isset($rules[$field]['min_length']) && strlen($value) < $rules[$field]['min_length']) {
                $errors[] = "فیلد <b>$label</b> نباید کمتر از {$rules[$field]['min_length']} رقم باشد.";
            }

            if (isset($rules[$field]['max_length']) && strlen($value) > $rules[$field]['max_length']) {
                $errors[] = "فیلد <b>$label</b> نباید بیشتر از {$rules[$field]['max_length']} کاراکتر باشد.";
            }
        }
    } // پایان `foreach`

    if (!empty($errors)) {
        $errorMessages = implode('<br>', $errors);
        echo "<script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$errorMessages',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>";
        return; // اگر خطا وجود دارد، از تابع خارج شو
    }

    // اگر همه چیز درست بود، اطلاعات را ذخیره کن
    global $wpdb;

    $data = [];
    $format = [];

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            $value = sanitize_text_field($_POST[$field]);
            if ($field === 'password') {
                $value = password_hash($value, PASSWORD_DEFAULT);
            }
            $data[$field] = $value;
            $format[] = '%s';
        } else {
            $data[$field] = null;
            $format[] = '%s';
        }
    }

    // بررسی `bank_id`
    $key_protection = isset($_POST['key_protection']) ? sanitize_text_field($_POST['key_protection']) : '';

    if ($key_protection > 0) {
        $query = $wpdb->get_var($wpdb->prepare("SELECT bank_id FROM {$wpdb->prefix}$table WHERE key_protection = %d", $key_protection));

        if ($query !== null) {
            $wpdb->update("{$wpdb->prefix}$table", $data, ['key_protection' => $key_protection], $format, ['%d']);
            $message = "اطلاعات با موفقیت بروزرسانی شد.";
        } else {
            $wpdb->insert("{$wpdb->prefix}$table", $data, $format);
            $message = "اطلاعات با موفقیت ثبت شد.";
        }

        echo "<script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                    icon: 'success',
                    title: 'موفق!',
                    text: '$message',
                    confirmButtonText: 'باشه',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    didOpen: () => {
                        document.querySelector('.swal2-container').classList.add('swal-active'); 
                    },
                    willClose: () => {
                        document.body.classList.remove('swal-open');
                        document.querySelector('.swal-overlay').remove();
                    },
                });
            });
        </script>";
    } else {
        echo "<script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: 'error',
                    title: 'خطا!',
                    text: 'شناسه بانک نامعتبر است.',
                    confirmButtonText: 'متوجه شدم'
                });
            });
        </script>";
    }
}



// count
function get_count($table, $conditions = [])
{
    global $wpdb;
    $table = $wpdb->prefix . $table;

    // شروع کوئری
    $sql = "SELECT COUNT(*) FROM $table";
    $params = [];

    // اگر شرطی وجود داشته باشد، به کوئری اضافه شود
    if (!empty($conditions)) {
        $sql .= " WHERE 1=1";
        foreach ($conditions as $column => $value) {
            $sql .= " AND $column = %s";
            $params[] = $value;
        }
    }

    // اجرای کوئری به‌صورت امن
    $query = $wpdb->get_var(empty($params) ? $sql : $wpdb->prepare($sql, ...$params));

    return $query;
}


function get_resultt($table, $bank_id)
{
    global $wpdb;
    $table = $wpdb->prefix . $table;
    $query = $wpdb->prepare("SELECT * FROM $table WHERE `status` = 'active' AND bank_id = %d ORDER BY `id` ASC", $bank_id);
    return $wpdb->get_results($query);
}

function get_result_key($table, $key)
{
    global $wpdb;
    $tb = $wpdb->prefix . $table;
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE key_protection = %s", $key);
    $result = $wpdb->get_row($query);
    return $result;
}

function get_result_id($table, $id)
{
    global $wpdb;
    $tb = $wpdb->prefix . $table;
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE id = %s", $id);
    $result = $wpdb->get_row($query);
    return $result;
}

function get_result_slug_bank($bank)
{
    global $wpdb;
    $tb = $wpdb->prefix . "custom_banks";
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE slug = %s", $bank);
    $result = $wpdb->get_row($query);
    return $result;
}

function get_delete($table, $key)
{
    global $wpdb;
    $tb = $wpdb->prefix . $table;
    $result = $wpdb->delete($tb, ['id' => $key], ['%d']);
    return $result;
}

// personal coede
function validate_national_code($code)
{
    // بررسی طول کد ملی
    if (!preg_match('/^\d{10}$/', $code)) {
        return false;
    }

    // تبدیل کد ملی به آرایه ارقام
    $digits = str_split($code);

    // اگر همه ارقام یکی باشند، نامعتبر است (مثلاً 1111111111)
    if (count(array_unique($digits)) === 1) {
        return false;
    }

    // محاسبه ضریب‌های وزن‌دار
    $sum = 0;
    for ($i = 0; $i < 9; $i++) {
        $sum += $digits[$i] * (10 - $i);
    }

    // محاسبه رقم کنترل
    $remainder = $sum % 11;
    $control_digit = ($remainder < 2) ? $remainder : (11 - $remainder);

    // بررسی صحت کد ملی
    return $control_digit == $digits[9];
}

// تابع بررسی لاگین کاربر
function custom_login($username, $password)
{
    global $wpdb;
    $username = sanitize_text_field($username);
    $table = $wpdb->prefix . 'custom_users';

    // فقط بر اساس نام کاربری جستجو کن (بدون بررسی پسورد در کوئری)
    $query = $wpdb->prepare("SELECT * FROM $table WHERE username = %s", $username);
    $user = $wpdb->get_row($query);

    // بررسی اینکه کاربر وجود دارد و پسورد درست است
    if ($user && password_verify($password, $user->password)) {
        // ذخیره اطلاعات کاربر در سشن
        store_user_info_in_session($user->id);
        wp_redirect(home_url());
        exit;
    } else {
        // نمایش پیغام خطا با SweetAlert در صورت ناموفق بودن ورود
        echo "<script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'error',
                title: 'خطا!',
                html: 'نام کاربری یا رمز عبور اشتباه است',
                confirmButtonText: 'متوجه شدم',
                allowOutsideClick: false,
                allowEscapeKey: false
            });
        });
        </script>";
    }
}


// تابع ذخیره اطلاعات کاربر در سشن
function store_user_info_in_session($user_id)
{
    global $wpdb;
    $table = $wpdb->prefix . 'custom_users';
    $query = $wpdb->prepare("SELECT * FROM $table WHERE id = %d", $user_id);
    $user_info = $wpdb->get_row($query, ARRAY_A);

    if ($user_info) {
        $_SESSION['user_info'] = $user_info;
    }
}

// تابع بررسی ورود کاربر (لاگین بودن) برای محافظت از صفحات
function check_user_logged_in()
{
    if (!isset($_SESSION['user_info'])) {
        wp_redirect(site_url('/login'));
        exit;
    }
}

// تابع دریافت نقش کاربری از جدول custom_users
function get_custom_user_role($user_id)
{
    global $wpdb;
    $table = $wpdb->prefix . 'custom_users';
    $query = $wpdb->prepare("SELECT user_role FROM $table WHERE id = %d", $user_id);
    $role = $wpdb->get_var($query);
    return $role;
}
function check_access()
{
    if (isset($_SESSION['user_info'])) {
        $user_info = $_SESSION['user_info'];
        $role = $user_info['user_role'];
        echo '<style>
                @font-face {
                    font-family: fa;
                    font-style: normal;
                    src: url(' . get_template_directory_uri() . '/assets/fonts/sans.ttf);
                }
                .error_access {
                    margin: 10%;
                    background-color: #ffffff;
                    padding: 20px;
                    width:80%;
                    border-radius: 10px;
                    font-family: fa;
                    color: #ff0303;
                    align_item : center;
                    text-align: center;
                    font-size: 20px;
                    border: 1px solid #cfcfcf;
                    box-shadow: 1px 15px 20px #cfcf;
                }
                    .text_error{
                    margin-bottom:2%;
                    }
                    .btn_back_home{
                    background-color: #004494;
                    padding: 10px;
                    border-radius: 10px;
                    text-align:center;
                    margin:2% 12%;
                    }
                    .btn_back_home a{
                    text-decoration: none;
                    color:#fff;
                    }

            </style>';

        if (($role == "admin_site" || $role == "admin") && is_page('register_proforma_invoice')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان مدیر سایت و یا مدیر کل دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }

        if (($role == "admin_site" || $role == "admin") && is_page('notifications_list')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان مدیر سایت و یا مدیر کل دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }

        if ($role == "representative" && is_page('users/create-user')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان نماینده دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }

        if (($role == "representative" || $role == "regional_manager") && is_page('products/new-product')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان مدیر منطقه و یا نماینده دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }

        if (($role == "representative" || $role == "regional_manager") && is_page('aghsat/new-ghest')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان مدیر منطقه و یا نماینده دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }

        if (($role == "representative" || $role == "regional_manager") && is_page('banks/new-bank')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان مدیر منطقه و یا نماینده دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }

        if (($role == "representative" || $role == "regional_manager") && is_page('notifications')) {
            echo '<div class="error_access"><span class="text_error">شما به عنوان مدیر منطقه و یا نماینده دسترسی به این صفحه ندارید</span>';
            echo '<div class="btn_back_home"><a href="' . home_url() . '">بازگشت به صفحه اصلی</a></div>';
            echo '</div>';
            exit;
        }
    }
}


// result aghsat where querystring
function get_sood_by_slug($slug)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_aghsat";
    $query = $wpdb->prepare("SELECT * FROM $table WHERE slug = %s", $slug);
    $result = $wpdb->get_row($query);
    return $result;
}

function get_user_by_username($username)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_users";
    $query = $wpdb->prepare("SELECT * FROM $table WHERE username = %s", $username);
    $result = $wpdb->get_row($query);
    return $result;
}


function get_insert_or_update_cart($product_id, $bank_id, $ghest_id, $price, $quantity, $session_id, $agent_id = '')
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_cart_item";

    $data_insert = [
        'product_id' => $product_id,
        'price' => $price,
        'bank_id' => $bank_id,
        'ghest_id' => $ghest_id,
        'quantity' => $quantity,
        'session_id' => $session_id,
        'agent_id' => $agent_id,
    ];

    $data_update = [
        'quantity' => $quantity,
        'price' => $price
    ];

    $where = [
        'product_id' => $product_id,
        'bank_id' => $bank_id,
        'ghest_id' => $ghest_id,
        'session_id' => $session_id,
        'agent_id' => $agent_id
    ];

    $format_insert = ['%d', '%d', '%d', '%d', '%d', '%s', '%s'];
    $format_update = ['%d', '%d'];
    $where_format = ['%d', '%d', '%d', '%d', '%s'];

    $query = $wpdb->get_var($wpdb->prepare(
        "SELECT product_id FROM $table WHERE product_id = %d AND bank_id = %d AND ghest_id = %d AND session_id = %d AND agent_id = %s",
        $product_id,
        $bank_id,
        $ghest_id,
        $session_id,
        $agent_id
    ));

    if ($query !== null) {
        // بروزرسانی رکورد موجود
        $wpdb->update($table, $data_update, $where, $format_update, $where_format);
        $message = "محصول با موفقیت در سبد خرید بروز رسانی شد";
    } else {
        // درج رکورد جدید
        $wpdb->insert($table, $data_insert, $format_insert);
        $message = "محصول با موفقیت به سبد خرید اضافه شد";
    }
    echo "<script>
    document.addEventListener('DOMContentLoaded', function() {
    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
    document.body.classList.add('swal-open'); 
        Swal.fire({
            icon: 'success',
            title: 'موفق!',
            text: '$message',
            confirmButtonText: 'باشه',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                document.querySelector('.swal2-container').classList.add('swal-active'); 
            },
            willClose: () => {
                document.body.classList.remove('swal-open');
                document.querySelector('.swal-overlay').remove();
            },
        });
    });
</script>";
}

function select_cart_item()
{
    global $wpdb;
    if (isset($_SESSION['user_info'])) {
        $user_info = $_SESSION['user_info'];
    }
    $session_id = $user_info['id'];
    $cart_table = $wpdb->prefix . "custom_cart_item";
    $products_table = $wpdb->prefix . "custom_products";
    $banks_table = $wpdb->prefix . "custom_banks";
    $ghest_table = $wpdb->prefix . "custom_aghsat";
    $users_table = $wpdb->prefix . "custom_users";
    $query = $wpdb->prepare("
        SELECT 
            cart.id AS cart_id,
            cart.price AS price,
            cart.agent_id AS agent_id,
            cart.quantity AS quantity,
            products.id AS product_id,
            products.name_product AS product_name,
            products.img_product AS img_product,
            banks.bank_name AS bank_name,
            banks.id AS bank_id,
            aghsat.id AS ghest_id,
            aghsat.ghest_time AS ghest_time,
            users.id as user_id,
            users.fl_name as name
        FROM $cart_table AS cart
        INNER JOIN $products_table AS products ON cart.product_id = products.id
        INNER JOIN $banks_table AS banks ON cart.bank_id = banks.id
        INNER JOIN $ghest_table AS aghsat ON cart.ghest_id = aghsat.id
        INNER JOIN $users_table AS users ON cart.agent_id = users.id
        WHERE cart.session_id = %d
    ", $session_id);

    $results = $wpdb->get_results($query);

    // دسته‌بندی نتایج بر اساس بانک، قسط و کاربر
    $grouped_results = [];
    foreach ($results as $result) {
        $bank_name = $result->bank_name;
        $ghest_time = $result->ghest_time;
        $agent_name = $result->name;
        if (!isset($grouped_results[$bank_name])) {
            $grouped_results[$bank_name] = [];
        }
        if (!isset($grouped_results[$bank_name][$ghest_time])) {
            $grouped_results[$bank_name][$ghest_time] = [];
        }
        if (!isset($grouped_results[$bank_name][$ghest_time][$agent_name])) {
            $grouped_results[$bank_name][$ghest_time][$agent_name] = [];
        }
        $grouped_results[$bank_name][$ghest_time][$agent_name][] = $result;
    }

    return $grouped_results;
}

function get_count_cart($session_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_cart_item";
    $query = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table WHERE session_id = %d", $session_id));
    return $query ?: '';
}

function get_delete_cart($cart_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_cart_item";
    $query = $wpdb->query($wpdb->prepare("DELETE FROM $table WHERE id = %d", $cart_id));
    return $query;
}

function transaction_generator()
{
    $session_id = custom_session_id();
    $transaction = time() . $session_id;
    return $transaction;
}

function getShamsiMonth($gregorianMonth, $year, $day = 1)
{
    $jalali = gregorian_to_jalali($year, $gregorianMonth, $day);
    return $jalali[1]; // شماره ماه شمسی
}

function fa_to_en($number)
{
    return strtr($number, ['۰' => '0', '۱' => '1', '۲' => '2', '۳' => '3', '۴' => '4', '۵' => '5', '۶' => '6', '۷' => '7', '۸' => '8', '۹' => '9']);
}


function AddToOrders($cart_item, $transaction_id)
{
    global $wpdb;
    $table_orders = $wpdb->prefix . "custom_orders";
    $table_invoices = $wpdb->prefix . "custom_invoices";
    $table_sales_statistics = $wpdb->prefix . "custom_statistics"; // جدول آمار فروش

    // ثبت اطلاعات سفارش در دیتابیس
    $wpdb->insert($table_orders, [
        'transaction_id' => $transaction_id,
        'product_id'     => $cart_item->product_id,
        'bank_id'        => $cart_item->bank_id,
        'ghest_id'       => $cart_item->ghest_id,
        'session_id'     => $cart_item->session_id,
        'agent_id'       => $cart_item->agent_id,
        'price'          => $cart_item->price,
        'quantity'       => $cart_item->quantity,
    ], ['%d', '%d', '%d', '%d', '%s', '%d', '%f', '%d']);

    // حذف فقط آیتم ثبت شده از سبد خرید
    $wpdb->query($wpdb->prepare(
        "DELETE FROM {$wpdb->prefix}custom_cart_item WHERE session_id = %s AND product_id = %d AND bank_id = %d AND ghest_id = %d AND agent_id = %d",
        $cart_item->session_id,
        $cart_item->product_id,
        $cart_item->bank_id,
        $cart_item->ghest_id,
        $cart_item->agent_id
    ));
    $total_amount = 0;
    // محاسبه مبلغ آیتم فعلی
    $total_amount += $cart_item->price;
    $table_invoice_time = $wpdb->prefix . "custom_invoice_time";
    $invoice_time_row = $wpdb->get_row("SELECT invoice_time FROM $table_invoice_time LIMIT 1");
    $days = $invoice_time_row->invoice_time ?? 0;
    $due_date = date('Y-m-d H:i:s', strtotime("+$days days"));

    // دریافت سال و ماه جاری
    $currentYear = fa_to_en(jdate('Y'));
    $currentMonth = fa_to_en(jdate('m'));

    // بررسی اینکه آیا برای این transaction_id قبلاً فاکتور ایجاد شده است؟
    $existing_invoice = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_invoices WHERE transaction_id = %d", $transaction_id));

    if ($existing_invoice) {
        // اگر فاکتور موجود است، فقط مبلغ را آپدیت کنیم
        $wpdb->update($table_invoices, [
            'total_price' => $existing_invoice->total_price += $total_amount,
        ], ['transaction_id' => $transaction_id], ['%f'], ['%d']);
    } else {
        // اگر هنوز فاکتوری برای این transaction_id ثبت نشده، آن را ایجاد کنیم
        $wpdb->insert($table_invoices, [
            'transaction_id' => $transaction_id,
            'user_id'        => $cart_item->session_id,
            'agent_id'       => $cart_item->agent_id,
            'total_price'    => $total_amount,
            'due_date'       => $due_date,
        ], ['%d', '%s', '%d', '%f', '%s']);
    }

    // 🟢 **به‌روزرسانی آمار فروش**
    $existing_stats = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $table_sales_statistics WHERE year = %d AND month = %d",
        $currentYear,
        $currentMonth
    ));

    if ($existing_stats) {
        // اگر رکورد موجود است، تعداد فروش و مبلغ کل را آپدیت کنیم
        $wpdb->update($table_sales_statistics, [
            'total_sales' => $existing_stats->total_sales + $cart_item->quantity,
            'total_revenue' => $existing_stats->total_revenue + $total_amount,
        ], ['year' => $currentYear, 'month' => $currentMonth], ['%d', '%f'], ['%d', '%d']);
    } else {
        // اگر هنوز آماری برای این ماه و سال ثبت نشده، یک رکورد جدید اضافه کنیم
        $wpdb->insert($table_sales_statistics, [
            'year' => $currentYear,
            'month' => $currentMonth,
            'total_sales' => $cart_item->quantity,
            'total_revenue' => $total_amount,
        ], ['%d', '%d', '%d', '%f']);
    }
}

function CountOrsersWhereNamayandeh($agent_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_orders";
    $query = $wpdb->prepare("SELECT COUNT(*) FROM $table WHERE agent_id = %d", $agent_id);
    $result = $wpdb->get_var($query);
    return $result;
}

// invoices
function get_result_invoices($table, $user_name = '', $status = '', $paged = 1, $posts_per_page = 10)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;

    $invoices = $wpdb->prefix . "custom_invoices";
    $users_table = $wpdb->prefix . "custom_users";

    // دریافت اطلاعات کاربر لاگین‌شده
    $current_user_id = custom_session_id();
    $current_user = $wpdb->get_row($wpdb->prepare("SELECT user_role, id FROM $users_table WHERE id = %d", $current_user_id));

    // کوئری اصلی با JOIN
    $query = "SELECT 
                  invoices.*,  
                  users.fl_name AS user_name ,
                  users.key_protection AS user_key 
              FROM $invoices AS invoices
              INNER JOIN $users_table AS users ON invoices.user_id = users.id
              WHERE 1=1"; // این WHERE ضروری است تا AND ها درست کار کنند

    // نمایش داده‌های مرتبط با کاربر
    if ($current_user) {
        if ($current_user->user_role == 'regional_manager') {
            // مدیر منطقه: نمایش فاکتورهای خودش + فاکتورهای نمایندگانش
            $query .= $wpdb->prepare(" AND (users.id = %d OR users.parent_id = %d)", $current_user_id, $current_user_id);
        } elseif ($current_user->user_role == 'representative') {
            // نماینده: فقط فاکتورهای خودش
            $query .= $wpdb->prepare(" AND invoices.agent_id = %d", $current_user_id);
        }
    }

    if (!empty($user_name)) {
        $query .= $wpdb->prepare(" AND users.fl_name LIKE %s", '%' . $wpdb->esc_like($user_name) . '%');
    }

    if ($status !== '') {
        $query .= $wpdb->prepare(" AND invoices.status = %s", $status);
    }

    $query .= " ORDER BY invoices.id DESC";

    // گرفتن تعداد کل رکوردها
    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ($query) AS total_query");

    // اعمال LIMIT و OFFSET
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);

    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}


function get_all_users()
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_users";
    $query = $wpdb->prepare("SELECT * FROM $table WHERE user_role = 'regional_manager' OR user_role = 'representative' ORDER BY `id`");
    $results = $wpdb->get_results($query);
    if (empty($results)) {
        return []; // اگر هیچ کاربری وجود نداشت، آرایه خالی برگردانده شود
    }
    return $results;
}

function can_delete_item($type, $id)
{
    global $wpdb;

    $table_orders = $wpdb->prefix . 'custom_orders';
    $column = '';

    // تعیین ستون مرتبط برای بررسی
    switch ($type) {
        case 'product':
            $column = 'product_id';
            $message = "این محصول در یک سفارش ثبت شده است و امکان حذف آن وجود ندارد.";
            break;
        case 'bank':
            $column = 'bank_id';
            $message = "این بانک در یک سفارش ثبت شده است و امکان حذف آن وجود ندارد.";
            break;
        case 'user':
            $column = 'agent_id'; // فرض کردم که `agent_id` نشان‌دهنده‌ی کاربر ثبت‌کننده‌ی سفارش است
            $message = "این کاربر در یک سفارش ثبت شده است و امکان حذف آن وجود ندارد.";
            break;
        case 'ghest':
            $column = 'ghest_id';
            $message = "این طرح اقساطی در یک سفارش ثبت شده است و امکان حذف آن وجود ندارد.";
            break;
        default:
            return "نوع نامعتبر است.";
    }

    // بررسی وجود رکورد مرتبط در جدول سفارشات
    $exists = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM $table_orders WHERE $column = %d",
        $id
    ));

    if ($exists > 0) {
        return $message;
    }

    return true; // اجازه‌ی حذف
}


function exsit_admin()
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_users";
    $exists = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM $table WHERE user_role = %s",
        'admin_site'
    ));
    return $exists;
}



function get_sales_statistics()
{
    global $wpdb;

    // نام ماه‌های شمسی
    $mah = ["فروردین", "اردیبهشت", "خرداد", "تیر", "مرداد", "شهریور", "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند"];

    // دریافت سال جاری
    $currentYear = fa_to_en(jdate('Y'));

    // مقدار پیش‌فرض برای هر ماه صفر است
    $sales = array_fill(0, 12, 0);

    // دریافت اطلاعات فروش گروه‌بندی شده بر اساس ماه
    $table = $wpdb->prefix . "custom_statistics";
    $query = $wpdb->prepare("
        SELECT month, SUM(total_revenue) as total_revenue 
        FROM $table 
        WHERE year = %d 
        GROUP BY month
        ORDER BY month ASC
    ", $currentYear);

    $results = $wpdb->get_results($query);

    // ذخیره اطلاعات فروش در آرایه
    foreach ($results as $row) {
        $monthIndex = $row->month - 1; // ایندکس آرایه از 0 شروع می‌شود
        $sales[$monthIndex] = (int)$row->total_revenue;
    }

    return rest_ensure_response([
        "mah" => $mah,
        "sales" => $sales
    ]);
}

// ثبت API در وردپرس
add_action('rest_api_init', function () {
    register_rest_route('chart/v1', '/sales/', [
        'methods' => 'GET',
        'callback' => 'get_sales_statistics',
        'permission_callback' => '__return_true'
    ]);
});

function select_orders($key)
{
    global $wpdb;
    $orders_table = $wpdb->prefix . "custom_orders";
    $products_table = $wpdb->prefix . "custom_products";
    $banks_table = $wpdb->prefix . "custom_banks";
    $ghest_table = $wpdb->prefix . "custom_aghsat";
    $users_table = $wpdb->prefix . "custom_users";
    $query = $wpdb->prepare("
        SELECT 
            orders.transaction_id AS t_id,
            orders.price AS price,
            orders.agent_id AS agent_id,
            orders.quantity AS quantity,
            products.id AS product_id,
            products.name_product AS product_name,
            products.img_product AS img_product,
            banks.bank_name AS bank_name,
            banks.logo_url AS img_bank,
            banks.id AS bank_id,
            aghsat.id AS ghest_id,
            aghsat.ghest_time AS ghest_time,
            users.id as user_id,
            users.fl_name as name
        FROM $orders_table AS orders
        INNER JOIN $products_table AS products ON orders.product_id = products.id
        INNER JOIN $banks_table AS banks ON orders.bank_id = banks.id
        INNER JOIN $ghest_table AS aghsat ON orders.ghest_id = aghsat.id
        INNER JOIN $users_table AS users ON orders.agent_id = users.id
        WHERE orders.transaction_id = %d
    ", $key);

    $results = $wpdb->get_results($query);

    return $results;
}

function select_order($key)
{
    global $wpdb;
    $orders_table = $wpdb->prefix . "custom_orders";
    $products_table = $wpdb->prefix . "custom_products";
    $banks_table = $wpdb->prefix . "custom_banks";
    $ghest_table = $wpdb->prefix . "custom_aghsat";
    $users_table = $wpdb->prefix . "custom_users";
    $query = $wpdb->prepare("
        SELECT 
            orders.transaction_id AS t_id,
            orders.price AS price,
            orders.agent_id AS agent_id,
            orders.quantity AS quantity,
            products.id AS product_id,
            products.name_product AS product_name,
            products.img_product AS img_product,
            banks.bank_name AS bank_name,
            banks.id AS bank_id,
            aghsat.id AS ghest_id,
            aghsat.ghest_time AS ghest_time,
            users.id as user_id,
            users.fl_name as name,
            users.address as address
        FROM $orders_table AS orders
        INNER JOIN $products_table AS products ON orders.product_id = products.id
        INNER JOIN $banks_table AS banks ON orders.bank_id = banks.id
        INNER JOIN $ghest_table AS aghsat ON orders.ghest_id = aghsat.id
        INNER JOIN $users_table AS users ON orders.agent_id = users.id
        WHERE orders.transaction_id = %d
    ", $key);

    $results = $wpdb->get_row($query);

    return $results;
}

function get_result_orders_by_transaction_id($table, $key)
{
    global $wpdb;
    $tb = $wpdb->prefix . $table;
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE transaction_id = %s", $key);
    $result = $wpdb->get_row($query);
    return $result;
}

function get_result_invoice_by_transaction_id($key)
{
    global $wpdb;
    $tb = $wpdb->prefix . "custom_invoices";
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE transaction_id = %s", $key);
    $result = $wpdb->get_row($query);
    return $result;
}

function get_invoice_by_id($invoice_id)
{
    global $wpdb;
    $tb = $wpdb->prefix . "custom_invoices";
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE id = %d", $invoice_id);
    $result = $wpdb->get_row($query);
    return $result;
}

function check_status_invoice($status)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_invoices";
    $query = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table WHERE `status` = %s", $status));
    return $query ?: "0";
}

function status_invoice($transaction_id, $status)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_invoices";

    // بررسی مقدار معتبر برای `transaction_id`
    if (!is_numeric($transaction_id) || intval($transaction_id) <= 0) {
        return false; // اگر مقدار `transaction_id` معتبر نبود، تابع متوقف شود
    }

    // مقدار جدیدی که باید آپدیت شود
    $data = ['status' => sanitize_text_field($status)];
    $where = ['transaction_id' => intval($transaction_id)];

    // اجرای آپدیت با مقداردهی صحیح
    $query = $wpdb->update($table, $data, $where, ['%s'], ['%d']);

    return ($query !== false) ? true : false;
}

function get_delete_invoice($transaction_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_orders";
    $where = ['transaction_id' => $transaction_id];
    $where_format = ['%d'];
    $delete = $wpdb->delete($table, $where, $where_format);
    return $delete;
}

function insert_rejected_notif($description, $transaction_id, $user_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_rejected_notif";

    // بررسی اینکه آیا transaction_id موجود است یا خیر
    $exist_id = $wpdb->get_var($wpdb->prepare("SELECT transaction_id FROM $table WHERE transaction_id = %d", $transaction_id));

    if ($exist_id !== null) {
        // اگر رکورد موجود بود، آن را به‌روزرسانی می‌کنیم
        $data = ['description' => $description, 'user_id' => $user_id];
        $where = ['transaction_id' => intval($transaction_id)];
        $format = ['%s', '%d']; // فرمت داده‌های ورودی
        $wpdb->update($table, $data, $where, $format);
    } else {
        // اگر رکورد وجود نداشت، یک رکورد جدید وارد می‌کنیم
        $data = [
            'transaction_id' => intval($transaction_id),
            'description' => $description,
            'user_id' => $user_id
        ];
        $format = ['%d', '%s', '%d']; // ترتیب باید درست باشد
        $wpdb->insert($table, $data, $format);
    }
}



function get_result_invoice($invoice_id)
{
    global $wpdb;
    $tb = $wpdb->prefix . "custom_invoices";
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE id = %s", $invoice_id);
    $result = $wpdb->get_row($query);
    return $result;
}

function insert_or_update_arrived($user_id, $invoice_id, $img_arrived)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_arrived";
    $table_invoices = $wpdb->prefix . "custom_invoices";
    $upload_dir = wp_upload_dir(); // دریافت مسیر آپلود وردپرس
    $user_folder = $upload_dir['path'] . '/' . $user_id; // پوشه مخصوص کاربر
    $upload_url = $upload_dir['url'] . '/' . $user_id; // مسیر قابل دسترسی از وب
    $uploaded_images = [];

    // بررسی و ایجاد پوشه کاربر اگر وجود نداشته باشد
    if (!file_exists($user_folder)) {
        mkdir($user_folder, 0755, true);
    }


    // بررسی وجود تصاویر آپلود شده
    if (isset($_FILES['arrived_images']) && !empty($_FILES['arrived_images']['name'][0])) {
        $files = $_FILES['arrived_images'];
        $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'];
        $max_size = 5 * 1024 * 1024; // 5MB

        foreach ($files['name'] as $key => $name) {
            $file_name = $files['name'][$key];
            $file_tmp = $files['tmp_name'][$key];
            $file_size = $files['size'][$key];
            $file_type = $files['type'][$key];
            $file_error = $files['error'][$key];

            if ($file_error === UPLOAD_ERR_OK) {
                if (in_array($file_type, $allowed_types)) {
                    if ($file_size <= $max_size) {
                        $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
                        $new_file_name = $file_name . '_' . custom_session_id() . '.' . $file_ext;
                        $file_destination = $user_folder . '/' . $new_file_name;
                        $file_url = $upload_url . '/' . $new_file_name; // مسیر کامل برای دیتابیس

                        if (move_uploaded_file($file_tmp, $file_destination)) {
                            $uploaded_images[] = $file_url;
                        } else {
                            // خطا در انتقال فایل
                            $message = "خطا در آپلود تصویر: " . $file_name;
                            echo "<script>
                                document.addEventListener('DOMContentLoaded', function() {
                                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                                document.body.classList.add('swal-open'); 
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'خطا!',
                                        text: '$message',
                                        confirmButtonText: 'باشه',
                                        allowOutsideClick: false,
                                        allowEscapeKey: false,
                                        didOpen: () => {
                                            document.querySelector('.swal2-container').classList.add('swal-active'); 
                                        },
                                        willClose: () => {
                                            document.body.classList.remove('swal-open');
                                            document.querySelector('.swal-overlay').remove();
                                        },
                                    });
                                });
                            </script>";
                            return; // خروج از تابع در صورت بروز خطا
                        }
                    } else {
                        // حجم فایل بیشتر از حد مجاز
                        $message = "حجم تصویر " . $file_name . " بیشتر از حد مجاز (5MB) است.";
                        echo "<script>
                            document.addEventListener('DOMContentLoaded', function() {
                            document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                            document.body.classList.add('swal-open'); 
                                Swal.fire({
                                    icon: 'error',
                                    title: 'خطا!',
                                    text: '$message',
                                    confirmButtonText: 'باشه',
                                    allowOutsideClick: false,
                                    allowEscapeKey: false,
                                    didOpen: () => {
                                        document.querySelector('.swal2-container').classList.add('swal-active'); 
                                    },
                                    willClose: () => {
                                        document.body.classList.remove('swal-open');
                                        document.querySelector('.swal-overlay').remove();
                                    },
                                });
                            });
                        </script>";
                        return; // خروج از تابع در صورت بروز خطا
                    }
                } else {
                    // نوع فایل مجاز نیست
                    $message = "نوع تصویر " . $file_name . " مجاز نیست (فقط jpg, png, jpeg).";
                    echo "<script>
                        document.addEventListener('DOMContentLoaded', function() {
                        document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                        document.body.classList.add('swal-open'); 
                            Swal.fire({
                                icon: 'error',
                                title: 'خطا!',
                                text: '$message',
                                confirmButtonText: 'باشه',
                                allowOutsideClick: false,
                                allowEscapeKey: false,
                                didOpen: () => {
                                    document.querySelector('.swal2-container').classList.add('swal-active'); 
                                },
                                willClose: () => {
                                    document.body.classList.remove('swal-open');
                                    document.querySelector('.swal-overlay').remove();
                                },
                            });
                        });
                    </script>";
                    return; // خروج از تابع در صورت بروز خطا
                }
            } else {
                // خطای کلی در آپلود
                $message = "خطا در آپلود تصویر: " . $file_name . " (کد خطا: " . $file_error . ")";
                echo "<script>
                    document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                        Swal.fire({
                            icon: 'error',
                            title: 'خطا!',
                            text: '$message',
                            confirmButtonText: 'باشه',
                            allowOutsideClick: false,
                            allowEscapeKey: false,
                            didOpen: () => {
                                document.querySelector('.swal2-container').classList.add('swal-active'); 
                            },
                            willClose: () => {
                                document.body.classList.remove('swal-open');
                                document.querySelector('.swal-overlay').remove();
                            },
                        });
                    });
                </script>";
                return; // خروج از تابع در صورت بروز خطا
            }
        }
    }

    // تبدیل آرایه نام فایل‌ها به رشته جدا شده با کاما
    $img_arrived = implode(',', $uploaded_images);

    $exsit_query = $wpdb->prepare("SELECT * FROM $table WHERE invoice_id = %d", $invoice_id);
    $exsit_result = $wpdb->get_results($exsit_query); // Get result to check
    if (!empty($exsit_result)) {
        $data_update = [
            'img_arrived' => $img_arrived
        ];
        $where = ['invoice_id' => $invoice_id];
        $format_update = ['%s'];
        $where_format = ['%d'];
        $wpdb->update($table, $data_update, $where, $format_update, $where_format);
        $invoice_update = [
            'status' => 'pending'
        ];
        $where_update = [
            'agent_id' => $user_id
        ];
        $wpdb->update($table_invoices, $invoice_update, $where_update);
        $message = "تصویر رسید با موفقیت بروز رسانی شد";
    } else {
        $data_insert = [
            'user_id' => $user_id,
            'invoice_id' => $invoice_id,
            'img_arrived' => $img_arrived,
        ];
        $invoice_update = [
            'status' => 'pending'
        ];
        $where_update = [
            'agent_id' => $user_id
        ];
        $format_insert = ['%d', '%d', '%s'];
        $wpdb->insert($table, $data_insert, $format_insert);
        $wpdb->update($table_invoices, $invoice_update, $where_update);
        $message = "تصویر رسید با موفقیت ارسال شد";
    }
    echo "<script>
    document.addEventListener('DOMContentLoaded', function() {
    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
    document.body.classList.add('swal-open'); 
        Swal.fire({
            icon: 'success',
            title: 'موفق!',
            text: '$message',
            confirmButtonText: 'باشه',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                document.querySelector('.swal2-container').classList.add('swal-active'); 
            },
            willClose: () => {
                document.body.classList.remove('swal-open');
                document.querySelector('.swal-overlay').remove();
            },
        });
    });
</script>";
}

function get_result_arrived($invoice_id)
{
    global $wpdb;
    $tb = $wpdb->prefix . "custom_arrived";
    $query = $wpdb->prepare("SELECT * FROM $tb WHERE invoice_id = %d", $invoice_id);
    $result = $wpdb->get_row($query);
    return $result;
}

function GetResultNotifRejected($user_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_rejected_notif";
    $query = $wpdb->prepare("SELECT * FROM $table WHERE user_id = %d", $user_id);
    $result = $wpdb->get_row($query);
    return $result;
}


function get_notifications($table, $name = '', $status = '', $paged = 1, $posts_per_page = 10, $user_id = null)
{
    global $wpdb;
    $offset = ($paged - 1) * $posts_per_page;

    $query = "SELECT n.*, 
                     u.fl_name AS receiver_name, 
                     sender.profile AS `profile`, 
                     sender.fl_name AS sender_name 
              FROM {$wpdb->prefix}$table AS n
              LEFT JOIN {$wpdb->prefix}custom_users AS u ON n.send_for = u.id
              LEFT JOIN {$wpdb->prefix}custom_users AS sender ON n.send_id = sender.id
              WHERE 1=1";

    if (!empty($name)) {
        $query .= $wpdb->prepare(" AND n.title LIKE %s", '%' . $wpdb->esc_like($name) . '%');
    }

    if ($status !== '') {
        $query .= $wpdb->prepare(" AND n.status = %s", $status);
    }

    // فقط اعلان‌های مخصوص کاربر یا عمومی
    if (!is_null($user_id)) {
        $query .= $wpdb->prepare(" AND (n.send_for = 'all' OR n.send_for = %d)", $user_id);
    }

    $query .= " ORDER BY n.id DESC";

    // شمارش کل
    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ({$query}) AS total_query");

    // صفحه‌بندی
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);

    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}


function notifications_list($paged = 1, $posts_per_page = 10, $user_id = null)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_notifications";
    $offset = ($paged - 1) * $posts_per_page;

    $query = "SELECT n.*, 
                     u.fl_name AS receiver_name, 
                     sender.profile AS `profile`, 
                     sender.fl_name AS sender_name 
              FROM $table AS n
              LEFT JOIN {$wpdb->prefix}custom_users AS u ON n.send_for = u.id
              LEFT JOIN {$wpdb->prefix}custom_users AS sender ON n.send_id = sender.id
              WHERE 1=1";

    // فقط اعلان‌های مخصوص کاربر یا عمومی
    if (!is_null($user_id)) {
        $query .= $wpdb->prepare(" AND (n.send_for = 'all' OR n.send_for = %d)", $user_id);
    }

    $query .= " ORDER BY n.id DESC";

    // شمارش کل
    $total_items = $wpdb->get_var("SELECT COUNT(*) FROM ({$query}) AS total_query");

    // صفحه‌بندی
    $query .= $wpdb->prepare(" LIMIT %d OFFSET %d", $posts_per_page, $offset);

    $results = $wpdb->get_results($query);

    return [
        'results' => $results,
        'total_items' => $total_items,
        'total_pages' => ceil($total_items / $posts_per_page),
    ];
}



function get_notification_id($notif_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_notifications";

    $query = $wpdb->prepare("
        SELECT n.*, 
               u.fl_name AS receiver_name, 
               sender.profile AS `profile`, 
               sender.fl_name AS sender_name 
        FROM {$table} AS n
        LEFT JOIN {$wpdb->prefix}custom_users AS u ON n.send_for = u.id
        LEFT JOIN {$wpdb->prefix}custom_users AS sender ON n.send_id = sender.id
        WHERE n.id = %d AND n.status = 'active'
        LIMIT 1
    ", $notif_id);

    $result = $wpdb->get_row($query);
    return $result;
}






function get_notifications_list($user_id = '')
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_notifications";

    $query = "SELECT n.*, 
                     u.fl_name AS receiver_name, 
                     sender.profile AS `profile`, 
                     sender.fl_name AS sender_name 
              FROM $table AS n
              LEFT JOIN {$wpdb->prefix}custom_users AS u ON n.send_for = u.id
              LEFT JOIN {$wpdb->prefix}custom_users AS sender ON n.send_id = sender.id
              WHERE 1=1 AND `status` = 'active'";

    // فقط اعلان‌های مخصوص کاربر یا عمومی
    if (!empty($user_id)) {
        $query .= $wpdb->prepare(" AND (n.send_for = 'all' OR n.send_for = %d)", $user_id);
    }

    $query .= " ORDER BY n.id DESC LIMIT 5";

    $results = $wpdb->get_results($query);
    return $results;
}


function get_count_notif($session_id = '')
{
    global $wpdb;

    if (empty($session_id)) {
        $session_id = custom_session_id(); // گرفتن آیدی کاربر فعلی
    }

    $notifications_table = $wpdb->prefix . "custom_notifications";
    $reads_table = $wpdb->prefix . "custom_notification_reads"; // جدول مشاهده‌شده‌ها

    // فقط اعلان‌هایی که یا برای همه هستن یا مخصوص این کاربرن و هنوز دیده نشده‌ن
    $query = $wpdb->get_var(
        $wpdb->prepare(
            "
            SELECT COUNT(*) 
            FROM $notifications_table n
            WHERE (`send_for` = 'all' OR `send_for` = %d)
            AND `status` = %s
            AND n.id NOT IN (
                SELECT notification_id 
                FROM $reads_table 
                WHERE user_id = %d
            )
            ",
            $session_id,
            'active',
            $session_id
        )
    );

    return $query ?: '';
}


function mark_notification_as_seen($notif_id)
{
    global $wpdb;

    $notif_id = intval($notif_id);
    $user_id  = intval(custom_session_id());

    if (!$notif_id || !$user_id) {
        return false; // داده معتبر نیست
    }

    $table = $wpdb->prefix . 'custom_notification_reads';

    // بررسی اگه قبلاً ثبت نشده، وارد کنه
    $exists = $wpdb->get_var(
        $wpdb->prepare("SELECT COUNT(*) FROM $table WHERE notification_id = %d AND user_id = %d", $notif_id, $user_id)
    );

    if (!$exists) {
        $wpdb->insert($table, [
            'notification_id' => $notif_id,
            'user_id'         => $user_id,
        ]);
    }

    return true;
}

function mark_all_notifications_as_seen()
{
    global $wpdb;
    $user_id = custom_session_id();

    $notif_table = $wpdb->prefix . 'custom_notifications';
    $read_table  = $wpdb->prefix . 'custom_notification_reads';

    // گرفتن آیدی نوتیف‌هایی که برای این کاربر یا عمومی هستن و هنوز خونده نشده‌ن
    $notif_ids = $wpdb->get_col(
        $wpdb->prepare("
            SELECT n.id
            FROM $notif_table n
            WHERE (n.send_for = 'all' OR n.send_for = %d)
            AND n.status = %s
            AND n.id NOT IN (
                SELECT notification_id FROM $read_table WHERE user_id = %d
            )
        ", $user_id, 'active', $user_id)
    );

    if (!empty($notif_ids)) {
        foreach ($notif_ids as $notif_id) {
            $wpdb->insert($read_table, [
                'notification_id' => $notif_id,
                'user_id'         => $user_id,
            ]);
        }
    }

    return count($notif_ids); // تعداد نوتیف‌هایی که به عنوان خوانده علامت خوردن
}


function get_persian_date_parts($datetime)
{
    $timestamp = strtotime($datetime);
    $now = strtotime(current_time('mysql'));
    $diff = $now - $timestamp;

    $time = date('H:i', $timestamp);
    $relative = '';
    $smart = '';

    // محاسبه حالت نسبی (چند دقیقه/ساعت پیش)
    if ($diff < 60) {
        $relative = 'لحظاتی پیش';
    } elseif ($diff < 3600) {
        $minutes = floor($diff / 60);
        $relative = $minutes . ' دقیقه پیش';
    } elseif ($diff < 86400) {
        $hours = floor($diff / 3600);
        $relative = $hours . ' ساعت پیش';
    } elseif ($diff < 172800) {
        $relative = 'دیروز';
    } else {
        $days = floor($diff / 86400);
        $relative = $days . ' روز پیش';
    }

    // محاسبه حالت هوشمند (امروز، دیروز، تاریخ شمسی)
    $date = date('Y-m-d', $timestamp);
    $today = date('Y-m-d', $now);
    $yesterday = date('Y-m-d', strtotime('-1 day', $now));

    if ($date === $today) {
        $smart = 'امروز';
    } elseif ($date === $yesterday) {
        $smart = 'دیروز';
    } else {
        if (function_exists('jdate')) {
            $smart = jdate('Y/m/d', $timestamp);
        } else {
            $smart = date('Y-m-d', $timestamp);
        }
    }

    return [
        'time' => $time,
        'relative' => $relative, // چند دقیقه/ساعت پیش
        'smart' => $smart        // امروز، دیروز یا تاریخ
    ];
}



function convert_to_persian_date($datetime)
{
    $timestamp = strtotime($datetime);
    return jdate('j F Y', $timestamp); // نیاز به پلاگین jdf (jalali date)
}

function convert_to_persian_time($time)
{
    $en_numbers = range(0, 10);
    $fa_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    return str_replace($en_numbers, $fa_numbers, $time);
}

function select_invoice_time()
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_invoice_time";
    $query = $wpdb->get_row("SELECT * FROM $table LIMIT 1");
    return $query;
}

function delete_invoice_where_pending_timer()
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_invoices";
    $date = current_time('mysql');
    $wpdb->query($wpdb->prepare("DELETE FROM $table WHERE due_date = %s AND `status` != %s", $date, 'approved'));
}

function select_customer_by_id($invoice_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "custom_customers";
    $query = $wpdb->prepare("SELECT * FROM $table WHERE invoice_id = %d", $invoice_id);
    $result = $wpdb->get_row($query);
    return $result;
}
