document.addEventListener("DOMContentLoaded", function () {
    let loader = document.querySelector("#loading");
    setTimeout(function () {
        loader.style.opacity = "0";
        setTimeout(() => loader.style.display = "none", 300); // بعد از انیمیشن کامل حذف کن
    }, 500); // کمی تأخیر برای جلوه بهتر
});

document.addEventListener('DOMContentLoaded', function () {
    document.querySelector('.togglePassword').addEventListener('click', function () {
        var passwordInput = document.querySelector('.inputPassword');
        var icon = this.querySelector('i');
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const Inputs = document.querySelectorAll(".zipcode, .postal-code, .phone_number, .days_invoice");
    const Inputs2 = document.querySelectorAll(".ghest_time");
    const profitInputs = document.querySelectorAll(".sood");

    Inputs.forEach(input => {
        input.addEventListener("input", function () {
            this.value = this.value.replace(/\D/g, '').slice(0, 10);
        });
    });
    Inputs2.forEach(input => {
        input.addEventListener("input", function () {
            this.value = this.value.replace(/\D/g, '').slice(0, 3);
        });
    });

    profitInputs.forEach(input => {
        input.addEventListener("input", function () {
            // فقط اعداد و یک نقطه اعشار را مجاز می‌کند
            this.value = this.value.replace(/[^0-9.]/g, '');

            // اطمینان حاصل می‌کند که فقط یک نقطه اعشار وجود دارد
            if ((this.value.match(/\./g) || []).length > 1) {
                this.value = this.value.slice(0, -1);
            }

            // محدود کردن به دو رقم اعشار
            const parts = this.value.split('.');
            if (parts[1] && parts[1].length > 2) {
                this.value = parts[0] + '.' + parts[1].slice(0, 2);
            }
        });
    });

});

document.addEventListener('DOMContentLoaded', function () {
    // حذف حروف فارسی پس از تایپ
    const noFarsiInputs = document.querySelectorAll('input.nofarsi');

    noFarsiInputs.forEach(function (input) {
        input.addEventListener('input', function () {
            let oldValue = this.value;
            this.value = this.value.replace(/[\u0600-\u06FF]/g, ''); // حذف حروف فارسی

            if (oldValue !== this.value) {
                showWarning();
            }
        });

        // جلوگیری از پیست حروف فارسی
        input.addEventListener('paste', function (event) {
            let clipboardData = event.clipboardData || window.clipboardData;
            let pastedText = clipboardData.getData('text');

            // حذف حروف فارسی از متن پیست شده
            let cleanedText = pastedText.replace(/[\u0600-\u06FF]/g, '');

            if (pastedText !== cleanedText) {
                event.preventDefault(); // جلوگیری از پیست شدن متن غیرمجاز
                this.value += cleanedText; // فقط متن فیلتر شده پیست شود
                showWarning();
            }
        });
    });

    // تابع نمایش پیغام هشدار
    function showWarning() {
        Swal.fire({
            toast: true,
            position: 'top-end', // گوشه بالا سمت راست
            icon: 'warning',
            title: 'لطفا فقط انگلیسی تایپ نمایید',
            showConfirmButton: false,
            timer: 2000
        });
    }
});



document.addEventListener('DOMContentLoaded', function () {
    // فقط اجازه ورود حروف فارسی و اعداد را می‌دهد
    const onlyFarsiInputs = document.querySelectorAll('input.onlyfarsi, textarea.onlyfarsi');

    onlyFarsiInputs.forEach(function (input) {
        input.addEventListener('input', function () {
            let oldValue = this.value;
            this.value = this.value.replace(/[^ء-ی\s۰-۹0-9-]/g, ''); // حذف کاراکترهای غیر مجاز

            if (oldValue !== this.value) {
                showWarning();
            }
        });

        // جلوگیری از پیست کاراکترهای غیر فارسی
        input.addEventListener('paste', function (event) {
            let clipboardData = event.clipboardData || window.clipboardData;
            let pastedText = clipboardData.getData('text');

            // حذف کاراکترهای غیرمجاز از متن پیست شده
            let cleanedText = pastedText.replace(/[^ء-ی\s۰-۹0-9-]/g, '');

            if (pastedText !== cleanedText) {
                event.preventDefault(); // جلوگیری از پیست شدن متن غیرمجاز
                this.value += cleanedText; // فقط متن فیلتر شده پیست شود
                showWarning();
            }
        });
    });

    // تابع نمایش پیغام هشدار
    function showWarning() {
        Swal.fire({
            toast: true,
            position: 'top-end', // گوشه بالا سمت راست
            icon: 'warning',
            title: 'لطفا فقط فارسی تایپ نمایید',
            showConfirmButton: false,
            timer: 2000
        });
    }
});
document.addEventListener('DOMContentLoaded', function () {
    const priceInputs = document.querySelectorAll('input.price');
    priceInputs.forEach(function (input) {
        input.addEventListener('input', function () {
            let value = this.value.replace(/,/g, ''); // حذف کاماهای قبلی
            value = value.replace(/\D/g, ''); // فقط اعداد

            if (value === '') {
                this.value = '';
                return;
            }

            // جدا کردن ۳ رقم ۳ رقم
            const formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ',');

            this.value = formatted;
        });
    });
});

document.addEventListener('DOMContentLoaded', function () {
    const imageUpload = document.getElementById('imageUpload');
    imageUpload.addEventListener('change', function (event) {
        var reader = new FileReader();
        reader.onload = function (e) {
            document.getElementById('preview').setAttribute('src', e.target.result);
            document.getElementById('preview').style.display = 'block'; // نمایش پیش‌نمایش
        };
        reader.readAsDataURL(this.files[0]); // خواندن فایل انتخاب‌شده
    });
});

document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('profileInput').addEventListener('change', function (event) {
        const file = event.target.files[0];
        if (file) {
            document.getElementById('profileFileName').textContent = file.name;
            const reader = new FileReader();
            reader.onload = function (e) {
                const previewImage = document.getElementById('profilePreview');
                previewImage.src = e.target.result;
                previewImage.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            document.getElementById('profileFileName').textContent = 'هیچ فایلی انتخاب نشده است.';
            document.getElementById('profilePreview').style.display = 'none';
        }
    });
});

document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('backgroundInput').addEventListener('change', function (event) {
        const file = event.target.files[0];
        if (file) {
            document.getElementById('backgroundFileName').textContent = file.name;
            const reader = new FileReader();
            reader.onload = function (e) {
                const previewImage = document.getElementById('backgroundPreview');
                previewImage.src = e.target.result;
                previewImage.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            document.getElementById('backgroundFileName').textContent = 'هیچ فایلی انتخاب نشده است.';
            document.getElementById('backgroundPreview').style.display = 'none';
        }
    });
});

document.addEventListener('DOMContentLoaded', function () {
    // هنگام کلیک روی هر تب
    document.querySelectorAll('.nav-link').forEach(function (tab) {
        tab.addEventListener('click', function () {
            // ذخیره شناسه تب فعال در localStorage
            var activeTabId = this.getAttribute('href').substring(1); // دریافت شناسه تب فعال (بدون #)
            localStorage.setItem('activeTab', activeTabId); // ذخیره شناسه تب فعال
        });
    });

    // هنگام بارگذاری صفحه
    var activeTab = localStorage.getItem('activeTab'); // دریافت شناسه تب فعال ذخیره‌شده
    if (activeTab) {
        // حذف کلاس active از تمام تب‌ها
        document.querySelectorAll('.nav-link').forEach(function (tab) {
            tab.classList.remove('active');
        });
        // فعال کردن تب مورد نظر
        var activeTabLink = document.querySelector(`.nav-link[href="#${activeTab}"]`);
        if (activeTabLink) {
            activeTabLink.classList.add('active');
        }

        // فعال کردن محتوای تب (قسمت مربوط به هر تب)
        document.querySelectorAll('.tab-pane').forEach(function (tabContent) {
            tabContent.classList.remove('active', 'show'); // حذف کلاس‌های فعال قبلی
        });
        var activeTabContent = document.getElementById(activeTab);
        if (activeTabContent) {
            activeTabContent.classList.add('active', 'show'); // فعال کردن محتوای تب
        }
    }
});
document.addEventListener('DOMContentLoaded', function () {
    var filePath = document.getElementById('example_file_path').value;
    if (filePath) {
        var fileInput = document.getElementById('imageUpload');
        var dataTransfer = new DataTransfer();
        var file = new File([filePath], filePath.split('/').pop(), { type: 'image/jpeg' });
        dataTransfer.items.add(file);
        fileInput.files = dataTransfer.files;
    }
});


document.addEventListener('DOMContentLoaded', function () {
    const copyBtn = document.getElementById('copy_link');
    const input = document.getElementById('link_user');

    copyBtn.addEventListener('click', function () {
        const text = input.value;

        navigator.clipboard.writeText(text).then(function () {
            Swal.fire({
                icon: 'success',
                title: 'لینک کپی شد!',
                text: 'لینک معرفی با موفقیت کپی شد.',
                confirmButtonText: 'باشه'
            });
        }).catch(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'خطا!',
                text: 'کپی لینک انجام نشد: ' + err,
                confirmButtonText: 'باشه'
            });
        });
    });
});



document.addEventListener("DOMContentLoaded", function () {
    const decreaseBtns = document.querySelectorAll(".decrease");
    const increaseBtns = document.querySelectorAll(".increase");
    const quantityInputs = document.querySelectorAll(".quantity");

    let intervals = []; // برای نگه داشتن interval‌ها برای هر دکمه
    let isPressed = []; // بررسی اینکه موس نگه داشته شده یا نه

    function updateQuantity(input, amount) {
        let value = parseInt(input.value) || 1;
        value = Math.max(1, value + amount); // حداقل 1
        input.value = value;
    }

    // شروع تغییرات مداوم با نگه داشتن دکمه
    decreaseBtns.forEach((decreaseBtn, index) => {
        decreaseBtn.addEventListener("mousedown", function (e) {
            e.preventDefault();
            if (isPressed[index]) return; // جلوگیری از اجرای چند باره
            isPressed[index] = true;
            updateQuantity(quantityInputs[index], -1); // کم کردن مقدار
            intervals[index] = setInterval(() => updateQuantity(quantityInputs[index], -1), 100); // هر 100 میلی‌ثانیه تغییرات ادامه پیدا کنه
        });
    });

    increaseBtns.forEach((increaseBtn, index) => {
        increaseBtn.addEventListener("mousedown", function (e) {
            e.preventDefault();
            if (isPressed[index]) return; // جلوگیری از اجرای چند باره
            isPressed[index] = true;
            updateQuantity(quantityInputs[index], 1); // افزایش مقدار
            intervals[index] = setInterval(() => updateQuantity(quantityInputs[index], 1), 100); // هر 100 میلی‌ثانیه تغییرات ادامه پیدا کنه
        });
    });

    // زمانی که موس رو رها کنی یا از دکمه خارج بشه
    document.addEventListener("mouseup", function () {
        intervals.forEach(clearInterval); // توقف همه interval‌ها
        isPressed.fill(false); // متوقف کردن تغییرات
    });

    document.addEventListener("mouseleave", function () {
        intervals.forEach(clearInterval); // توقف همه interval‌ها
        isPressed.fill(false); // متوقف کردن تغییرات
    });

    quantityInputs.forEach((quantityInput, index) => {
        quantityInput.addEventListener("input", function (e) {
            e.preventDefault();
            let value = parseInt(quantityInput.value);
            if (isNaN(value) || value < 1) {
                quantityInput.value = 1;
            }
        });
    });
});



function print_invoice() {
    const invoice = document.getElementById("invoice");
    if (invoice) {
        const printWindow = window.open('', '_blank');
        printWindow.document.write(`
            <html>
            <head>
            <title>چاپ فاکتور</title>
            <style>
               @font-face {
    font-family: 'fa';
    src: url('data:font/ttf;base64,AAEAAAAPAIAAAwBwRFNJRwAAAAEAAMJYAAAACEdERUYRtRFPAADCYAAAAH5HUE9TGPRBDAAAwuAAABc+R1NVQtC9xj4AANogAAAFkk9TLzKnt1AVAAABeAAAAGBjbWFwMmGWhwAACIwAAAZGZ2FzcAAYACEAAMJIAAAAEGdseWaQTIQiAAASMAAAnHRoZWFkE/r5QQAAAPwAAAA2aGhlYRhaDh0AAAE0AAAAJGhtdHiy3/uSAAAB2AAABrRsb2NhopzJMgAADtQAAANcbWF4cAHBAgIAAAFYAAAAIG5hbWUzA7qSAACupAAABg9wb3N0tANGewAAtLQAAA2RAAEAAAAEMzOC9AqLXw889QAJCPwAAAAA0uNvJAAAAADS/wzI+xX60RPiCVcAAQAJAAIAAAAAAAAAAQAACWD6iAAAFEv7Ff2cE+IAAQAAAAAAAAAAAAAAAAAAAa0AAQAAAa0A0wAFASwACQABAAAAAAAAAAAAAAAAAAUAAgADBR4CvAAFAAAFmgUzAAABHwWaBTMAAAPRAGYDCgAAAgQFAwUCAQICA4AAIOOAAAAAAAAACAAAAAAxQVNDACAAIP78CPz67AAACWAFeAAAAEEAAAAABKUGaQAAACAABQTNAGYAAAAAAloAAAImAAAD+wB4AhgASgJwAHcGQwAfBgz/XwaD/2EGpgAvBGcAGgLN/0cDMP9HCqQAIQZi/2gHO/9YC0kAGAtFAEwHT/9hB43/YQs0ACMG8AAOBeX/XgYv/14HSwBABhcALQQw/2AEdv9iBU0AFwQX/1gEpP9XB+gADgg8//wFywAwAi7/YgKN/1kF5AAFBLoAJQRy/2MEnv9eBRQAKAPOABMF8f9YA+3/YQRCAEgEGwAcBBMAHAbFAA8GswAmBN8AFgW1AH0Di/9dB74AJQkMAEEDnf9fBCH/YAecACEIOgAQBi0AGgYiABoEAAEoBAAAjQR/AL0EIQCeA5cAXQLYAEQEZwAQBdsAFQUhAA4FeQBCBP0AOwVYAEMFbgA6BMQAfQUhAA4FeQBCBP0AOwLY/1sEI//XBqcACgeRAEIFOQAXCHIAEgkRABwIcgASBCj/XASt/2IJBQAcBl4ALwatAAEEwf/4BAD//AIAABwCAAAhAk3/tAJNACMD3v/6AAD/5gAA/+sAAP/iAAD/tAAA/z0AAP/rAAD/swAA/+YAAP8vAAD/yAAA/+4AAABnAAAAfgAA/0kE5QAtAAD/ggK8/1sCwf9iA0v/YgNU/1sFUAA2Bk4ANwanAC8EAADjBAAAgQH9AFQCgACDAg3/wgKhACECDQAeAqEAigLt/8ECov+fAj3/qgKd/+sH1AApAtn/WwLO/2IJAQAzB/AAIwjqACoDW/9iA1v/WwfJABYDLf8+A2b/Wwj7ACwH5QAdA2r/YgNg/1sI5QATB98AJAMG/10DW/9bCLz/8gQGADgEZgBtBhf/XwZ//2EGTgAlBgz/XwZ//2EGoAAvBk4AHwYM/18Ghf9hBqsALwRyABoE3wAtBH0AIgTaAC0C0v9HAzP/RwNg/0cDNv9HA6L/qQNn/3kKnQAhBoz/aAdU/18LSQAYC3AATAd1/2EHi/9hC0kAIwb7AA4F8P9eBiL/XgdMAEAGBwAtBF//YASS/20FRwARBA//TQSt/2IHwwAhA63/XwQz/2AINQAQB6cAIQOA/18EKv9gCDoAEAOy/18ESf93BjgAGgYdABoCwv9bAsH/YgZOAC8GsgABA9cAEwPXABMEQgBIBCIAHAQiABwC1P9bAsH/YgMk/zADVv9bBvUADwa+ACYG3wAPAx//MANc/1sGwwAmB90AYwUc//EG2gAPAt//WwLL/2IGvgAmBN//gQW+//0E3wAWBb4AfQVG/9MFvv/GBN8AFgW+AH0EQgBIA+EAHQVzAEoD1wATA/wAOAWJAF4ExAATBiL/WAPr/2EDswBdAscARARtABAF5gAVBNIAgQV+AEMFiQA6BPAAaARKACAAAP/mAAD/PQAA/+sAAP/iAAD/tAAA/+sAAP+zAAD/5gAA/50AAP8TAAD/jAAA/7MAAP+qAAD/qAAA/68AAP+fAAD/uwAA/8gAAP78AAD/pQAA/9IAAAAaAAAAFAicAG0LoP/aBAAAWgCUAAACQwBHAxsATQXFAE0FjgBvByYAcwZbAFYBkQBMA/MAPgRrAHwEYwAhBUkARQJdACoDwQCFAtAAmQOe//AD8wBmAyEASwTZABIGcAAXBaQADwYFAEkFfABBBeEASgX5AEAFPgCKArwAlwKKAEUE7QBBBYsApQUBAJEE0gA2CKsAWwaEAAgGLgCdBlYAaAZLAJ0FcwCdBU4AnQaZAHIG2ACdAtMAtAVpADAGJgCdBT4AnQh8AJ0G1gCdBrAAaAY/AJ0GsABmBi4AnQX0AFQF/gAwBmAAjAZVAAgIeAAqBicAGwX9AAIF3gBYArEAkQQWAAACsQAQBDsANQRSAAEDNAA/BTEAUgV0AIYFDQBQBXUAUAU8AFcDeQAjBYcAVAVrAH4CkQCEAoT/jQUsAIYCkQCZCGIAhgVsAH8FegBQBXQAhgV5AFADiACGBPsARANGAAwFawB+BOUAEAceACIE7QAZBNwABATtAFoDMgA6AnMA0QMyACkGSACAB5gAaAeYAGgEAABaFEsARQcE/1sHR/9bArwAmwWSAHgFwQB4BrUAYgXuABgCcQCbBhYAbwSFAHEE1gBdA8EAhQTaALMDwgCZBTQAbAM2AHoC6wCpBNYAZwUlAE8FhgBMAjkARgTNAJUEjwBnBNoAswKRAI8DOgCQBKgAjgP5AEUAAPvDAAD8xgAA+54DCgCsAAD7FQAA/GcDQwEIAusAqQJEAH4COQBGAmcAUAIGAFYD7gCIA/UAVwPnAFABkQBMAxsATQMEAIMC7ABhBFEAJAAAAAMAAAADAAAAHAABAAAAAAR8AAMAAQAAABwABARgAAAAkgCAAAYAEgAgAH4AqQCrALEAtAC3ALsA1wD3ArwCxwLJAtoC3QLzAwEDAwMPAyMDhAOHBgwGFQYbBh8GOgZWBmkGcQZ5Bn4GhgaIBpEGmAapBq8Guga+BsMGzAbTBtUG8wb5IAwgHiAzIDogRPtR+1n7bft9+5X7n/ux++n7//xj/fL9/P5w/nL+dP52/nj+ev58/n7+/P//AAAAIAAhAKAAqwCtALQAtwC7ANcA9wK8AsYCyQLZAtwC8wMAAwMDDwMjA4QDhwYMBhUGGwYfBiEGQAZgBmoGeQZ+BoYGiAaRBpgGqQavBroGvgbABswG0gbVBvAG9CAMIBggMiA5IET7UPtW+2b7evuI+577pPvo+/z8Xv3y/fz+cP5y/nT+dv54/nr+fP5+/oD//wAAAPoAAADcAAAA2ADWANMAuACZ/tX+zP7L/rz+u/6p/pn+mP6O/nv+G/4Z+lH6WvpD+j0AAAAA+eEAAPoc+gv58fof+hr6Ffmq+ab5n/mSAAD6EAAA+fz6BwAA4Q7hieF24XHhaAUzBTMAAAAAAAAEuwAABO4AAAAAAyUDHAKQAo8CjgKNAowCiwKKAokAAAABAJIAAACQAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB+ALAAAADaAAAAAAAAAAAAAAAAAAAAAAAAAAAA1AAAANgAAAAAANYAAAAAAAAAAAAAAAAAAADSAOAA5gAAAP4AAAEWARwAAAAAAAAAAAAAAAAAAAAAAAAAAAESAAAAAwADAX8BgAGBAYIBgwGEAYUBhgF5AYgBegGJAYoBiwAEAIEAfQDUAH8A4gAFAIUAmQCNAJEAnQAHAKEACwClAAwAqQAOAK8AEgCzABYAtwAaALsANADBAMsAIAAiACYAzwAqAC4AMADaAGIAZgBjAGQAZQBnAGgAaQBqAGsAbABuAFsAXwBgAGEANQA7AG0AgwDSAHYA8ADzAFEA4ABLAEwATQD8AP0A+wCVAJgAlgCXAMUAyADGAMcAdwB4AJsAnACnAKgArQCuAKsArABTAFQAvwDAAFUAWABWAFcA0gDTAPEAdgBOAE8AUAD0APUA9gBRAFIA4ADhANwA3wDdAN4BCQEKAQwBDQEOAQ8ABACBAIIAfQB+ANQA1QB/AIAA4gDlAOMA5AAFAAYAhQCIAIYAhwCZAJoAjQCQAI4AjwCRAJQAkgCTAJ0AoACeAJ8ABwAKAAgACQChAKQAogCjAAsAcAClAKYADAANAKkAqgAOABEADwAQAK8AsgCwALEAEgAVABMAFACzALYAtAC1ABYAGQAXABgAtwC6ALgAuQAaAB0AGwAcALsAvgC8AL0AwQDEAMIAwwDLAMwAyQDKACAAIQAeAB8AIgAlACMAJAAmACkAJwAoAM8A0ADNAM4AKgAtACsALAAuAC8AMAAxANoA2wDYANkA6gDrAOYA5wDoAOkAMgAzAAYBygAAACAA4AADARsBHAEdAR4BHwEgASEBIgEjASQBJQEmAScBKAEpASoBKwEsAS0BLgEvATABMQEyATMBNAE1ATYBNwE4ATkBOgE7ATwBPQE+AT8BQAFBAUIBQwFEAUUBRgFHAUgBSQFKAUsBTAFNAU4BTwFQAVEBUgFTAVQBVQFWAVcBWAFZAVoBWwFcAV0BXgFfAWABYQFiAWMBZAFlAWYBZwFoAWkBagFrAWwBbQFuAW8BcAFxAXIBcwF0AXUBdgF3AXgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGKAYABgQGFAAAAAAAAAXoBeQAAAYwBhgAAAAAAAAAAAYsAAAAAAYMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABfwAAAAAAAAAAAAABhwGOAAAAAwAAAAAAAAAAAAAAAAAAAaUBpgGhAaIBkAAAAAAAAAAAAYIBqgGrAAAAAAAAAAABowGnAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZIBlwGJAAABlQGWAAABmAAAAZMAAAAAABYAFgAWABYAZgCOANABNAF+AeYCXgKcAsgDCAOOBAAEeAUQBZwGCAacB0QHpggECHQI7gleCbYKLAq4CwQLbAwYDNYNNA10DcoOPg6uDxgPeg/UECQQrBEgEYoR6BJQEtYTOhOOE/QUGBRkFLgVHhWWFhYWpBcoF7IXwBfUF/AYDBhGGGoYuhkqGYIaDBpqGpwazBsmG34cCBxmHMQdNh28Hf4eVB7GH0IfTh9aH2Yfch/CIBggOCCCIKwg5iD2IRohRCFaIXAhgCHYIlIiYiKyIu4jMCOAI4ojriPSJDwkiiTkJR4lXiWaJeAmLCY6JkgmViZqJpYm4CbsJvgnBCcQJxwnKCc0J0AnTCdYJ2QncCd8J4gnlCegJ6wnuCfEJ9An3CfoJ/QoACgMKBgoJCgwKDwoSChUKGAobCh4KIQokCicKKgotCjAKMwo2CjkKPAo/CkIKRQpICksKTgpRClQKVwpaCl0KYApjCmYKaQpsCm8Kcgp1CngKewp+CoAKggqFCogKiwqOCpEKlAqXCpoKnQqgCqMKpgqpCqwKrwqyCrQK2osHizGLXgtgC2ILZQtoC2sLbgtwC3MLdgt4C5sLw4v3jBiMO4xnDGoMbQxwDHMMdgx5DHwMfwyBDKeMzQzPDNIM1QzyjPSM9oz4jPqM/Iz+jQCNAo0EjR0NMo00jTaNOI06jTyNPo1AjUKNVY1YjVwNXw1iDWUNaI1rjW6NcY10jXeNeo1+DYGNzY3TjdeN143eDeQN8o4EjhmOLg4yDj2OSQ5SDliOXo5iDmeOa456DoMOlw6zDskO648DDxCPHQ8zjz0PRw9Mj1IPV49mD4MPio+Yj6YPsI+3D70PzA/Sj9YP3o/mj+sP9A/6kAmQFBAkkDAQQJBFkE6QVBBckGUQa5BxkHaQehB/EISQiBCMEJyQqRC1kMEQzpDXEOcQ7xD2kQCRCJEMERiRIREtETiRRBFLEVoRYxFrEXCReJGAkYmRj5GakZ4RqRGykcmR4hHmEeySFZI7kkKSURJekm+SepKAEpaSn5KoEquSrxK4EsCSxJLJktKS2xLmkuuS8RL2kvoS/5MIkxITGBMcEyATKZMyEzgTPZNBE0YTS5NQk1YTW5Nkk20TdpN6k4CThZOLE46AAIAZv6WBGYFpAADAAcAABMRIRElIREhZgQA/HMDG/zl/pYHDvjycgYpAAAAAQB4/3IDqgL+ADIAAAEuAScuAScmDgIXNR4DNz4BNz4BNxcOBQcnNy4BJyY3PgM3NhceARcWFwLeCxcLFDEXJVFCJQcHKz1KJyhdKhgwGDwbNklnmteTLccmNQ0QCQcuRVgxUVEjRR0fIQH9BAYDBQsDBA8lOigBGC8iDwcIIxMLFw3cDRkhKz1TONtSJVkwNkgxXEw4DhQMBRIKCg4AAAEASv/BAcMGNwAXAAAXPgMnLgUnJRYSHgEVFA4CB34FCgcCAwYLCwsMDggBNRYbDgUBAwYGP1KwrKJEjtemfWhbMWaG/vD51kxFoKywVAAAAQB3/8QDEQYyACsAAAUiJicuAz0BPgE1NC4CJyUeAxcWDgEWFx4DOwEyHgIVFA4CAnJ7sEAoKxMDAQMCCREPASsNEAsFAQENCAkXCRskKxoJIDorGhorOjw9PyhYVUwbDyWLXl7i4dBNW0KzxMZVS4+JgT0XGAsCGis6ICE6KxgAAAAAAQAf/RIF+wTNAEcAAAEOAyMiJC4BNTwBNz4FNy4DBw4DByc+Azc2HgIXHgUXAyciDgYHBh4EMzI+AjcF9Tyetchmp/7f1nsBCWCYyeT1ejp7enY0MllRRx/dM2d8nmo/fHl0NzZTRT0+RStfXUejrK2gimg9AgIsUG1+ikREg4F/Qf4RNl1FJ1yw/6QLGQxouZ6AXzsJE0A+LAICJDdGI6FJf184AwIiOUckJDktIhsTCP6zAhMkNURTYW09Q2xTPCYSESdAMAAB/1//xAYVA9AANAAAJzQ+AjsBMiQ+ATcuAyMiDgIHJz4DMzIeAhceAxcDBw4FKwIiLgKhGSs7IcCiAQ/s02ZEiYmIQy5YSDEG5yZofZFQO3Z1cjg2a3J6RBmOV6yzvdDohLgIITsrGWIhOisYJ0JXLxM4NCUyQD0LlUOAYzwZKDMaGTEpGgH+zUQqWVNLNyEZKjoAAf9h/8MHIgPSAEwAACc0PgI7ATI+AjcuAwcOBTEnPgMXHgMXHgMzAw4BDwEeAzsBMh4CFRQOAisBIi4CJw4DIyciLgKfGSs6Ibdu/v/vXz6YnJM6JUU7LyIT7ShwhJFJNmtsbjg5i5edSzQXORYaF0dLRRQOITorGRkrOiEOYKmLbCNj1ub3hbchOisZYSA6KxorRlctDzY0JQEBHSsxKx2ISolpPgEBGCUxGhw2Khr+2QobCw0bIA8EGis6ICE6KhgiQV07MFtGKwEYKjoAAAEAL/yxB0MEagBXAAABDgMjIiQuATU8ATc+BCQ3LgMjIg4CByc+AzMyHgIXHgMXAwceAzMyHgIVFA4CIyIuBCcOBQcGHgIzMj4CNwYhUKq1wWan/t7XfAEJZqPV8QEBfTWHj4k3JFVRRRXhLG6BllQ/gH13N1KHeXZBXZoNRFZeKCA6KxoaKzogeriHWzkdBVSwp5NwQgIDYaDKZkOOjYY8/a05XUIkXLD/pAsZDGi4nX9dOgkdQzonHTJEJ5lNgV0zHzNCJDVPOScN/sUXJCwYBxorOiEhOSoYKUNUVlAdEDBBT15sPGWQXCsWKTwmAAEAGv+5BEQEqwApAAATHgMzMj4ENzYuBCcTHgMXHgEVFA4CIyImIyIuAiedKnF3cCkPMDU2LRwBATFTbXR0MbFhv6J2GggGSIG0bAgQCEWRjYU5AZcbNi0cAwkPGCEXJ2JrbWVXHwEHRKi9ymUdOxtdm3E+AR0wQCMAAAAB/0f82gK6AqEAGwAAARYXHgMVFA4EByc+BTU0LgInAjUmHAwYEwwzXYCcsl+2SJOHdVcyFyc2HwKhbGctYWFdKF6zqJuIdS/9JFtocnZ5OipicX9IAAAAAf9H/NoD2AKfACsAAAUiJicOAwcnPgU1NCY0Jh0BLgMnJR4DOwEyHgIVFA4CAzgWUC4WebLkgbdHkINxVDABAQcaJzQgASEoRkNEJgUhOisZGSs6PAYTfN/DpEH9JFVfZ25zOwMMDAYEATpqbnlIfnigYCcaKzogIToqGAAAAAABACH9MQp3A+MAYQAAAR4FFQ4DIyImJw4DIyImJw4FIyIkJgI1PgM3Fw4DFQYeAjMyPgI3BzY1NC4CJyUeBTc+Ay4BJyUeBRcyPgI1NC4CJwnDBh8oLCQXATluompcdSYVMEFXPCpGHQFFd6C4yWOZ/vy9agMrQ1Mr2iRENCADQ3ehW2evh1wUARkmPEkjARIaNDU4PEElKjQbBwQJAwEUBwoNFCIyJh82KBcbLj0iA+MMP1lueX08Y6x/Sj42GysfEAwJdcCYcEkkZbcBAZtavLSjQag7g4mIP0yGZTomQ185AVJXQ4qNj0iaO3htXkMiBQYvRldaWCUlH1dgYlQ+DRcsQSskX255PgAAAf9o/7cGWQPDAFEAACc0PgI3Mj4CNwUOAx4BNz4FNxcOAhQeATMyPgI1NC4CJzceBRUUDgIHIi4CJw4DBwYuAicOAysBLgOYGCg3H0tnSjQXAQoIFxMMBx4fKEE0KB0TBv4BDAoWMy4cOi4dIjA1EvgGHiYpIhY3b6dwNlhGNxUYN0dYODFPQjUXFTZKYkESHzcoGGEfOCsbAlGEqVgwI11kX0gpBQMyTmJoZiorHlhhYU0wEyMwHjR9e24miw1BXHN8gj1koHA+ARUlMhwfMSMUAQETJDMfGi0iFAIaKjgAAAAAAf9Y/8EH4QLQAFQAACc0PgI3Mj4CNwU2DgIeARcWPgQ3BQ4CHgIzMj4DNCclEx4DOwEyHgIVFA4CIyImJw4BBzUOASMiJicOASMiJicOASMiLgKoGi09IzVcUkghAQoDDREPARcdHzo0LCQaBwEIAgoGARQqJSEwIRQKAwEOIQYoNjwbDCU9LBgYLUMqYaw/BgwFNo1RW5kzPJhbVZIwNp91Jj4sGWIfOCsaAiNktpMmDDJbcWdLBwgpTWdsaCgmGVNeX00xLEdbXlkiJv7mLkQtFxgrOiEhOioZRFEIDAYBOUNOQ0JSTEJLQBkqOgAAAQAY/TAL8QLSAHAAAAUiJicOAyMiJicOBSMiJCYCNT4DNxcOAxUGHgIzMj4ENTQuAiclHgM3PgM1LgEnJRQeBDMyPgI1NCY0JjUlFzUeAxceAzsBMh4CFRQOAiMiJicOAQi0VnUmFTBBVzwqRh0BRXeguMljmf78vWoDK0NTK9okQjEeA0F1nltFiX1sTy0kO0soARUkTlRaMCgvGggBBAEBHAUNFyQyIiEzIxEBAQEPBwIFBggFBig2PBsMJT0sGBgsPiZwqjw2ojpCMhsrHxAMCXXAmHBJJGW3AQGbWry0o0GnO4SHiD9Mh2U7EytDYH9RPIOJjkeUVqaDTwIBKkRYMCpZKiccW2hqVTY9YHU4FhMPFRgnTwEaLC82JC5ELRYZKzohIToqGUdORU0AAAIATP07CzgDmABPAGUAAAEiLgInLgM1ND4ENxcOBRUUHgIzMj4CNTQuAiclHgMXPgUzMh4CFRwBBzUOBSMiJicuAScGAgYEAQ4DBx4DMzI+BDc2LgIDRGfLtJMvER0WDBkoMjMuEOAHICcqIxZVialUYbOKUiE0Px0BFRosKCYVJF1yhZiqXmGxh1ABCE13mKesT23OVRoxFwNzyf7qBS1ClIlyIBpGS0keKGpxbVg5AwI2VWr9OyJOgV8iTlFTJ0iSjIJwWh+gCTtYbXd7OFt+TiM6b6NpRIeIi0iZQmxVPxU4d3JmTS1Ed6NgCQ8IAWWed1M0GCMeCxQLnf73wGwFGBJDWWk4Bw0KBgkVIzRILyg/JQgAAAAC/2H/sAdUA60ANwBJAAAnND4CMzI+AjcHPgM3BQ4CFhc+BTc2HgIHDgEHDgMjIi4CJw4BByMiLgIBIg4CBx4BMzI+BDcuAZ8ZLDogMUYvHAgBDhwhJxkBBgoSBwYOKlxrfJWwanq6fTwEBWNPSbO9vVNinId3PEjDhAkgOiwZBgJgspNvHidiLj6FgXdhRQ4KgWIhOisYDhUZCwEVN1yNalUmRUJCJEaJe2pNLQEBU4erVWq4QjlKKxEMIz8zSEQBGCs6Ai1LcIA2AgIHEyI1SjJGQgAAAAAC/2H/sQgtA6sAUABpAAAnND4COwEjNjc2Nz4DNwUOAhYXPgM3PgE3PgEzMhYXHgEHDgEHMzIeAhUUDgIjByIuAicOAyMiLgInDgMHBiMiLgIBDgMHHgEzMj4ENy4DIyIOAp8ZKjohCQFoHiMaDxkeJx0BBhAQAwcGEzdDTClh33UgOBptv0hDOwUFLxqBITorGhorOiH8NVNCNBc0bWtoLlihkYE3Bx4mKBBvpyE6KhkEnR04MioPJmMpQ4uCdVs9CQYwQ00kLmNhWWEhOisZAw8RIxM0W45uVCpNSkknIVdeXShbdRYGBUlLRqhYOmcwGSs6ISE6KhgBAgULCQ4RCgQGJU5IFCQgGQg1GCo6AaQcPj06GAQECxclNUYtIjYlFBYmNAAAAAIAI/07C9UDmwBiAHgAAAEiLgInLgM1ND4ENxcOBRUUHgIzMj4CNzYuAiclHgMXPgU3Nh4CFRwBBw4BBx4BFzMyHgIVFA4CIyIuAicOAyMiJicuAScGAgYEAQ4DBx4DMzI+BDc2LgIDG2fLtJMvER0WDBkoMjMuEOAHICcqIxZVialUYbGHUgIBIDM/HQEZHiwkIhUgWW+Gm65hYbGHUAEEFxMPKxQIITorGRkrOiE4Xk09FTl/g4I8bc5VGjEXA3PJ/uoFLUKUiXIgGkZLSR4oanFtWDkDAjZVav07Ik6BXyJOUVMnSJKMgnBaH6IJO1dtdno5W35OIzZsomxEiIqNSJpKb1Q7FTl3cmROLwMDQ3imYAgRBzFZKAMEARkrOiEhOSsYDxkhESAvHg8jHgsUC53+98BsBRYSQ1lpOAcNCgYJFSM0SC8oPyUIAAAAAAIADv/EBsYGMAAvAEEAAAUiLgInEx4BFz4BNz4DNTQuBCclFx4DFz4DNzYeAhcWDgQBIg4CBx4BMzI+AicuAwNYcdPNzWxzVIYwEy8iBgkFAwgLDw0MAwE9CwgRDgsCMF1neUxPm35WCgFOhbHEygFJPJeemT8jTCCW8alZAwUvP0I8DyZDNAEnIC8OGj8tLUtEQCIujqGljGIOVGpIpa60VypGMx4CAjFgj1uByZZpQB0C3j5wnF4DAz1ecDMeKxsMAAAC/17/wwXTBjAALgBAAAAnND4COwE+ATc+ATc0LgInJR4DFT4DMzIeAhcWDgQjJSMiLgIBJg4CBx4BMzI+AicuA6IaKzogdBE8MAgMAQgPFg0BQg4WDwg0b3eAR1KScUkJBUR9rcnabP2wCSA6KxoEqjyXnpk/I0wglvGpWQMFKTpEYiA5LBkdYjw/uGw8mbTKbVJnwMDFaylJNh80YoxYeMKWbEYhARgqOgJgATtuml4DAztbbTMeKhoNAAL/Xv/DBs8GMAA+AFAAACc0PgI7AT4BNz4BNzQuBCclHgMVPgMzMh4CFxYGBzMyHgIVFA4CKwEiJicOASMlIyIuAiUyPgQnLgMjDgMHohorOiB0ETwwCAwBAQMHChALAUIOEwsFNG93gEdSknFJCQQ3M8khOisYGCs6IvdPwXZVsFj9sAkgOisaAoU7n6qkgEwEAihAUCkthZihSmIgOSwZHWI8P7hsKEpTY4KoblJnwMDFaylJNh80YoxYbbFIGCo6ISE6KxkNHhcVARgqOsAGFCdDZEcWKB4SAy1gm3IAAgBA/8QH6QYwAEEAUwAABSIuAicTHgEXPgE3PgM1NC4EJyUXHgMXPgM3Nh4CFxYGBzMyHgIVFA4CIyEiLgInDgMBIg4CBx4BMzI+AicuAwOKcdPNzWxzVIYwEy8iBgkFAwcMDQ4LAwE9CwgQDgoCMF1neUxPm35WCgE6NMEhOisYGCs6Iv7/Fk5bXSYuY2NfAXg8l56ZPyNMIJbxqVkDBS8/QjwPJkM0AScgLw4aPy0tS0RAIi6OoaWMYg5UakilrrRXKkYzHgICMWCPW3CySBgqOiEhOisZAQUNDAwNBQEC3j5wnF4DAz1ecDMeKxsMAAAAAAEALfyyBeEFTwBOAAABIi4CJy4BNTQ2Nz4BNy4DNT4FNzYeAhcHJicuAQcOAxUUHgI3JQMOAwcOBRUUHgQzMj4CNxcOAwM8TaWimUBRUU9OP6FbGSsgEwEoRF1teT5GeG1oNnwvNC1xPCZURy8xUm08AXgYT6KnqVYXRExMPCYqSmRyfD47goWFPpxOsbKs/LIdPV9CWOOBfORkUXgwGUBNXDY+d2xcRSkDAxMpPyntGRQRGAUDIDRGKSM7KRQEGf7HCg4aLioLJjZGVGU5PWZRPikUEic9LPRCXTwbAAAAAf9g/8QEOQPoADgAAAEuAScuAQcOAxUUHgI3PgE3PgE3Ew4CBCMHIi4CNTQ+Aj8BLgE3PgM3Nh4CFx4BFwOXGjUcMHY/K089JDxdcDU5ezYfPh8pQ6bS/vyg2iE7KxkaLDkgnCQcAQFNhbJmM15USh4jQBwCWQ4XChEWBwUkNUIiMEkwGAIFEgoFDAf+yRIjHRECGSs6ISE4KhkCAjl2RliqiFoIBAkVHRATKxkAAAAC/2L/wwUZA+gAQQBRAAABMh4CFRQOAiMiLgInDgMjIi4CNTQ+AjMyPgI3LgEnMy4BJzc+Azc+ATMyFhceAxcWDgIHFgEiDgIHBT4DNy4DBHogOisaGis6IE+Wi3w1O5SgokcgOiwZGSw6ICNNTkwiCxIKATZxRRA7fntxLRYyGE6lQzpOLhUBAx45Ti1q/mMYSlBLGgETHUtIOw4XPkNCAQAaKzohITkrGAocMykkMh8NGCs5ISE6KxoEBwwIChMKNnI/6jRJMBoFAgMgHBtEREAWLWtvay0UAbEHDBAJ6xU+Q0IZCg8JBAAAAAIAF/yqBegEKgBRAGMAAAUUHgQ3MjY3Fw4DJy4FJyY2Nz4DNy4BLwI+Azc+ATMyFhceAwcWDgIHHgEzMh4CFRQOAiMiLgInDgUBJg4CBx4BFz4DNy4DASYtTWRucDNz4F6bOJWkp0tAoKSceksBATEhHE1aZTQkTR5DFTJtamMnOnI3PHAwOmBDIwIBKElkOkibSCE5KxgYKzkhVKGemkwuYl9WQSYCMDNlW04dOn9GOmtSMgICGzNL2jZcSTciDgRJP/kuTDYdAQEWNluMxINRmz80XE9DGyBBGjnxLUk4JgkODBAPFD5QXzU/dWdVHiEmGiw6HyE6KhkiPlY0Ey03P0tVA7cBDhccDDBcKBMwNTgdAg8SDwAB/1j/wwQhBp0AMQAAJzQ+AjsCMj4CNzY1NCYnLgUnEwETAR4FBw4BBwYHNw4BIyUiLgKoGC09JjgxNoJ5YRYeBwUHLUZaZnA4HwNIef1oMWhiVkAlAQEmHGjvARswF/69JT4sGWEiOisYAxEiHi47FCkWGUdVX2NiLgEQAXb+9P7MIl5vfIKEP0uBM7opAQUEARgrOQAAAAH/V//EBUEGowBGAAAnND4COwEhMj4CNzYuBCcTARMBHgMfASceARceAxcjMzIeAhUUDgIrASImJy4BJw4BBw4DByEiLgKpGSw6IAkBSh1LRDIEAypLYmpqLRsDl3T9CUVwXU0hCgEXLRoYOURNLAEqITorGBgrOiEITHc6PGgtCxwOJlRYXC7+uiA6LBliIToqGRgnMRkydHl5bl4iARMBgf7t/spAeXh6QBIBKlMqJkEyHQEZKjohITorGBQTFkouDh4OIi0dDQIYKzoAAAACAA7/uQeQBi4AQAB1AAABHgEfAR4BFQ4BBw4BBwYEIyQnJicVJjU0Njc+AzcXDgEVFB4CMzI2NyM+ATc+ATcVLgEnLgMnJR4DBS4BJy4BIyIOAhc1HgM3PgE3PgE3Fw4FByc3LgEnJjU0PgI3PgEzMhYXHgEXB4IBAgICBAMBGR4wnW11/tq4/ozh41UwFxQLDQ4VE+kiLm67+IqY9lcBOVQSCwcBAg4IBg4MCQIBOAEKDg78/ggQCA4jEBo2KhQJByEtNRoaPxoQHg8+EiIvQ2SMYDOBHS0OEBcoNyEaNx0YMhQMFwsDvSNDHjlbih85cjlVgi0tLgRUVa0BXXEzbTkeIBwjIa82YzNIWTESIiEYOSITLRcCPNuYa8KYYw1HEHWr09kBAgICAxMgLRkBEBwSAwkIIhEKFAuSCxYdJzlNNJFMFTggIzMjQzovDgsKBwQCBQMAAAL//P+oCFwGGwBPAIQAAAEeAzMRIiYnLgEnDgEHBgQjJCcmJxUmNTQ2NzU+AT8BFw4CFBUUFx4DMyA3Iz4BNz4BJy4HJyUeAxc1HgMVHgEXAS4BJy4BIyIOAhc1HgM3PgE3PgE3Fw4FByc3LgEnJjU0PgI3PgEzMhYXHgEXB6sGFig+L2aQMyY6GSVWM3X+2rj+jOHjVTAXFBAjEw7oJCQPDhR1sOODAS+vATlOEgsOAgIHCQwLDAkGAQE7AQoODgUGCAUCBBgV/KgIEAgOIxAaNioUCQchLTUaGj8aEB4PPhIiL0NkjGAzgR0tDhAXKDchGjcdGDIUDBcLATYMFA4I/sQaHRYvIx0vFC0uBFRVrQFdcTNtOQEsPyAarj9KKxYLIR4pPikVQxg5IhNLNyJwi52bj3NMCT0QdKrSbgFtiVIpDlp5KgIlAQICAgMTIC0ZARAcEgMJCCIRChQLkgsWHSc5TTSRTBU4ICMzI0M6Lw4LCgcEAgUDAAAAAQAw/TQFigYvAD8AAAEOAQcOARceBRcWMjMyPgQ1NC4BAicmAiclFhIXFhIeARUUDgQjKgEnMy4FNz4BNzY3AZ0OGAsSHQQDJzxKTkoeCAwGK2JiWkYpCQ0SCQsXDgE/Bw0FBQkIBEBsj52iSQkYCAFCkIx9XjYCAiMVGh0BJho4HTN+QjhdSjcmFQIBEyg9V3BGT9fzAQJ7kQErnkqp/sKZgv7w/91PhM+cbEQfAQUlQ2SJsW55tz9MNQAB/2L/xAIPBigAKwAAJzQ+AjsCMjY3FT4BJzQuBgclHgMXExYOAgcGKwIiLgKeGSo6IQkvLUcOERMBBgkNDQwLBwEBPQEKDg4FEAEGGjMre94vCSE6KhliITorGBAOARNQQghlmb3CuIxTBE4QdazUbv4RKmRnZix7GSo6AAAAAAH/Wf/CAy0GNQA7AAAnND4COwIjFj4CNTYCJyYCJyUeAxUUBw4BFRQWFyMeATMyHgIVFA4CIwYmJw4BBysBIi4CpxkqOiEJQAEiOioYAggCAgUIATcICQUCAwICCA4BDC4wITorGhorOiFZijA5jEhtCSE6KhliIToqGQgfO00mVQEIsKEBDH05QJWirFeJikWWSBEyFxIZGSo6ISE6KxgCQS80OAIYKzoAAAABAAX9NAaDBi8AUgAAAQ4BBw4BFx4FFxYyMzI+BDU0LgECJyYCJyUeARceAxc1HgMzMh4CFRQOAiMiJicOBSMqASczLgUnJjY3NjcBcw4YCxIbAwMmO0pNSh4IDAYrYmJaRikJDRIJCxcOAT8FCAQDBwcHAwMPHzQoITorGRkrOiEqQRwERG2Nm55HCRgIAUOPiXxdOAEBIxYZIAEmGjUdM35FOF1KNyYVAgETKD1XcEZP1/MBAnuRASueSmXLaFjFy8peBBEvLB8aKzogIToqGAgIfsaVaEEeAQUlQ2SJsW51tEJKOwAAAgAl/OkEogOHADQASQAAEwM0PgI3PgEzMhYXPgM3PgEXHgEXFhcWFBUUBgc3DgEHNw4BIyIuAicuAycWEhcTDgEHHgMXPgE1NC4CBw4DTCcEEysnGVktCBAIDyowNhs9gklhlzlWCwEVFwEjcksDChQLIV9udDUdKCEfEw0iDfELDwYfTlNPHwkLGCcyGQsmKyz86QPZCDZHTh8WHAEBKVVPRxs9NwIETEt2pQsaCz92NgFaag0CAwQcKzEVCxENCwbl/j/jBL4VIQ4NISIeCRlGGSZCMBoCAQoYKgAAAAAC/2P/xARlA3QANABJAAAnND4CNzI+AjcVPgE3PgEzMhYXHgEXNRYVFAYHDgEHDgEjIiYnLgMnDgMjIi4CAR4DMzI2Nz4BJzQuAiMiBgc1nRgqOSFDY0w8Gxo7IzaGTFqTPC04CQYTESF7SBgvGi1lMRQyNzYXKFBYZDshOSsYAsUfVVRHEgQJBQwXAyQ6SycOLCpiITgqGQI0VGg0ATZqLT9FSkU2i04CJzI2Zy5UcRUHBRYTCRkeIA8lPCoXGSo6ASgUJh4TAQEDNzAgTUMtUE8BAAL/Xv/CBTMDcAALAEAAACU2NzYnJicmBwYHFgUUBwYHIyInBiMiJQYHBgcGIyInJjU0NzYzMjc2NzY/AhIzMhcWHwEWFRYXFhcWMzEyFxYDOiAGBiMfPz8gK1f7AjQuL0EBfk5Sf5P+6BIzLTpJW0IuLi4uQn1dISULEw4Oh8qTcYARAQICDAsPFBpBLi/iCEtOPjkqKg0SzJBxQS4uAVZSlCYnIhMYLi5CQS4ufC1IFiYeHAEMYm/CCQYIMTIrGR8uLgACACj83wWhA30ACgA1AAABJicmJyYHBgcGBwEUBwYrASInBicmJRMFAicmNzY3Nhc2NzYzMhcWFxYXFhUWFRYXFjMWFxYDxQISJVQ2MCYgJRIDTC4uQQF7VUpvav48Of7TLAMBDREfU5oiSJC+ynQrGxUHAQEGFxkiQS4uAQRESI8YDxcSKjE1/s5CLi5eSAMDvvx9NQN5YSkwOSxzD2hp0aU/UEI+BQYPEEEwNQEuLgAAAAACABP/xAO5BHMAIAA0AAAFIi4CJy4BNTQ3PgM3LgEvATceARcAFRQGBw4DEzQuAicOAxceAzMyPgIB5QUtQVEpbXixDhMQDwoMFwgSxzOOXQEDcWQjSUQ7rihBUCgbPDIgAgEsPUQYHkU5JjwDChYTNLV4yNcRFhIPCgoSCBDzJoFk/tnmdrY0ERUMBQGXH05VVygeS1RZKxgkFgsJFiQAA/9Y/8EFvgS6ADkATgBfAAAnND4COwE6AT4BNy4BNTQ+AjcnEx4DFx4DFx4BFRQGBw4DIyIuAicOAysBIi4CASYOAhc1HgMXPgM1NC4CBRQOAgczMj4CNzYuAieoGSo6IQkPGyMxJSMkFCg8KTTBK3iEhThfk3ZeKTQuc3AfW2NgJCpiY14nMH2KjkIJIToqGQLXIEk8JAQDIi82FyZJOiQlNDsBmxQiKxgJSXtaNQUCLEVUJWMhOSsYAgICPIdFNGhfVSMdARwePj05GSxDQUgwQpxJcMdDEhoRCAcPGBAOFg8IGSs6AqgFMExbJwEaNzMnCQQcOFhAIUA1I6MqXFpVJAshOzEYOTk2FQAAAAAC/2H9SwSMA84ARABVAAAnND4COwE+BTceAxUUDgIHHgMXJj4EMzIeAhUUDgIrAQ4DFRQeAhcHLgMnKwEiLgIBNi4CJw4FBz4DnxgrOiE0AyM8UmN0P0NzVDBPgaNUBy05OhQBJEFYZWw1ITorGRkrOiEELFI/JgYQGxW3eLaFWx0EZyE6KxgC2AIFDxoTEy0uKyIVAStdTzZiIToqGUKbnZN0SQQBSXaWTVuslXcmGENEPBI6eXBjSisZKjohITorGAYvR1ctFCMkKBffSZifpFUYKzoBvhw/OzAMCjhQX2JdJQgxR1YAAgBI/8QE4QSPADYARwAAJSImJy4BNTQ2Nz4DNy4BLwElHgUXHgMXHgEzMh4CFRQOAiMiLgInLgEnDgEDMjY3LgEvAQ4DFRQeAgIgjsw8Ix8OCih1f30xAgMCBQE4AQcJCwkHAQ8VDwoDDz0zIDorGhorOiAVNDk9Hio/HTNfMxUtFQULBQomXlM4LUJKUE1GLWkwKkQYVH5dPhQXMBY/QwlCW2daQgd7nl0pByAZGCs6ISE6KhkDCREOFDMnBwYBOgMCIlQwXBM1Oz0aDRELBAAAAAACABz9BAQEA4sAFwA/AAABJg4CFRQeAhcjHgEzMhY6ATcuAwE+AzciJicuAScuATU0PgI3PgEzMhceAxUUBgcOBQcCBhU1Lx8mO0chARpDIAoLCAkJDyk2RP3sjeivcxgrYB90wDkqIxQkMRw8j0+piDBMNRwDAgxRf6jF3HQCTgQlP0wjISwcDgMCAQEBPnFaO/vxHFVpdj0DAgpTRzZ+RjZtZ1wmS02UNoaXpVUaNBd1za2Na0gSAAAAAAIAHP0EBLMDiwAuAEcAABM+AzciJicuAScuATU0PgI3PgEzMhceAxczMh4CFRQOAisBDgIEBwEiDgIVFB4CFx4BMhYXLgMnLgMcjeWtcBgrWB90wDkqIxQkMRw8j0+piCpENCEGEyE6KxoaKzohLCer7f7dnwGgFjUuHyY7RiESKy4tEwceJSsUBxUWF/43HFVpdj0DAgpTRzZ+RjZtZ1wmS02UL3KBjEkYKzoiIDkrGZPusnQZBUonPEojIiwbDQMCAQEBMVZKOxYHEA0IAAABAA/9BQbiA4gAXwAAAT4BMzIWFwMuASMiBw4FBwYeAh8BHgMVFAYHDgMHBgQjIiQnLgE1NDY3PgU3Fw4DBw4BFRQWFx4DMzI+AjciLgIvAS4DNT4DNwVOHj4eQ49IbzBWJhohIEpJRDUiAgIkPEwnHUB/Zj8DBAo0T2c9c/7Yqsz+yGdOSQQCBBgfJB4VAvsZLSMXAwECJy0bV25+QX/dqGcIAhQfJxU2WZ11RQVWksNyA3oIBicm/tsVFwYDHzA/RksjHCMZEwwHDyZFcFkSJxU2Z11RIDk/d3Jd3nkaNBdIi3tpTy8FaTtxd4ROCxoKP3oxHy8hESM5SycEBwkFDBY5XY1sc9q0fxgAAQAm/TgHUwJcAEcAAAEiLgInLgE1ND4CNwUOBRUUHgQzMj4ENTQuAiczLgEnLgMnEyEyHgIVFA4CKwEeARcOBQM+XcW3njYzOA8gMyQBAR0pHBAIAjBSa3R3NRpmeX9oQiE5SysBMGkzCBkaGQgpAyIgOisaGis6IG8VEwEFVYaqsq39OBU6aVRRwnhYn5ygWmtIdF9QSUcnS25MMRoKBxEcKTclBBQbIREPFQgBBAUFAgEwGCs6ISE6KxgoUR1ek3BOMRYAAAABABb/eATIBjUAOQAAAR4BFRQOAgcOAyMiJicTHgEzMjY3LgcnNx4FFz4DNTQmJxUDJRQeBATGAQEfNUcoOo6ep1IwcEA2TmcjEjsVCjlPX2BbRywB51SNdVxGMA8aMSYXAwKeAS4OFhwcGgJXDBsMRYl8ayg1TTQZCgkBOgoKBQJTrqykkntZNAHtbd3VyLCUNhAzQ1EtDBwQAQOBSQJXk8Lb5wAAAAABAH3/egZdBi4ARAAAAR4BFzIeAhUUDgIrASIuAicOAyMiJicTHgEzMjY3LgUnNwEeAxc+ATcmCgEmJyUUHgYXHgEFSxs7HSA6KxoaKzogCRpRXmIrOo2eqFUwa0JZLlMjIEAfHlRiaGVbI+EBEjBXSzsUJzsBCyAjJA8BNgcNEBMTEQ8FAx8BHA8LAhkqOiEhOisYBhs1MDdOMxgLDgEqBgcGCGzRwrCWeyzp/kdXtK+kRiBQKpsBJwEO8GQ6AkFxmbHBw71ULUcAAAAB/13/xAQrAQAAFQAAJzQ+AjMhMh4CFRQOAiMhIi4CoxotOyEDjCA6KxoaKzog/HMgOy0aYiE6KhkZKjohITorGBgrOgAAAAABACX/xAewA7MAMwAABSIkJyYnFSY1NDY3PgE3Fw4DFRQXHgMzMj4CNy4DJzceBQcOBQPivP7XcONVMBgTGDge6w8oJRkGFHe05oNHtcC+TwwhMEIt9hIwMS8lFAIFaqXP1cg8LSpYqgFdcTFyNj9hNsUVQ0pLHBQNKT4rFg4fMSMvVl1qRKAdVGFsbGctVIFgQigSAAAAAAEAQf/BCasDfAA2AAAFIiYnBgQhJiQuAScuAT4BNxcOAhYXHgMzMj4CNz4DNwUHBh4CMzIeAhUUDgIjCQSl5UiO/m3+85/+4+qwMh8cCjUy7hQiEgEPGYG22nJpvJ+BLio2JhkMARgpCRtCZkEhOisZGSs6ITxsfnl0ASdPd1E1i6O3YoonSlBbNys8JhIPITUmIlJbZDNH1C5OOSEYKzohITorGAAAAAL/X//EA4QEoQA0AEcAACc0PgIzMj4ENwYuAicVLgE1NDc2Nwc+ATMyFhceAxUUBgcOBQcjIi4CASYOAhUUFx4ENjcuA6EZKzshJW18gXVfG2Wqhl8ZGy8GHloBNohLTJQ8K0UxGwICDFJ/pLzNaBEhOioZAksXLycZDQcrO0Q+MwwJHSw8YiE6KxgDCAwUGxILBRwxIAEiclQtJ6pvAUhHSj8xfIyXTBctFGiXakImDgEZKjoDIgEdMD4gHBYMEQsHAgICLVxMMgAAAAL/YP/EBMED6gBBAFUAACc0PgI7ATIWMzIeATI3LgMnPgE3PgEXHgMVFAYHHgEzMh4CFRQOAisBIi4CJy4BJw4DKwEiLgIBNC4CJw4DFRQeAhc+A6AYKzohRBQoFBIMBQcMEiEbEgIBPjk/pFhXlm0/LiMwaSgiOisYGCs6IgkgTExJHTZvPCV7kpxGCCE6KxgDSR8tNBUXOzUkHzE/IRk0KRpiIjoqGAEBAQIUND1FJl6vSE5YBARSgqVXRYU8BQcYKjoiITorGAMEBwQIGh0VHxMKGCs6AbogOi4fBgUaL0MuDzU3LwoOMTc5AAAAAAIAIf/EB5sEoQBIAFsAAAUiLgQnJicVJjU0Njc+ATcXDgMVFBceAzMyPgQ3Bi4CJxUuATU0NzY3Bz4BMzIWFx4DFRQGBw4FASYOAhUUFx4ENjcuAwPRCUBfdnx6NONVMBgTGDge6w8oJRkGFHWx5YQldomRg2gbZaqGXxkbLwYeWgE2iEtMlDwrRTEbAgIMW462z94BghcvJxkNBys7RD4zDAkdLDw8AQYKFB0VWKoBXXExcjY/YTbFFUNKSxwUDSk/LBYDBw0UGxILBRwxIAEiclQtJ6pvAUhHSj8xfIyXTBctFGeYa0MlDgOfAR0wPiAcFgwRCwcCAgItXEwyAAACABD/xAjaA+oAUQBlAAAFIi4EJyYnFSY1NDY3PgE3Fw4DFRQXHgMzMj4CNy4BJz4BNz4BFx4DFRQGBx4BMzIeAhUUDgIrASIuAicuAScOBQE0LgInDgMVFB4CFz4DA8MIQWB3fXo041UwGBMYOB7rDyglGQYUdbHlhCdaUD0LJDoEAT45P6RYV5ZtPy4jMGkoIjorGBgrOiIJIExMSR02bzwYVWp5enUCzh8tNBUXOzUkHzE/IRk0KRo8AQYLEx0VWKoBXXExcjY/YTbFFUNKSxwUDSk/LBYBAgIBKHZLXq9ITlgEBFKCpVdFhTwFBxgqOiIhOisYAwQHBAgaHQ4WEg4JBAI3IDouHwYFGi9DLg81Ny8KDjE3OQAAAAIAGv1FBgkDiABDAFsAAAEyPgI3Jy4BJxcuATU0PgI3PgEzMhceAxUUBgcUDgIHDgEHDgEjIiYnLgEnFS4BNTQ+AjcXDgMVFB4CASYOAhc1HgMXHgEzMjY3LgUDB1eXe1wbvna+OQEqMBgpNBw6kE+oiTBLNBwBAQgXKCEqfUVY231nx05ViC0xMg8hNif8JzEbClCFrgFkHTswHAMCNkZEDxEuFSMyFwISHik0Pv6DMFV2RgEKU0kBM3pINm5pXiVLTpU2hpilVBctFwpJaX8/UY4wPEEsJit7TwFPuWpLiYeLTWpIfW9lL1mOYjMDxwMpQ1QoARslFwsBAgEBARxERkQ2JAAAAAIAGv1FBsIDiABIAGAAAAEyPgI3Jy4BJxcuATU0PgI3PgEzMhcWEhczMh4CFRQOAisBDgEHDgEHDgEjIiYnLgEnFS4BNTQ+AjcXDgMVFB4CASYOAhc1HgMXHgEzMjY3LgUDB1eXe1wbvna+OQEqMBgpNBw6kE+oiVNmDh0hOisaGis6IS4LKSEqfUVY231nx05ViC0xMg8hNif8JzEbClCFrgFkHTswHAMCNkZEDxEuFSMyFwISHik0Pv6DMFV2RgEKU0kBM3pINm5pXiVLTpVe/vyRGCs6IiA5Kxk2fUBRjjA8QSwmK3tPAU+5akuJh4tNakh9b2UvWY5iMwPHAylDVCgBGyUXCwECAQEBHERGRDYkAAEBKAPsAuQFqAADAAABFwcnAgbe3t4FqN7e3gABAI0DPAOJBMAABwAAAQcnByc3FzcDicC+vMLAvrwD/cG+vMHBvrwAAgC9A8ADuQZVAAcACwAAAQcnByc3FzclNxcHA7nAvrzCwL68/pKys7IEgcG+vMHBvrxhsrOyAAACAJ79OAOa/80ABwALAAABJwcnNxc3FwUXBycC2Ly+wMK8vsD+g7Kzsv5LvL7Bwby+wW+ys7IAAAIAXQBaA0sDSAATACcAAAEUHgIzMj4CNTQuAiMiDgIHND4CMzIeAhUUDgIjIi4CAT4XKTYfHzcpGBgpNx8fNikX4TtliE5NiWY8PGaJTU6IZTsB0B82KRcXKTYfHzcpGBgpNx9NiWY8PGaJTU6IZTs7ZYgAAQBE/8YCOAYSABQAAAU0CgEuAic3HgMXHgMdAgEFAw0YK0Au/zRFMB8OCgwHAjqEAQ8BCv/r0FafUbK+ymhRucC8UitWAAAAAQAQ/7AEHAX6ADQAAAEeARUUBgcOASMiJiceAxUhNAoCJxUvATMnFS4BJyUeAx8BHgM3PgM1NCYnBAULDDRIPKFiGjEXDA0GAf7NBxkwKBYGAQQKHB8BAhUdFhEIGxIoMT8pNDcZAwkIBfpIeDNjultHRwMEZ97f1l6oAVQBPgEccAE1EAkBGT42pCE1LScTQipINB0BAS5FVSgmSTIAAAEAFf+/BYcF/ABOAAABHgMVFAYHDgEjIi4CJw4BIyImJx4DFSE+AzU0LgQnJR4BHwEeAzMyPgI1NCYvASUeARceAzMyPgI1NC4CJwVeDA8KBDMvLYBLGTs+PhwzelMTIxELDgcD/soBAgEBBQ8dMEYwAREdLREjFiAfKCAcIxUIBwMEARoCAgIFEBssIhIWDAUCBw8MBfxAW0U4HmmWOjU8CBQjGzc1AQNe2N/aYBQ8QT0UV8bP1c3BVJ8tWCVUMkImDxwvPiElSiAoKAohDSxvYUIZJSkRDiA2VUMAAAAAAQAO/7oE4AXuADoAAAEiJiceAxUhNAoCJyUeARc+Azc2MjMyHgIXBzQuAgcOBRc1HgMzMj4CNxcOAQMkSIo/DA4IAv7NEDNhUgEDIDgVH1NgajUOIw8rV1hXKqAsRVMnFjc2MyUVAwY7UVgkI1JVUiOBdt8CfBsfbMi9s1jKAYsBbAFBgKM2Xy8sSjYiBAEJGzQq/AEYHRYBAxEZICMmEgEfKRgJCxYhFvBWQQAAAAACAEL/pQU8Bi4AMQBeAAAFIiYnDgEjIi4CJy4BNTQ2Nz4DNy4BJzceAxc1HgEXHgEXFhIXHgEVFA4CBwMUHgIXPgM1NCYnMy4DLwEOAwcOARUUHgIzMj4CNz4BNz4BNwOlR34tMX1JTn9fOwsEBA4NEjtUbUQKGAnWCRodHAwFCwVNmEZfjy0PEC9immpnCBYmHhwzJhYLBwEeYHF3NAwuWkw7DwgKEyEqGA0eHhsJCw4FAgUCWzswMjhEa4RBGTgdNnM5Tp+rvWwLFwrXChobGwsBBQsFSJdYef73hzBtOV2yjVoEAn8ob2dLBQYmN0AgIkUaWqCOezQMPpGVkD0pXy0gOisZER8tHCVIHBEqEAAAAAABADv/qwRtBeQAQQAANz4DNz4BNy4DNTQ+Ajc+ATMyFhcHLgMrASIOAgczDgEVFBYzOgE3Fj4CNxMHDgUHDgEHBgc7ASQ9UzEtUSs+alAtGTBEK0myYlCmWYsfNzApEg8YNjIrDQEgIEZICA8ILWRqbDVtY2qykHBQMQoCAgICAQUEU32ZTEVvKg1DYHpEMmNdUyM4Ojcz5g4PBgEKERQKHDsaJzYBAQ0WHQ/++C4ohZ2mk3AYAwcDBAMAAAEAQ/+tBR0GAQAdAAAFNAoBLgInJR4DFz4FNwUOAwcGAgcCHSVBWml1PAEBSHReSh4YNjo8PTocAQAmTUtJIk5VAlOeAR0BA+rZyV+ld/Hw63BXurevmX4rozyWq7xh4P50qwABADr/nAUuBfIAGgAABS4FJw4DByU2GgI1BRYaAh4BFwQvGz0/QD05GCFQYnZG/v9aqoVQAUUDLEldZ2owXip5kKWsr1Rq4Obqc6SPATkBZAGY7gFt/v3+7v7t+tRKAAACAH3/cgRTBjwADQA3AAABNicmBwYHBgcGFxYXFgEHFwcnJgMGIyInJicmNzY3Njc2MzIXFhMWFxQVFAcdAgYVFBcWFxYXAtgIMTlOUz4ZCgoKHHp2AdMLAuIHdTcaIXVkiFZGCQg+PVxcaphqfSILAgEBKBYdGQgD301peQICXycmJxU5FRT8VgoElg3VAkIDHih0XpSCfHlDQ22A/vBUYiQmDxANDAESBbDQeXBkDAAAAAABAA7/ugTgBe4AOgAAASImJx4DFSE0CgInJR4BFz4DNzYyMzIeAhcHNC4CBw4FFzUeAzMyPgI3Fw4BAyRIij8MDggC/s0QM2FSAQMgOBUfU2BqNQ4jDytXWFcqoCxFUycWNzYzJRUDBjtRWCQjUlVSI4F23wJ8Gx9syL2zWMoBiwFsAUGAozZfLyxKNiIEAQkbNCr8ARgdFgEDERkgIyYSAR8pGAkLFiEW8FZBAAAAAAIAQv+lBTwGLgAxAF4AAAUiJicOASMiLgInLgE1NDY3PgM3LgEnNx4DFzUeARceARcWEhceARUUDgIHAxQeAhc+AzU0JiczLgMvAQ4DBw4BFRQeAjMyPgI3PgE3PgE3A6VHfi0xfUlOf187CwQEDg0SO1RtRAoYCdYJGh0cDAULBU2YRl+PLQ8QL2KaamcIFiYeHDMmFgsHAR5gcXc0DC5aTDsPCAoTISoYDR4eGwkLDgUCBQJbOzAyOERrhEEZOB02czlOn6u9bAsXCtcKGhsbCwEFCwVIl1h5/veHMG05XbKNWgQCfyhvZ0sFBiY3QCAiRRpaoI57NAw+kZWQPSlfLSA6KxkRHy0cJUgcESoQAAAAAAEAO/+rBG0F5ABBAAA3PgM3PgE3LgM1ND4CNz4BMzIWFwcuAysBIg4CBzMOARUUFjM6ATcWPgI3EwcOBQcOAQcGBzsBJD1TMS1RKz5qUC0ZMEQrSbJiUKZZix83MCkSDxg2MisNASAgRkgIDwgtZGpsNW1jarKQcFAxCgICAgIBBQRTfZlMRW8qDUNgekQyY11TIzg6NzPmDg8GAQoRFAocOxonNgEBDRYdD/74LiiFnaaTcBgDBwMEAwAAAv9b/c8CqwO9ABkAQQAAAS4DNTQ+AjceAxcGFRQWFw4DIwE0PgI7AjI+Ajc2NTQuAiclHgMVFAcOAQcOASsCIi4CAdseMCISGjBDKQwSERELXDY/FCwqIwr9fxkqOiFnLSVRRzcMCBwuOh4BHhw3LBskKpJmPG4wiQkhOioZ/c8DGSYxGylUXGQ5CAsJCgaPTx0vGB83KBgCkyE6KxgGEiAbEiQYYHWAOY4/jpKRQmVUXnsdEQcYKzoAAAAC/9f9BwRSAacANgBNAAABDgEVFB4CFy4BPgE3Bz4BNz4BOwERJyIOAgcOAxUUFhUHJicuAScOASMRMjY3PgM3ASIuAjU0NjceAxcGFRQWFw4DAbsYFg0dLB8GAw0iHgMwnGQZNhV7ehIqKiUNHiscDgG32l8gLgwgUzpCUgMEExcVBgLoIjYmFGpYEBIPEA9jO0IVLSkjAUU8eSghanNtJSRmbGQhA0VWDwQC/sQBBgsSDBpRXWAoDywNZomrPH9FBQMBPAMKDCwvKQr7YBosOR5TwXcLEhEOB5hMFywaM0AkDQADAAr/wQaNBLoAOQBOAF0AADc0PgI7ATIeAjcuATU0PgI3LgEvARMeAxceAxceARUUBgcOAyMiJicOASImJy4DASYOAhc1HgMXPgM1NC4CBRQGBzMyPgI1NC4CJwoZKjohCQ88TFIlIyQUKDwpCxEIEMEraHB0OF+MbFYpNC5zcB9TWlgkVapOMYigsVokPS0ZAzQgQjMdBAMaJy8XID0wHRonMAF0MDAJOWZNLSE2RiWlITkrGBQYEgI8h0U0aF9VIwUKBQkBHB4+PTkZLENBSDBCnElwx0MSGhEIHiAOEBITBxsnNQJmBTBMWycBGjczJwkTPUhMIhw4LyCjVadIFSQyHhg3NzQVAAAAAQBC/zIHWwI4ACcAAAUiJicuAScmJyY2Nz4DNwMzDgMHBgceAz4DNwMGDAIDLT12N1GLOpg1Hg0mJ5PI84YEATyRi3gjJhQRbaTS6/v352Mlfv74/vj+/csFBwkiGEFuP4RCRVY2IA/+6QcYGx4NDg0RGBAHAQoRGhD+5SAlEwIAAAAAAQAX/fYF2AEAADoAAAEiJicmJyYnJjc2Nz4CJDsCMh4CFRQOAiMhIiYqAQ4BBw4DBw4BBx4EMj4BJxMiDgIDoFi4W6J1lzU7T0SiJZHPAQugtwchOSsZGSs5If7OASZAU1xgLBdITEQSFBwKI3qYq6aYc0MBSgVFcpf99ggLEjJAb3t+az8OIh0UGSs5ISE5KxkBBAcGAwkMDQcIDgYXIRYNBwEEAf76BwcGAAEAEv/FCHkGtgBNAAABHgEzMj4CNyM+ATc+ATU0LgIvARMBEwEeBRUUBgczDgMHBgQrASoBJyYkJyYnFSY1NDY3PgM3Fw4DFRQeBBcD0BgxFk+Qel0cATQwCA8NQmd9O9EhA4Z8/T84c2pdRSgtMwEGHTFIMYr+6JEVFSwVu/7YcONVMBgTDBEQFA/tDiEbEjdhg5moVQEFAQEMFBcLFiIJESUUK2NmZi+sASgBif7a/tMvZGltcXQ8QohICSIqLxc9KgICKypYqgFdcTFyNhwmICAXrRk0NjgcJz0tIBYMAwAAAAEAHP/ECa4GpABXAAABMh4CFRQOAiMiJCcOAQcOAyMuAycmJxUmNTQ2Nz4DNxcOAxUUHgQzMj4CNyM+ATU0LgQnEwETAR4DFzUeAxcjHgEXCRAhOisYGCs6IZ/+9WMkWTA4g6HEeV2fi3o441UwGBMKEBEVEewNHxwTRHKXqK1QTZSAYx0BS0IuS2BlYicgA5tw/QFIeGRRIg8sOkYqASFJNgEAGCs6ISE6KhlraiY2FRkmGQwBDBUgFViqAV1xMXI2GyQgIResFjQ5OxwqQC8fEwgMExcKHUoqLWhsa2FTHgERAYP+6v7JOXd+h0oBK1pURxkPEAH//wAS/8QIeQeQACYAUwD/AAcBGQQyAGT///9c/8MEJQd8ACYAHgQAAAYBGe5QAAD///9i/8QFTAeGACYAHwsAAAYBGSdaAAD//wAc/8QJrgeeACYAVAAAAAcBewR4AEoAAQAv/RMGKgKYADcAAAEiLgInLgM1NBI3Fw4DFRQeAhcWPgQnLgUnJR4FFxYUFRQOBAMtRZGOhDk5UzYbaWfhFDYyIkt9o1hHhnhjRyUDAhwnLykeBAEQAx0pLikeBAEoU32q2P0TDSVAMzJ5iJRNpAFOnKIbbIqbSFOGYDYCARoySFloOStscW5dQgyXBEBlgo6SQggXCFmwoYllOQAAAAEAAf0VB0oCnwA8AAAFIicOAwcOASMiJicuAzU0PgI3Fw4DFRQeAhcWPgI1NC4CJyUXHgMzMh4CFRQOAgarXFcDJkdrSGbznK75XDhTNhsYMksz4R02KRlMfaBVdcKMTSI3SScBEWUpTUhBHCE6KxkZKzo8HVGom4QuQkRTTzJ5h5NMVpucpF+iNIGJiDtOgl01AQIpWo5kOoONlU6tw1NZKQcYKzohIToqGQAD//j/wwS0Bl0AAwAHAAsAACUHJzcBByc3AwEhAQS09PX0/iL09fSLAn0BYP1/z/P18wNr8/Xz+Z8GmvlmAAAAAv/8/2YD+QZkACkALQAAATQuAicmJyYnJjU0Njc2MzIXNRYHBSYnJiMiDgIHBhYXHgEXHgEdAQcXBycBmAMEBwQUXKw4Nk5Glertfn8I/vIDQD9eLFZHLQIDWUtVbxYRE3ne3t4BozhPNyEJK0aaWFVjW55Cg4EBf94elTk5FjBKMy1vOT9pKiNXM7aB3t7eAAAAAAEAHP/UAeECrwAXAAAlFAcGIyInJjUQJR4DFw4BBzYeAhcB4TNBZHJCOQEcCiwyLw1RaBQsSTYiBZU9PEhXS24BAMsHIiglCjxuLQYaNkwrAAAAAAIAIf/VAdUEgwAPACQAACUUBwYjIicmNTQ3NjMyFxYTFA4CIyInLgE1EDcXDgEHNh4CAbM0M0NFMzIyMkZFMjMiIDZIJ3BDGyHolUVICy1JNiB9RDQwMDJGRjIyMjMB2idGNR9XJF82AQSUjitIKgYWMksAAf+0/0YCogPSAAMAAAcBMwFMAgbo/fu6BIz7dAAAAAABACP+OQIRAUsAEgAANzQ+Ajc2FxYXNRIFJzY3BwYnQSQ8TSh1QToBCv5mVNYjILcEhCpHNB8BAlVKbwH+yM3LXmkCAbsAAAAB//oAzgPNBHcAEgAAARMlFwUTByUFJxMuASc3BT4BNwIJXAFOGv7ocUL++/73OG9Fi0MVAU4WMBYEd/6+C0u8/sYtzdE2ATUtXy1OC06mTgAAAAAC/+YELAHIBroAAwAHAAABBTUlNQU1JQHI/h4B4v4eAeIE9Mixv3bIsb8AAAL/6/0RAc3/nwADAAcAAAEFNSU1BTUlAc3+HgHi/h4B4v3ZyLG/dsixvwAAAf/iBGoBxAXaAAMAAAEFNSUBxP4eAeIFMsixvwAAAAAC/7QELwGwBowAKQA7AAADPgM3Jy4DNTQ3PgMzMhYXHgEXNR4BFRQHFwcuAScOAw8BEyIOAgceAxc2JjU0LgJMFD9HSh4bIS0bCw4NKTI4HREjDyAyCwcFCx0rFx0KJmFdTRIo/wcUFBEFAx8qLBABAQkRGQS7BhIXHRELECktLxYkHxotIRMIBxE8JQEVJxQtLgaNBAgEIDcrHQYKAdwIDhEKBxgbGAcEBAUUKSIZAAL/PQQyAfYGfwA/AFEAAAM+AycmDgIHJz4DFx4BFx4BDgEHPgM3LgE1NDY3PgMzMh4CFx4BFRQGBx4BFwcnDgUHATQuAicmBgcGHgIXJxc+AR4KGxICDwYmKiUGTgQdLTsjJ0kRDQkCCQQOJSYlDkxCCAcNKTI4HB0zKh4JBgUIBQgQBSk6HElOTUEuBwFBCA4VDQ4rDQINFx0OAS4CAgSFECUnKRUJBxEUBVgEHBwWAQIgIhsoIBoMBQ4QEAcqXyoUIQ4aLSITFCIxHBMlExk0FgQIA4AQGSoiGhMKAQF4DRsXEAIBFxMDDhITBwEXChYAAAAB/+v+AQHN/3EAAwAAAQU1JQHN/h4B4v7JyLG/AAAAAAH/swRLAhYGEwA3AAATLgMnLgE1ND4CNxcOARUUFjMyPgI/AR4DMz4BNTQuAic3HgMVFA4CIyImJw4BciU3KBoIDQwKDQ8FeA4RGRQYGQsCAmQHGRoXBRciFB0jD3sHIiMbHjNEJRc5Gxo9BEsBEBcbDRY1Fxk3MSYIPxo+FhIVHCkxFSY7QB4GAhcRES0vLBFVCjVGTiQiRTgjDhcaGgAC/+YEOAG1BiwAEwAnAAATMj4CNTQuAiMiDgIVFB4CEzYeAhUUDgIjIi4CNTQ+As4VJBsPEBskFBUlHRERHSUVL1Q/JSU/VC8vVT8lJT9UBNQTHCEODSAbEhIbIA0OIRwTAVcBLEhZLS1ZSCwsR1otLVlILAAAAAAB/y8ERQJkBZcAKQAAAzQ+Ajc+ATc+ATMyFh8BHgEXFj4CNxcOBScGLgIHDgMH0Q0REAMkYTAKHgkwTh8fESITECIhHw6cARQlM0BLKh9AQ0YmFx0UDggEegYhJiEFN0YLAgEXDg8IDQEBEh8mE2UDHywxKRoBAh0hFwgFGSEmEgAAAAAB/8gEQgHxBtQANAAAAS4BJy4BIyIOAhc1HgM3PgE3PgE3Fw4FByc3LgEnJjU0PgI3PgEzMhYXHgEXAUUIEAgOIxAaNioUCQchLTUaGj8aEB4PPhIiL0NkjGAzgR0tDhAXKDchGjcdGDIUDBcLBjUBAgICAxMgLRkBEBwSAwkIIhEKFAuSCxYdJzlNNJFMFTggIzMjQzovDgsKBwQCBQP////u/QECF/+TAgcAawAm+L8AAAABAGcEQgEYBkIAFQAAEz4DNTQuAic3HgMVFA4CB2cHCwcDAwcLB5MGCwgFAwcLBwRzGzs5MRERMTc6GzAaP0E+GBc/SE0lAAABAH79hAE8/4QAFQAAEz4DNTQuAic3HgMVFA4CB34HCwcDAwcLB6AGCwgFAwcLB/21Gzs5MRERMTc6GzAaP0E+GBc/SE0lAAAC/0kEMwJEBxgALwBEAAATIiYnJic3HgEXPwE+ATU0JicuAScuASc3HgEXHgEXPgE3Nh4CFxYOAgcOAyczMj4CNz4BNTQuAgcOAw8BuQ8eDoOyNiI5Gg0YBQYEAwQIBQIGApICCQMGCwIqUiYkT0QwBAILFRwOKVVSTmElGUxSThsMDhUhJhASNDs8GQYEMwEBBkSGDRQHFSEkOhsaOycwUyATIhAoHEocOXI8HygHBhErQisaMzApDyUtGAiSBxEcFQ0cCwoTDAUDAxYjLxsHAAAAAAEALf/EBYQEzAAzAAAFIiYnNx4DMzI+Ajc2Ny4DJyUXFhIXHgMzMh4CFRQOAiMiLgInDgEHDgECFoP7a7UxXFRLIQ8mJiQPNB4mWVpYJgEkWSt4ThIeKTktIDorGhorOiA9XUk5GRs8JzyLPGRv/y05IAwCBQgGFhZcx8nGW3rYav7duCxCLBUYKzohITorGBAdKRkSIRAXFQAAAAL/ggQ4AiAFqAAkADcAAAM2Nz4BFx4BFx4BFz4BNz4BMzIWFx4BDgEHDgImJw4BBw4BByUuAQ4DBzMyPgI3BzY3LgF+IRwZNhEMGAoFDAUOKRolYzkkQRkZFAcgHC9/gnYmESgRChMKAhwRLjIzLSMJGhY/QDYOARECAgQEzBQNDBEEAQgFAwYEFzoaIy8cGho/QD4ZIScCKjECEQoFDQe8EwgMGyEiDAQJDgsBDhcFCgAAAAH/W//EAqsDvQAnAAAnND4COwIyPgI3NjU0LgInJR4DFRQHDgEHDgErAiIuAqUZKjohZy0lUUc3DAgcLjoeAR4cNywbJCqSZjxuMIkJIToqGWIhOisYBhIgGxIkGGB1gDmOP46SkUJlVF57HREHGCs6AAAAAf9i/8QDXwLdACwAACc0PgI7ATI2NTQ2LgEnJR4BFRQeAjMyHgIVFA4CIyImJw4BKwEiLgKeGCs6IRGLjgEHExMBHRUgCxkrISA6KxoZLDkgYIgxSMeIESE6KxhiIToqGVlbEhwtSUBFPJVYHT81IxkqOiEhOisYNy40MRgrOgAB/2L/xAMdA7sAKQAAJzQ+AjsCMj4CNzY1NC4CJyUeAxUUBw4BBw4DKwIiLgKeGSo6IW8wLWxkURMLKTg7EgEdHzouHCQqkmYeWlxSF5EJIToqGWIhOisYCBIfGBEdK3Z6cCWMNpOblTdlVF57HQgKBQEYKzoAAAAB/1v/xAPzAuMAMAAAJzQ+AjsBMj4CNzYuAiclHgEXHgMzMh4CFRQOAiMiJicOAysBIi4CpRgrOiFMSIVmPwIBAQoTEQEjEyAIAgoXKCAhOisZGSw5IGCJMS11hIxETCE6KxhiITorGAwnRzsWHSlDPVIwnl4eQDYjGCs6ISE6Kxg7Lx4oGQsYKzoAAAEANv/EBe4C0wA0AAABMh4CFRQOAiMiJiMuAycuAyMiBgcOAwclPgM3PgEzMh4CFx4DFzsBBVAhOSsZGSs5IQMFA1OEb2AuHTs8PiAOHhEnQzgsEv7UG0lnilsqSyRTh3JhLxs7PD4eAQYBABkrOSEhOSsZAQEzUmc2Ikk8JgUFD01rgEFQZLubchwNCzJSZzYgPjIhAQD//wA3/RIGEwTNACYABxgAAEcAQAGpAQA2CDYH//8AL/yxB0MEagAmAAoAAABHAEABiACnNgg2BwABAOP9xQKO/3AAAwAAAQcnNwKO1dbV/prV1tUAAQCB/dADff9UAAcAAAEHJwcnNxc3A33AvrzCwL68/pHBvrzBwb68AAEAVP/BAc4FxQAbAAAXPgM1NC4CLwElHgUXHgMVFAIHeQUJBgQKDhEHDQE3BAYFBwgLCAUHBAIICz9NqKSbQKfwq3MsTGMOGCEwTnBRTnx2fU+C/t2gAAABAIP/xAMdBdEAMQAABSImJy4DNT4BNTQuAiclHgMXFBYUFhUUBgcUBhUGFhceARczMh4CFRQOAgJ+e7BAKCsTAwEDAgkRDwE0DA4IBAEBAQEBAQEDCw1LMwkgOisaGis6PD0/KFhVTBswj15e1bWmTV1Ck6ydVRk6OzYVNFYqDzEPITgKDg8BGis6ICE6KxgAAAD////C/8EB6wgWACYAewoAAAcAa//6AUL//wAh/8QDMQg+ACYAfBQAAAcAawBZAWr//wAe/MUCRwXFACYAe/cAAAcAawBW+IP//wCK/OkDMQXRACYAfBQAAAcAawDC+Kf////B/8EC9gcfACYAe1MAAAcAagCSAYj///+f/8QDMQc6ACYAfBQAAAcAagBwAaP///+q/8ECSAdqACYAewYAAAcAcQAoAcL////r/8QDMQd6ACYAfBQAAAcAcQBpAdL//wAp/bwHtAOzACYANQQAAAcAPQHn+dD///9b/a0CqwO9ACYAcgAAAAcAPf8b+cH///9i/bwDXwLdACYAcwAAAAcAPf96+dD//wAz/bsJnQN8ACYANvIAAAcAPQIU+c///wAj/K4HrgOzACYANf4AAAcAQAHU/3b//wAq/KMJlAN8ACYANukAAAcAQAIR/2v///9i/LMDHQO7ACYAdAAAAAcAQP97/3v///9b/LQD8wLjACYAdQAAAAcAQP+C/3z//wAW/8QHoQSgACYANfEAAAcAPgHk/+D///8+/8QDJwWgACcAPv+eAOAABgB03AD///9b/8QD8wTpACYAdQAAAAYAPrMpAAD//wAs/8EJlgSbACYANusAAAcAPgIz/9v//wAd/8QHqAWeACYANfgAAAcAPwG0/0n///9i/8QDSgavACYAP5FaAAYAdAAAAAD///9b/8QD8wYGACYAdQAAAAcAP/9q/7H//wAT/8EJfQWeACYANtIAAAcAPwHk/0n//wAk/8QHrwY4ACYANf8AAAcAbwMc/yD///9d/8QCswcsACYAcgIAAAYAb28UAAD///9b/8QD8wYMACYAdQAAAAcAbwC6/vT////y/8EJXAX9ACYANrEAAAcAbwL//uX//wA4/8QD3gYSACYAKiUAAAcAPv/FAVL//wBt/8QFBgZ7ACYALSUAAAcAPgBqAbv///9f/LoGFQPQACYACAAAAAcAQADT/4L///9h/M8HIgPSACYACQAAAAcAQADS/5f//wAl/RIGAQTNACYABwYAAAcAPQFP+zD///9f/bgGFQPQAiYACAAAAAcAPQDx+cz///9h/boHIgPSACYACQAAAAcAPQEJ+c7//wAv/LEHQwRqACYACgAAAAcAPQF3+r///wAf/RIF+wcQACYABwAAAAcAPQAdAWj///9f/8QGFQXtAiYACAAAAAYAPURFAAD///9h/8MHIgXjACYACQAAAAYAPSY7AAD//wAv/LEHQwaEACYACgAAAAcAPQBNANz//wAa/7kERAbZACYACwAAAAcAPf/OATH//wAt/8QFhAb5ACYAcAAAAAcAPQBcAVH//wAi/7kETAf8ACYACwgAAAcAbwECAOT//wAt/8QFhAgeACYAcAAAAAcAbwFvAQb///9H/NoCugUBACYADAAAAAcAPf+D/1n///9H/NoD2AT5ACYADQAAAAcAPf93/1H///9H/NoC+QX6ACYADAAAAAcAbwC1/uL///9H/NoD2AYIACYADQAAAAcAbwCN/vD///+p/NoDVAXyACYADGIAAAYAP5udAAD///95/NoECgXSACYADTIAAAcAP/9//33//wAh/TEKdwZMACYADgAAAAcAPwUy//f///9o/7cGWQZZACYADwAAAAcAPwFtAAT///9f/8EH6AY7ACYAEAcAAAcAPwGx/+b//wAY/TAL8QYXAiYAEQAAAAcAPwVu/8L//wBM/TsLOAXCACYAEgAAAAcAPQbWABr///9h/7AHVAX/ACYAEwAAAAcAPQMHAFf///9h/7EILQXpACYAFAAAAAcAPQM5AEH//wAj/TsL1QW8ACYAFQAAAAcAPQbmABT//wAO/8QGxgY2ACYAFgAAAAcAPQLxAI7///9e/8MF0wZGACYAFwAAAAcAPQIBAJ7///9e/8MGzwYwACYAGAAAAAcAPQIVAIL//wBA/8QH6QYwACYAGQAAAAcAPQL3AIP//wAt/LIF4QejACYAGgAAAAcAPQGcAfv///9g/8QEOQYvACYAGwAAAAcAPQAcAIf///9t/8MFJAYcACYAHAsAAAYAPVN0AAD//wAR/KoF4gZgACYAHfoAAAcAPQEBALj///9N/8MEFgadAAYAHvUA////Yv/EBUwGowAGAB8LAP//ACH/xAebBuEAJgA5AAAABwA9A64BOf///1//xAOEBtsAJgA3AAAABwA9/30BM////2D/xATBBisAJgA4AAAABwA9AAcAg///ABD/xAjaBhcAJgA6AAAABwA9BCQAb///ACH/xAebB6QAJgA5AAAABwA/A20BT////1//xAOEB0EAJgA3AAAABwA//yQA7P///2D/xATBBt8AJgA4AAAABwA//8MAiv//ABD/xAjaBs8CJgA6AAAABwA/A/sAev///1//xAOEBqIAJgA3AAAABwA+/4kB4v///3f/xATYBgIAJgA4FwAABwA+ABMBQv//ABr9RQYJBVAAJgA7AAAABwA+AeMAkP//ABr9RQbCBZUAJgA8AAAABwA+AdsA1f///1v/xAKrBfIAJgByAAAABwA9/0QASv///2L/xANfBT0CJgBzAAAABwA9/3//lf//AC/9EwYqA4YAJgBZAAAABwA9ASf93v//AAH9FQdKA4kAJgBaAAAABwA9AOv94f//ABP/xAO5BHMABgAqAAAAAwAT/8QDuQb8ACAANABqAAAFIi4CJy4BNTQ3PgM3LgEvATceARcAFRQGBw4DEzQuAicOAxceAzMyPgIDJy4BIyIHMw4DFRQXNR4DMzI3PgE3PgE3Fw4BDwEnNy4BJyY1ND4CNz4BMzIWFxYXAeUFLUFRKW14sQ4TEA8KDBcIEsczjl0BA3FkI0lEO64oQVAoGzwyIAIBLD1EGB5FOSayIQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcXPAMKFhM0tXjI1xEWEg8KChIIEPMmgWT+2eZ2tjQRFQwFAZcfTlVXKB5LVFkrGCQWCwkWJAUqCAMGCQYTGBsODBIBDxsUCwUJGw4IEQhmJUUuhXFdFDwjJCwhPzYrDgsJBwUECAADAEj/xAThBswANgBHAH0AACUiJicuATU0Njc+AzcuAS8BJR4FFx4DFx4BMzIeAhUUDgIjIi4CJy4BJw4BAzI2Ny4BLwEOAxUUHgITJy4BIyIHMw4DFRQXNR4DMzI3PgE3PgE3Fw4BDwEnNy4BJyY1ND4CNz4BMzIWFxYXAiCOzDwjHw4KKHV/fTECAwIFATgBBwkLCQcBDxUPCgMPPTMgOisaGis6IBU0OT0eKj8dM18zFS0VBQsFCiZeUzgtQkqPIQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcXUE1GLWkwKkQYVH5dPhQXMBY/QwlCW2daQgd7nl0pByAZGCs6ISE6KhkDCREOFDMnBwYBOgMCIlQwXBM1Oz0aDRELBASxCAMGCQYTGBsODBIBDxsUCwUJGw4IEQhmJUUuhXFdFDwjJCwhPzYrDgsJBwUECAAAAAADABz9BAQEBgwAFwA/AHUAAAEmDgIVFB4CFyMeATMyFjoBNy4DAT4DNyImJy4BJy4BNTQ+Ajc+ATMyFx4DFRQGBw4FBwEnLgEjIgczDgMVFBc1HgMzMjc+ATc+ATcXDgEPASc3LgEnJjU0PgI3PgEzMhYXFhcCBhU1Lx8mO0chARpDIAoLCAkJDyk2RP3sjeivcxgrYB90wDkqIxQkMRw8j0+piDBMNRwDAgxRf6jF3HQBmiEPJBIdHAEOHRcPBgYdJSoTEw4bNRYNGQtNMHtV8D6nIjYPDxYmNB4ZNBsXMRQXFwJOBCU/TCMhLBwOAwIBAQE+cVo7+/EcVWl2PQMCClNHNn5GNm1nXCZLTZQ2hpelVRo0F3XNrY1rSBIIdwgDBgkGExgbDgwSAQ8bFAsFCRsOCBEIZiVFLoVxXRQ8IyQsIT82Kw4LCQcFBAgAAAADABz9BASzBecALgBHAH0AABM+AzciJicuAScuATU0PgI3PgEzMhceAxczMh4CFRQOAisBDgIEBwEiDgIVFB4CFx4BMhYXLgMnLgMTJy4BIyIHMw4DFRQXNR4DMzI3PgE3PgE3Fw4BDwEnNy4BJyY1ND4CNz4BMzIWFxYXHI3lrXAYK1gfdMA5KiMUJDEcPI9PqYgqRDQhBhMhOisaGis6ISwnq+3+3Z8BoBY1Lh8mO0YhEisuLRMHHiUrFAcVFhcXIQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcX/jccVWl2PQMCClNHNn5GNm1nXCZLTZQvcoGMSRgrOiIgOSsZk+6ydBkFSic8SiMiLBsNAwIBAQExVko7FgcQDQgDCAgDBgkGExgbDgwSAQ8bFAsFCRsOCBEIZiVFLoVxXRQ8IyQsIT82Kw4LCQcFBAgA////W//EAqsDvQAGAHIAAP///2L/xANfAt0CBgBzAAD///8w/eUC8gO7ACcAPv9p+qkABgB0zgD///9b/cMD8wLjACYAdQAAAAcAPv9Q+of//wAP+zEG4gOIACYAMAAAAAcAPgEd9/X//wAm+1YHUwJcACYAMQAAAAcAPgEm+Br//wAP/QUG4gOIAAYAMAAA////MP26AvcDuwAnAD7/bvp+AAYAdM4A////W/2cA/MC4wAmAHUAAAAHAD7/j/pg//8AJv04B1MCXAAGADEAAAACAGP/Mgd8BNQAJwBdAAAFIiYnLgEnJicmNjc+AzcDMw4DBwYHHgM+AzcDBgwCAScuASMiBzMOAxUUFzUeAzMyNz4BNz4BNxcOAQ8BJzcuAScmNTQ+Ajc+ATMyFhcWFwNOPXY3UYs6mDUeDSYnk8jzhgQBPJGLeCMmFBFtpNLr+/fnYyV+/vj++P79/v8hDyQSHRwBDh0XDwYGHSUqExMOGzUWDRkLTTB7VfA+pyI2Dw8WJjQeGTQbFzEUFxfLBQcJIhhBbj+EQkVWNiAP/ukHGBseDQ4NERgQBwEKERoQ/uUgJRMCBREIAwYJBhMYGw4MEgEPGxQLBQkbDggRCGYlRS6FcV0UPCMkLCE/NisOCwkHBQQIAAAAAv/x/fYFsgO/ADoAcAAAASImJyYnJicmNzY3PgIkOwIyHgIVFA4CIyEiJioBDgEHDgMHDgEHHgQyPgEnEyIOAgEnLgEjIgczDgMVFBc1HgMzMjc+ATc+ATcXDgEPASc3LgEnJjU0PgI3PgEzMhYXFhcDeli4W6J1lzU7T0SiJZHPAQugtwchOSsZGSs5If7OASZAU1xgLBdITEQSFBwKI3qYq6aYc0MBSgVFcpf+jiEPJBIdHAEOHRcPBgYdJSoTEw4bNRYNGQtNMHtV8D6nIjYPDxYmNB4ZNBsXMRQXF/32CAsSMkBve35rPw4iHRQZKzkhITkrGQEEBwYDCQwNBwgOBhchFg0HAQQB/voHBwYFOAgDBgkGExgbDgwSAQ8bFAsFCRsOCBEIZiVFLoVxXRQ8IyQsIT82Kw4LCQcFBAgAAAAAAgAP/QUG4gTkAF8AlQAAAT4BMzIWFwMuASMiBw4FBwYeAh8BHgMVFAYHDgMHBgQjIiQnLgE1NDY3PgU3Fw4DBw4BFRQWFx4DMzI+AjciLgIvAS4DNT4DNyUnLgEjIgczDgMVFBc1HgMzMjc+ATc+ATcXDgEPASc3LgEnJjU0PgI3PgEzMhYXFhcFTh4+HkOPSG8wViYaISBKSUQ1IgICJDxMJx1Af2Y/AwQKNE9nPXP+2KrM/shnTkkEAgQYHyQeFQL7GS0jFwMBAictG1dufkF/3ahnCAIUHycVNlmddUUFVpLDcv1vIQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcXA3oIBicm/tsVFwYDHzA/RksjHCMZEwwHDyZFcFkSJxU2Z11RIDk/d3Jd3nkaNBdIi3tpTy8FaTtxd4ROCxoKP3oxHy8hESM5SycEBwkFDBY5XY1sc9q0fxjZCAMGCQYTGBsODBIBDxsUCwUJGw4IEQhmJUUuhXFdFDwjJCwhPzYrDgsJBwUECAAC/1v/xAKrBg8AJwBdAAAnND4COwIyPgI3NjU0LgInJR4DFRQHDgEHDgErAiIuAgEnLgEjIgczDgMVFBc1HgMzMjc+ATc+ATcXDgEPASc3LgEnJjU0PgI3PgEzMhYXFhelGSo6IWctJVFHNwwIHC46HgEeHDcsGyQqkmY8bjCJCSE6KhkCliEPJBIdHAEOHRcPBgYdJSoTEw4bNRYNGQtNMHtV8D6nIjYPDxYmNB4ZNBsXMRQXF2IhOisYBhIgGxIkGGB1gDmOP46SkUJlVF57HREHGCs6BT0IAwYJBhMYGw4MEgEPGxQLBQkbDggRCGYlRS6FcV0UPCMkLCE/NisOCwkHBQQIAAAC/2L/xANfBZoALABiAAAnND4COwEyNjU0Ni4BJyUeARUUHgIzMh4CFRQOAiMiJicOASsBIi4CAScuASMiBzMOAxUUFzUeAzMyNz4BNz4BNxcOAQ8BJzcuAScmNTQ+Ajc+ATMyFhcWF54YKzohEYuOAQcTEwEdFSALGSshIDorGhksOSBgiDFIx4gRITorGAKDIQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcXYiE6KhlZWxIcLUlARTyVWB0/NSMZKjohITorGDcuNDEYKzoEyAgDBgkGExgbDgwSAQ8bFAsFCRsOCBEIZiVFLoVxXRQ8IyQsIT82Kw4LCQcFBAgAAAAAAgAm/TgHUwM2AEcAfQAAASIuAicuATU0PgI3BQ4FFRQeBDMyPgQ1NC4CJzMuAScuAycTITIeAhUUDgIrAR4BFw4FEycuASMiBzMOAxUUFzUeAzMyNz4BNz4BNxcOAQ8BJzcuAScmNTQ+Ajc+ATMyFhcWFwM+XcW3njYzOA8gMyQBAR0pHBAIAjBSa3R3NRpmeX9oQiE5SysBMGkzCBkaGQgpAyIgOisaGis6IG8VEwEFVYaqsq0RIQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcX/TgVOmlUUcJ4WJ+coFprSHRfUElHJ0tuTDEaCgcRHCk3JQQUGyERDxUIAQQFBQIBMBgrOiEhOisYKFEdXpNwTjEWBW0IAwYJBhMYGw4MEgEPGxQLBQkbDggRCGYlRS6FcV0UPCMkLCE/NisOCwkHBQQIAAD///+B/3gEyAeyAiYAMgAAAAcAa/+5AN7////9/3oGXQesACYAMwAAAAcAawA1ANj//wAW/IwEyAY1AiYAMgAAAAcAawE2+Er//wB9/K8GXQYuACYAMwAAAAcAawGf+G3////T/3gFLgbTACYAMmYAAAcAagCkATz////G/3oGXQa9ACYAMwAAAAcAagCXASb//wAW/3gEyAcbAiYAMgAAAAcAcQDjAXP//wB9/3oGXQb6ACYAMwAAAAcAcQFHAVL//wBI/8QE4QSPAgYALQAAAAMAHf/EA8MGyQAgADQAagAABSIuAicuATU0Nz4DNy4BLwE3HgEXABUUBgcOAxM0LgInDgMXHgMzMj4CAycuASMiBzMOAxUUFzUeAzMyNz4BNz4BNxcOAQ8BJzcuAScmNTQ+Ajc+ATMyFhcWFwHvBS1BUSlteLEOExAPCgwXCBLHM45dAQNxZCNJRDuuKEFQKBs8MiACASw9RBgeRTkm2SEPJBIdHAEOHRcPBgYdJSoTEw4bNRYNGQtNMHtV8D6nIjYPDxYmNB4ZNBsXMRQXFzwDChYTNLV4yNcRFhIPCgoSCBDzJoFk/tnmdrY0ERUMBQGXH05VVygeS1RZKxgkFgsJFiQE9wgDBgkGExgbDgwSAQ8bFAsFCRsOCBEIZiVFLoVxXRQ8IyQsIT82Kw4LCQcFBAgAAgBK/8QGAgT0ADQAagAAATIeAhUUDgIjIiYjLgMnLgMjIgYHDgMHJT4DNz4BMzIeAhceAxc7AQEnLgEjIgczDgMVFBc1HgMzMjc+ATc+ATcXDgEPASc3LgEnJjU0PgI3PgEzMhYXFhcFZCE5KxkZKzkhAwUDU4RvYC4dOzw+IA4eESdDOCwS/tQbSWeKWypLJFOHcmEvGzs8Ph4BBvx7IQ8kEh0cAQ4dFw8GBh0lKhMTDhs1Fg0ZC00we1XwPqciNg8PFiY0Hhk0GxcxFBcXAQAZKzkhITkrGQEBM1JnNiJJPCYFBQ9Na4BBUGS7m3IcDQsyUmc2ID4yIQEDYwgDBgkGExgbDgwSAQ8bFAsFCRsOCBEIZiVFLoVxXRQ8IyQsIT82Kw4LCQcFBAj//wAT/8QDuQRzAAYAKgAA//8AOP/EA94GHAAmAColAAAHAD7/tAFc//8AXv/EBhYE2AAmAHYoAAAGAD49GAAAAAIAE/1LBWIDzgBEAFUAADc0PgI/AT4FNx4DFRQOAgceAxcmPgQzMh4CFRQOAisBDgMVFB4CFwcuAycjBwYuAgE2LgInDgUHPgMTEiMxH3wEIjlOYXFAQ3JRLk5+oVQHLTk6FAEkQVhlbDUhOisZGSs6IQQsUj8mBhAbFbd4tYRZHQSAHz4xHwL8AgUPGhMTLS4rIhUBK11PNhEhLiIaDDFCoaWefE8EAUl2lk1brJV3JhhDRDwSOnlwY0orGSo6ISE6KxgGL0dXLRQjJCgX30mQlJxVMAwULkECDxw/OzAMCjhQX2JdJQgxR1b///9Y/8EFvgS6AAYAKwAA////Yf1LBIwDzgAGACwAAP//AF0AbgNLA1wABgBBABT//wBE/8YCOAYSAAYAQgAA//8AEP+wBBwF+gAGAEMAAP//ABX/vwWHBfwABgBEAAD//wCB/3IEVwY8AAYASgQA//8AQ/+tBR0GAQAGAEgAAP//ADr/nAUuBfIABgBJAAAAAQBo/5IEvwW4AEEAAAEGBw4DDwEuAScuAwcOARUUHgIfAR4DFwUuAycuAScuAzU0PgI3PgEzMhYXHgMXPgM3BL9NRh5APDcVthc6JA8nLjQcCgcaLDogWCU4JhQC/vcJGiAkEyhRKhAgGRAQJDoqGl85OXUxDiEdFQIURFBWJwTmQlEjU11oODhstTYVKB0MBgIUCxVHXXNAtlSjloIzSDp5dWwvXrxYJFNaWyssU0tCGxAcPzEOLTtJKjWAd18VAAAAAAEAIP+wA8sFhQA3AAAFBw4BBzcOAyMiJicuAScuATU0Njc2Ejc+AzceAR8BDgEPATcDDgMHMh4CFzI+AjcDy0cdPhMDIVFbYC4uUjM2bCoOEUlCPM6kFTU1LQ0XPR1EEBwOVgHwOm1XOwgBCShRSi16gHgsDBQIDwIBBgkGAwYGBRINP24watFtZwElwBo+PDIOGEciUhMjEWsB/shMj3xkIAEEBwYHEBgRAP///+YELAHIBroCBgBiAAD///89BDIB9gZ/AgYAZgAA////6/0RAc3/nwIGAGMAAP///+IEagHEBdoCBgBkAAD///+0BC8BsAaMAgYAZQAA////6/4BAc3/cQIGAGcAAP///7MESwIWBhMCBgBoAAD////mBDgBtQYsAgYAaQAAAAH/nQRKAgUGqQAzAAATIiYnLgEnJjU0PgI3Fw4BFzUeAxcjPgM1NC4CIzceBRUUBgcOAQcOAQe4N2QlIS8IAwUQHRl8HR8GAhkpNBwCH0I2Ix4lIQOHAhEYGxYPBwoONyQmZjkESiMgHlcwFR4TIzFIODIrbzQCCRcWEAEBCBcqIxlAOSd8AhwtPEJFIRs2HShIGBggAgD///8TBFsCDwhKAiYAaPkQAAcAZv/WAcv///+MBEQB7wiPAicAaP/ZAnwABwBjABEHMwAA////swQ0AhYIVgImAGgA6QAHAGIAHgGc////qgRNAg0HPwImAGj3AgAHAGT/7AFl////qARHAgsIOgImAGj1/AAHAGUAFgGu////rwQ9AhIHdAInAGj//AFhAAcAZwAeBjwAAP///58ENwICB9gCJgBo7OwABwBt//UBlv///7sEQgHxCVcCJgBrAAAABwBi/9UCnf///8gELgHxCC0CJgBrAOwABwBk/+0CU////vwEJAHxCR4CJgBrAOIABwBm/78Cn////6UEGgHxCP4CJgBrANgABwBl//ECcv///9IEJAH7CO0CJgBrCuIABwBp//ACwf//ABr60QJD/68CJwBrAFL42wAHAGMAPv3AAAD//wAU+/wCPf+uAicAawBM+NoABwBnAEr9+wAAAAQAbf+5CA8IigBoALEAvQDSAAAFJy4BJzMuAycmJw4BIyoBJzMuAScuATc+ATc+AzcnPAEmNDUlGgEXHgMzNjc1NC4BAiclEx4DFRQWFxYXFjY3PgE1NAsBJRoBBw4BBw4BJwYiIyImJy4BJzMuAScHDgEjEyInJjcVND4CNxcHDgEHBhYXFj4CNz4BNzY0NR8BHgEXHgM7ATI2NTQuAic3HgMVFAYHDgMjIiYnJjUnMycOARM2NTQnNx4BFRQGBwEuAScGIw4DHwEGFhcnHgMXBH4xFCUIAgUmLiwLTjQjRh8OHg4Bjcg6Ih0CAhALLXaBgTgGAQE5ECYSBjQ8MgUtFwcMEQoBPigGCgYEBw4IEipABg4HJCsBOCYmAQEpJSqZbQgXCBQqFQ4YCwEZKxQHQoo6YkQtLAUICQkBdAkEBgECFwgHEREOBAUGAQF2CAQKBQMKDA0GBw8OEhgZB24BHCAaGhwPIBwYBiQ+GQEBAQMgRxIZGn8LDwsO/QMGCwUBASVaTTEEAQEXJgEMJSgmDkcDAgIBAQgMDwcmTAMDAQVUSDBnLSRBF1N6WT8YRwgVExEEMP6q/nM/IyMPAQQqJiui4gEcpSH91VKIYTcBCyQRCQIBBggRKhUDAaoB/0f+CP3pJzBtOTo9AQIEBwIGBQsVDQUqIAWfNTpxARMpIxgCGyYQIw0eJwQDDRgcCxEpEwsXCwIvFCsRChYTDCUaEzMyLAxFAzBHVCY6UBwPEAgBIR0BAQECKhwBw11GQmIoLWEwLWpC+qQqZ0IBDycsLRUJAhAIAQIEAwMBAAD////a/SkMpgYvACMADAnsAE8AIwA+BZv6lgAjAHwFUwAAACMAcgd2AAAAAgAiqgAAAQBaBVcDlgcsAAMAAAkBNwEDlvzECAL9BrX+opYBPwACAEf/ZgIDBiQABQAJAAATAxEhEQMHFwcnwDEBFSRb3t7eAY4C8wGj/l39DWze3t4AAAAAAgBNBDICywbKAAQACQAAAQMjETMFAyMRMwFCMMX1AYkvxPMGI/4PApin/g8CmAAAAgBN/4cFlAZpABsAHwAAASMDIxMhNSETITUhEzMDMxMzAyEVIQMhFSEDIwMzEyMDJ+lX3lf+7QE4PP7nAT9Y3FjrWN5ZAQn+0j0BD/7NV95u6jzrAXf+EAHw0AFY0wH3/gkB9/4J0/6o0P4QAsABWAAAAAABAG/+gwUaB4EALQAAATQmJC4CNTQANxEzERYSFSE0JiMiBhUUFgQeAhUUAAcVIzUmADUhFBYzMjYDvG7++L+JTAEF2cLW8v6ieGRjbWoBIrqARP8A4sD4/u8BXomAa3sBV2N1ZGJ/rHbNAQUWAQP++R7+2OyRkHFjXG91ZoKmbs7/ABfx7xsBK/iQmnEAAAAFAHP/bwa8BoMADQAaACgANAA4AAATNDYzMhYdARQGIyImNRcUFjI2PQE0JiMiBhUBNDYzMhYdARQGIyImNRcUFjMyPQE0JiIGFQEnARdz06qt09OqrNToVIhPT0dCUwJj1ams1NCurtLoV0GUUohS/ZKrA12qBReiysirV6PHyKoISFlaS1pIWllO/CWkx8WtV6PHyaYFQ16jXElYWE3+2FwFYVwAAAADAFb/bwY+BoIAHAAlADAAABM0NjcuATU0ADMyFhUUDwEBNjUhEAcBIScGIyAAJTI3AQcGFRQWAxQXNz4BNCYjIgZWibdPWgEF3MX91YcBL0gBKp8BCP5zW8P9/vv+xQJRfnH+pBlshhRqXkc2WUZLWwFhe9B/abpkzgEC67DSoWL+no2p/qjV/s5ogAETBkYBkhJcfWmEBC9bij4uV3laYQAAAAEATAQvAU0GygAEAAABAyMRIQFNI94BAQYY/hcCmwAAAQA//dQDnQeoABgAAAEOAwcOAwcQAAUHABE1NhI3FT4BNwOADj1KUyMpVEUyBAERAQ/U/XYHpYxAmmoGsQ89UmAzOJaxxWj+/v3t/u0CYAKFJeoBuMMCWa9fAAABAFX91AO0B6gAGAAAAR4BFzUWEhcVEAEnJAARLgMnLgMnAThqmj+NpQf9dtUBEAERBDJGVCgkUks8DgeoX69ZAsP+SOol/Xv9oO3+AhMBAmjFsZY4M2BSPQ8AAAEAIQI7BFQGaQAOAAABJTcFAzMDJRcFEwcLAScBnf6ERwF5Ge4ZAW9I/nz+wNzawQQTbNuXAab+UpTdbP6+iQFi/qqDAAAAAAEARQA4BP0FOwALAAABIREhESERIREhESEDSAG1/kv+s/5KAbYBTQNi/sT+EgHuATwB2QABACr9zQHRALEACQAAEyc3NjcRIQcGAuG3LFECASgBAoX9zWBOlJMBD/KH/u8AAAABAIUB7QMvAwcAAwAAASERIQMv/VYCqgHtARoAAQCZ/3oCJADuAAsAADc0NjMyFhUUBiMiJplwVVZwb1dWbzNTaGhTUmdnAAAB//D+8AN9BmkAAwAAEyEBIfX++wKJAQT+8Ad5AAAAAAIAXQAoA5YDYQATACcAAAEUHgIzMj4CNTQuAiMiDgIHND4CMzIeAhUUDgIjIi4CAVUZLTsiIzwtGxstPCMiOy0Z+EFvllVVl3BCQnCXVVWWb0EBwyI7LRkZLTsiIzwtGxstPCNVl3BCQnCXVVWWb0FBb5YAAQBE/5QCagaBABQAAAU0CgMmJyUeAxceAx0CARgDDhsvRjMBGTlMNCMPCw0IAmyRASoBJQEYAQPlXq9ZxNHeclnM089aL18AAQAQ/34EhAZpADQAAAEeARUUBgcOASMiJiceAxUhNAoCJxUvATMnFS4BJyUeAx8BHgM3PgM1NCYnBGoMDjpPQrFsHDYZDQ4HAf6uCBs1LBgHAQQLHyIBHBcgGBMJHRQsNkUtOjwcAwoJBmlPhDhtzWROTgMFcvT17Ge5AXYBXgE4ewE6EgoBG0U7tCQ6MisVSC5QOSABAjJMXiwpUTcAAAEAFf+NBhIGagBOAAABHgMVFAYHDgEjIi4CJw4BIyImJx4DFSE+AzU0LgQnJR4BHwEeAzMyPgI1NCYvASUeARceAzMyPgI1NC4CJwXlDhALBDgzMo1SHEFERB84hlsVJxIMDwgD/qsBAgECBhAgNU01ASwgMhInGCMiLCQeJxcJCAMFATcCAgIGER4wJhQYDQYDBxENBmpHZEw9IXSlQDpCCRYmHjw7AQRo7fbvahZCSEMWX9rk6uLUXK8xYSlcN0kqEB8zRSQpUSMsLAskDjF6a0gbKS0TDyM8XUoAAAAAAQAO/4gFWwZbADoAAAEiJiceAxUhNAoCJyUeARc+Azc2MjMyHgIXAzQuAgcOBRc1HgMzMj4CNxMOAQNzT5hFDQ8JAv6vEjhrWgEdIz4XIltqdDsPJxAvYGFgLrAxS1wrGDw8OCkXBAZBWWEoJlpeWieNgfYCkR0idtzQxWHeAbMBkAFhjbM7aTMwUjslBQEKHjku/usBGiAYAQMTGyQmKhQBIi0aCgwYJRj++F9HAAACAEL/cwW7BqMAMQBeAAAFIiYnDgEjIi4CJy4BNTQ2Nz4DNy4BJzceAxc1HgEXHgEXFhIXHgEVFA4CBwMUHgIXPgM1NCYnMy4DLwEOAwcOARUUHgIzMj4CNz4BNz4BNwP8TosxNopQVoxoQQwFBA8PFEBdeEsLGwrsChwgHw0GDAVVp01pnTERETNsqXVxCBkpIR84KhgMBwEhanyDOQ4yY1RBEAkLFSQuGw4hIR4KDA8GAgUDjUE1Nz5LdpFHHD0gPH4/Vq+80HYNGQvsCxweHgwBBQwGT6Zhhf7dlTV4PmfDnGMEAr8senFTBQYqPEcjJUwdY7CchzoNRKCknkMtaTEkPzAbEyIxHylPHxIvEQAAAAABADv/eQTYBlEAQQAAFz4DNz4BNy4DNTQ+Ajc+ATMyFhcHLgMrASIOAgczDgEVFBYzOgE3Fj4CNxMHDgUHDgEHBgc7AShDWzYyWS9EdVgxGzVLL1DEbFi3YZgjPDUtFBAbOzcvDwEjI01PCREIMm50dzt3bHXEnntYNgsDAgICASQEXImpU0x6Lg9JaoZLN21mWyc+Pzw4/Q8RBgELEhYLH0EdKzsBAQ4ZHxH+3jMskq23oXwaAwgDBQMAAAEAQ/97BZkGcQAdAAAFNAoCLgEnJRYaAhc+BTcFDgMHBgIHAkwoSGNzgUIBG0+AZ1EhGztAQkNAHwEZKlRTUCVWXgKFrgE5AR0BAu7dabWC/vb++P7+e1/NycGoiy+zQqW8z2v2/ky8AAAAAAEAOv9qBa0GYgAaAAAFLgUnDgICByU2GgIRBRYaAxYXBJQdQ0ZGQz8aJVhrgk3+5WO7klgBZgMxUGZxdTWPLoWetr3BXHX2/f7/f7SeAVgBiAHAAQYBeP7j/tP+0f7t6VEAAAACAH3/QAS1BrgADQA3AAABNicmBwYHBgcGFxYXFgEHFwcnJgMGIyInJicmNzY3Njc2MzIXFhMWFxQVFAcdAgYVFBcWFxYXAxQJNj5WXEQbCwsLH4aCAgEMAvgIgTwdJIFulV9NCglEQ2Vldad1iSYMAgEBLBggGwkEHlV0hQMCaCsqKxc/Fxb7+AsEpQ7rAnsDISyAZ6OPiIVKSniN/tVcbCgqEBIODQEUBsHlhXtuDgAAAAACAJf/egIjBDgACwAXAAA3NDYzMhYVFAYjIiYRNDYzMhYVFAYjIiaXcVVWcG9XVnBxVVZwb1dWcDNTaGhTUmdnA5tUaGhUUmdnAAAAAgBF/c0CIwQ4AAkAFQAAEyc3NjcRIQcGAgM0NjMyFhUUBiMiJvy3LFECAScBAYXNcVVWcG9XVnD9zWBOlJMBD/KH/u8FVVRoaFRSZ2cAAAABAEEALQRUBL4ABgAAAQURAREBEQGiArL77QQTAnPz/q0BugEdAbr+rQAAAAIApQECBN8ELAADAAcAAAEhESERIREhBN/7xgQ6+8YEOgMOAR781gEeAAAAAQCRACwEsAS9AAYAAAElEQERAREDUf1ABB/74QJ39QFR/kb+5P5FAVEAAAACADb/eAR5BoIAGAAiAAABND4CNTQjIgYHITYAMyAEFRQGDwEGDwEBNDYyFhUUBiImAaRS20m9WWwC/qADASb+AQEBG1xzYlwNBf6nbqxubLBsAaSqyMN7Q81uYecBBvjjZ7dvXVh3Sv6MUmlpUk9paQAAAAIAW/1jCFMGOQA1AEEAAAECACMiJicGIyICNzYSNjMyHwEDBhYzMhI3EgAhIgQCAwIAITI2NxcOASMgAAITEggBISAAEgEGFjMyNjcTJiMiBghFDf7o7GiXJ3nDscEYFp7yja16TD0MQklvlggU/oP+iur+k9MNFAF/AX1l3FAuSvt//sH+Pd0ODwEUAdwBKwEvAbfa+zIOU1w7aiQyLzGMmQIQ/sr+lFlUqgEq9MgBN6dQNP1FYGYBBdIBpwHG7v5L/ub+VP4rLSa7MDsBAQH3AVwBTwISASH+/P4c/j6fpmhiAj0P7QACAAj/hwZ9BmkABwAKAAAlIQMhASEBIQEhAwSA/YR5/n0CkQFQApT+fv1rAbjd8v6VBuL5HgKRApQAAAADAJ3/hwW7BmkADgAWAB4AABcRISAEFRQGBx4BFRQABQERITI2NTQnASEkNTQmKwGdAmoBQQFLhXeInP68/tT+vgE3gJD7/rQBDAETi5b+eQbi9e6BxS4izpX+/voCAv/+JXps8gMBAQXWeGkAAAAAAQBo/28GBwaCABwAAAECACEgABE1NBIkMyAAEyEuASMiAgMVEBIzMjY3BgUV/ob+yv6t/nuzAU3cATIBdB3+lQ2jqLW0A627qKYMAdL+5P65AcgBjmz+AYTP/rn+2Kua/vz+7oX+4v74mqEAAgCd/4cF4QZpAAsAFQAAFxEhMgQSHQEUAgQHAxEzMhITNRACI50CH+gBb87K/pDotq/V4QPf1nkG4tH+fvZR9v6C0wEFvPtoARYBA10BDQEVAAAAAQCd/4cFOwZpAAsAAAEhESERIREhESERIQTC/UcDMvtiBJv80QK5AoP+KP7cBuL+2v5cAAEAnf+HBRkGaQAJAAABIREhESERIREhBML9R/6UBHz88AK5Alf9MAbi/tr+OQAAAAEAcv9vBhAGggAgAAAlBgQjIiQCAzUQEiQzIAATIS4BIyICAxUQEjMyNxEhESEGEGL+mtrl/qe8ArIBT+EBOgFhIf6eGKaRucIB08vNV/61ArZmdoHHAX0BAHgBCAGCzf7V/uKXjf7p/u5x/uv+5FgBLwEMAAAAAAEAnf+HBjgGaQALAAAFIREhESERIREhESEGOP6V/Tz+lAFsAsQBa3kC8/0NBuL9NgLKAAABALT/hwIgBmkAAwAABSERIQIg/pQBbHkG4gAAAQAw/28EzwZpABAAAAEhERQCBCMgABEhFBYzMjY1A2QBa5X+8av+6f7HAW5tdWh8Bmn7PKj+/owBHAEEgXyPhAAAAAABAJ3/hwY6BmkADAAAAQcRIREhETcBIQkBIQLFvP6UAWyfAcEBv/2OAoT+UAJKy/4IBuL84tsCQ/zx/C0AAAAAAQCd/4cFDAZpAAUAACUhESERIQIJAwP7kQFsq/7cBuIAAAAAAQCd/4cH3AZpAA4AAAkCIREhERMBIwETESERAngBxQHCAd3+lCT+JPn+JSX+lAZp+wIE/vkeAeIDP/rfBSD8wv4eBuIAAAAAAQCd/4cGNwZpAAkAAAUhAREhESEBESEGN/6U/T7+lAFsAsQBankEiPt4BuL7dgSKAAAAAAIAaP9vBkUGggAQAB4AAAEQAgQjIiQCJzUQEiQgBBIRJRACIyICAxUQEjMyEhMGRbj+qt7b/qi9AbwBVgG5AVe7/pDGuLfHAce6t8QBAtD+/P541dIBh/9XAQQBjNTU/nT+/QEBFQEg/uT+7Vb+8v7XAR4BEwAAAAIAnf+HBeMGaQALABQAAAERIREhMgQSFRAAIQEhMjY1NCYnIQIJ/pQCsMYBLqL+nf7H/sIBRJCXmIf+tAH0/ZMG4pH+9av+/f7VASaIfoGgAgAAAAIAZv5MBkMGggAUACIAAAEUAgcFBwEGIyIkAic1EBIkIAQSESUQAiMiAgMVEBIzMhITBkOgjgEl5/6JQEXb/qi9AbsBVwG5AVa8/pDHuLfGAca7tsUBAtD3/pRu5s0BLgvSAYf/VwEEAYzU1P50/v0BARUBIP7k/u1W/vL+1wEeARMAAAIAnf+HBfoGaQAOABcAAAEhESERISAAFRQGBwEVIQEhMjY1NCYjIQMq/t/+lAKPATkBU52eAX3+ev2VASSJlo2T/t0CDP17BuL+6v618Ej9MBEDq4x6fI8AAAAAAQBU/28FnAaCACcAAAE0JiQnJBE0NiQzMgQWFSE0JiMiBhUUFhcEABUUACEiJAI1IRAhMjYEL5H+hm7+1KEBLby9ASek/pWZioWUrakBNQEc/qX+3Mz+sq8BbAFdgZEBVWduezuiAROP4H6J+Z95hnBcVnQzXf7szuX+/JUBA6r+3WkAAQAw/4cFzAZpAAcAAAEhESERIREhBcz95P6V/esFnAVD+kQFvAEmAAEAjP9vBdMGaQAQAAABERAAISAAAxEhERQWMyATEQXT/pb+x/7L/pUEAWylkwEyBQZp+3j+3v6wAUcBHQSW+3WtnwFCBJUAAAEACP+HBkwGaQAGAAAJASEBIQEhAykBjwGU/Zv+hf2cAZQBPAUt+R4G4gAAAQAq/4cIUQZpAAwAAAETIQEhCQEhASETASEF+u0Bav55/pP+4f7h/pL+eQFq7wEiATQBgwTm+R4Em/tlBuL7HQTjAAABABv/hwYNBmkACwAACQEhCQEhCQEhCQEhAxQBSwGh/f8CDv5a/q3+rf5aAg79/wGiBAoCX/yW/IgCaf2XA3gDagAAAAEAAv+HBfkGaQAIAAAJASEBESERASEC/QFvAY39vf6P/b0BjwNPAxr7nf2BAn8EYwAAAAABAFj/hwWXBmkACQAAJSERITUBIREhFQIeA3n6wQNo/JoFKav+3NUE5wEm0AAAAAABAJH97QKcB4oABwAAASMRMxEhESECnKys/fUCCwZ8+H/+8gmdAAAAAQAA/vAERQZpAAMAABEhASEBZQLg/poGafiHAAEAEP3tAhsHigAHAAATIREhETMRIxACC/31ra0HivZjAQ4HgQAAAAABADUC+QQHBmkABgAAAQMhATMBIQIe0v7pAWr+AWr+6wUj/dYDcPyQAAAAAAEAAf51BFD/hwADAAABIREhBFD7sQRP/nUBEgABAD8FUwKsBsoAAwAAASEBIQKs/uH+sgF9BVMBdwAAAAIAUv9vBN8EvQAeACkAAAUmJwYjIiY1NCQlMzU0JiMiBhUhNDYkMzIEFREWFxUlMjY3NSMgDwEUFgN9GAt/y8H9ATUBJKFdZVhl/qKNAQCg8gEdATP9fU6CIIP++REBXHkvRo3eqtDfAUtbbVVKcsJu8939ybtfFfNFOuK2FUFVAAAAAAIAhv9vBSMGygAPABsAAAEQACMiJwchESERNjMyABElNCYjIgcRFjMyNzYFI/7z8dV/EP7FAV55xu8BEf6ifn2nP0CpqTUaAgr+xf6go4sHQ/1ljv6g/sAGx7aI/fuKp1AAAAABAFD/bwTLBL0AHAAAJTI2NyEOAiMgABE1EAAhMgAXIS4BIyIGHQEUFgKnYXkCAUgBj/iW/uf+vAFCARn1ASkC/rgCeWN7fHuJalmF3noBZQE7FwEuAWn+6Ohmf7LIJMqxAAAAAgBQ/28E7AbKAA4AGAAAExAAMzIXESERIScGIyIAARQWMzI3ESYjIlABE+6/fQFf/sQRgs7n/ugBXoB6o0JBof0CIAEyAWuPApz4vYujAWwBK7jEiQIFiAAAAAACAFf/bwT8BL0AFQAdAAAFIAARNTQSJDMgABEVIR4BMzI3FwYEAyIGByE1LgEC4f7g/paZARezAQ0BNfy+EaqDynKsT/70zGiBEwHnAnmRAWEBJiLGATeo/q3+yY+Am5LAcHwEM42CG3V/AAABACP/hwN5BuQAFAAAFxEjETM1NDYzMhcDJiMiHQEhESER5sPD/eRIagQsP8UBBP78eQQdAQFv3PQY/vALuWn+//vjAAIAVP2DBQEEvQAbACYAABMQADMyFzchERQGBCMiJCc3FjMyNj0BBiMiABEFFBYzMjcRJiMiBlQBHvTXeA8BPZz+5L6Q/u9Hm4O7i5t5xuz+3QFdj32gRUecfpACIAEtAXCUfPsOrP+Fc1vVkpWIR4kBcQExC7LKeAInd80AAAAAAQB+/4cE6gbKABAAAAE2MyATESERNCYjIgcRIREhAdyL0wGqBv6iYXGZRf6iAV4EFqf+Efy5Az1xa3b8XQdDAAIAhP+HAgwGrAADAA4AAAUhESEBNDYzMhYVFAYiJgH4/qEBX/6MaVtaamywbHkFHgFTTmZmTlBmZgAAAAL/jf12AgYGrAAMABYAAAERFAYjIicRFjMyNREDNDYyFhUUBiImAfnm2VtSPy+fHGm2aWywbASl+pvZ8RUBFQuoBWgBU05mZk5QZmYAAAAAAQCG/4cFRQbKAAwAAAEHESERIRE3ASEJASECYn7+ogFeRAFPAaT+JwID/m4BlH7+cQdD+/pXAYr93v0EAAAAAAEAmf+HAfgGygADAAAFIREhAfj+oQFfeQdDAAABAIb/hwfcBL0AHQAAARc2MzIXNiEyFhURIRE0JiMiBxMhETQmIyIHESERAc4LjO39XooBANXQ/qFXbp48Af6iWmuVQ/6iBKWTq8jI+Pr8vANDcGaW/H0DQnJle/xiBR4AAAAAAQB//4cE6gS9ABEAAAEXNjMyFhcRIRE0JiMiBxEhEQHIC43s0MsD/qJhcZNK/qIEpZiw9fP8sgNGb2R9/GQFHgAAAAACAFD/bwUpBL0ADQAZAAATNBIkMyAAExcQACAAEQUUFjMyNjU0JiMiBlCWARq6AQoBTxMD/q/9yv6uAV6Mg3+Pj4KAjAIiwwExp/68/ulZ/tL+lAFrATgJu8XD1rfJyAACAIb9jwUhBL0ADwAZAAABEAAjIicRIREhFzYzMgARJTQmIyIHERYzMgUh/u7qx3r+ogFFDH/N8gEM/qOCe6U+QKX7Agr+0f6Uiv2WBxaBmf6a/sUHt8Z9/eeBAAIAUP2PBOwEvQAOABkAABMQADMyFzchESERBiMiAAEUFjMyNxEmIyIGUAET79N9FwEz/qF5xOr+6gFehHihQkGgeYUCIgE1AWahifjqAmmJAWsBL7zEgAIdfMQAAQCG/4cDawS9AA0AAAEmIyIHESERIRc2MzIXA2ZHN8Y+/qIBSwppujozA10JhvynBR6ctBAAAAABAET/bwSgBL0AJQAAJTQmJyQRNCQzMgQVITQmIyIGFRQWBBcEFRQEIyIuATUhHgEzMjYDTH+N/i0BIer5ASv+omBnWWFvAQVaARX+zPOl/5EBSwWBa2Vn8UBKHWIBK67q67xMYlA+Okg0IGb7s911zXZdY0wAAAABAAz/bwMWBecAFAAAAREzESMRFBYzMjcRBiMgAxEjETMRAing4DhPOixmbf6QCL+/Bef+vv7//XJIPwj+9x8BcwLCAQEBQgABAH7/bwTqBKUAEAAAJQYjIiYnESERFDMyNxEhESEDl4Ll0t4CAV66skMBX/62DJ3y6QNb/LLNewOg+uIAAAAAAQAQ/4cE0gSlAAYAAAETIQEhASECcfMBbv5G/rL+RgFtATIDc/riBR4AAAABACL/hwb3BKUADAAAARMhASELASEBIRsBMwT5rAFS/rL+2/j4/tz+sgFSqvD9AWMDQvriAzj8yAUe/L8DQQAAAQAZ/4cE2wSlAAsAAAETIQkBIQsBIQkBIQJ53AF2/owBhP6J6uj+hwGF/owBeAMeAYf9fv1kAZz+ZAKcAoIAAAEABP12BNkEpQAQAAABEyEBBwIhIicRFzI2PwEBIQJv8wF3/fEddf7yTE81Y2IcKf42AXgBdgMv+hdF/v8XAQkBPEdrBSIAAAEAWv+HBJkEpQAJAAAlIREhNQEhESEVAhgCgfvBAmj9qgQZof7m1QMtARzPAAAAAAEAOv3TAwkHFAAYAAABJBE1NCM1MjcRNBI3Fw4BBxUQBxYZARIXAsX+TdjTBdnaRFxeA9jYBrf903oBufH/+/EBAOABFD7DIqiV/v7ubm/+7f7//uU/AAABANH+QAGlBmkAAwAAASMRMwGl1NT+QAgpAAAAAQAp/dMC+AcUABcAABM2ExEQNyYRNQInNxYSFxEWMxUiFRECBSm4Bd7eBbhE2doBBdLXCv5W/pdCAR0BAQESamsBF/0BGkXDPP7t3/788fv9/vr+WHgAAAEAgAFNBcYDcAAVAAABFAIjIi4BIyIGFSU0EjMyHgEzMjY1BcbhslqZyVVGV/7727Zem8ZRR1sDR+H+50XAeV4C4QESSbuAXAAAAAADAGj/bwcfBoIAGgAoADcAAAEUBiACPQE0EjMyFhUjNCYjIgYHFRQWMzI2NSU0AiQjIgQCEBIEICQSJTQSJCAEEhUUAgQjIiQCBUjU/n3l58DF0bxwanB6AXtwa20B/7X+tMXB/ra9uwFLAYMBTbj53uIBkQHRAZHi5v5y5+r+cuQCWLjEAQLaidIBAse1dGWkiJWOo2J2ockBWc/G/qP+Zf6jys4BXMr1AaPx8f5d9ff+XO/yAaMABABo/28HHwaCAA4AHAAyADsAABM0EiQgBBIVFAIEIyIkAiU0AiQjIgQCEBIEICQSJREjESEyFhUUBx4BFBYXFSMmNTQmIyczMjY1NCYnI2jiAZEB0QGR4ub+cufq/nLkBiK1/rTFwf62vbsBSwGDAU24/Iu3AVW204lKOwkMvA9QXcClWXNVcasC+fUBo/Hx/l319/5c7/IBo/XJAVnPxv6j/mX+o8rOAVxu/mgEBaWZiEslhsdSHBQqwVxRo00/VUcBAAEAWgVXA9sHVAADAAAJATcBA9v8fwgDQgbd/nqWAWf//wBF/QQT4gYxACMABgYB//8AIwAvDNwAAAAjACcIfP//ACMAjhC7AAAAAwDPABYAhgAAAAT/W/1WB4sC4wAHADgAQABxAAABBycHJzcXNwE0PgI7ATI+Ajc2LgInJR4BFx4DMzIeAhUUDgIjIiYnDgMrASIuAgEHJwcnNxc3EzQ+AjsBMj4CNzYuAiclHgEXHgMzMh4CFRQOAiMiJicOAysBIi4CBwLAvrzCwL68+RsYKzohTEiFZj8CAQEKExEBIxMgCAIKFyggITorGRksOSBgiTEtdYSMREwhOisYA73AvrzCwL68nRgrOiFMSIVmPwIBAQoTEQEjEyAIAgoXKCAhOisZGSw5IGCJMS11hIxETCE6Kxj+bcG+vMHBvrwBNCE6KxgMJ0c7Fh0pQz1SMJ5eHkA2IxgrOiEhOisYOy8eKBkLGCs6/dbBvrzBwb68AYohOisYDCdHOxYdKUM9UjCeXh5ANiMYKzohITorGDsvHigZCxgrOgAAAAAE/1v9VgbNA7wABwAxAGIAagAAAQcnByc3FzcBND4COwIyPgI3NjU0LgInJR4DFRQHDgEHDgMrAiIuAiU0PgI7ATI+Ajc2LgInJR4BFx4DMzIeAhUUDgIjIiYnDgMrASIuAgEHJwcnNxc3BpPAvrzCwL68/UEZKjohbzAtbGRREwspODsSAR0fOi4cJCqSZh5aXFIXkQkhOioZ/EkYKzohTEiFZj8CAQEKExEBIxMgCAIKFyggITorGRksOSBgiTEtdYSMREwhOisYA7PAvrzCwL68/nzBvrzBwb68ASYhOisYCBIfGBEdK3Z6cCWMNpOblTdlVF57HQgKBQEYKzogITorGAwnRzsWHSlDPVIwnl4eQDYjGCs6ISE6Kxg7Lx4oGQsYKzr91sG+vMHBvrwAAgCb/d0CIwTRAAMADAAAEyETIQEUBiImNDYyFs4BJCf+jQF9b6pvbLBsAqL7OwY7Umhoo2hoAAABAHj+cwT1BdcAIQAAJTI2NyEOAQcRIxEmABE1EBI3ETMRFhIXIS4BIyIGBxUUFgLPYXkCAUoD6bzy4/8A/uXyxeAD/rYCeWJ8ewF8nmpZsP8j/uQBGiUBXAESGwEIAV8mAQ/+8CP+88VofbXBKMyvAAAAAAEAeP+cBX0GlgAfAAABFxQHIREhETM2NScjETMDNAAzIAAVITQmIyIGFRMhEQKrB0sDFvr+cFcGxLoIASv6AQEBJf6lamJQaQsBdgJVqJVY/twBJBbCvQEeARP0ARz+7+hnbXd0/u3+4gAAAAIAYv97Bl8FlwAbACsAACUGIyInByc3JjU0Nyc3FzYzMhc3FwcWFRQHFwcBFB4BMzI+ATU0LgEjIg4BBRPB9Pa/nKujeYSuq6y76uu7r6y0gneprPu7guiGheeDg+aGiOaCHpqYn66mve73w7Kur4uOs6+3wPXqvKuwAwGP9o2N9o+Q842N8wABABj/nAXTBn8AFgAACQEhASEVIRUhFSERIREhNSE1ITUhASEC9gFPAY7+OgEc/n4Bgv5+/pT+agGW/moBOv45AZADoQLe/J/Ui9L+rwFR0ovUA2EAAAAAAgCb/lUB1gZ/AAMABwAAExEhGQEhESGbATv+xQE7/lUDw/w9BJQDlgAAAAACAG/9eQWUBpcALQA5AAABFAcWFRQEISAANSUUFjMyNjU0JiQuATU0NyY1NCQhIAAVITQmIyIGFRQWBB4BJQYVFBYXBTY1NCYnBZTEpP6z/tv+yf6kAV6bmoeNnP5G4G7EpQFUASIBKwFJ/qKVgYWShwHA7HH8llpklgENY26PAeLcbHvh1PEBA/YBbHNbTE9jeoa1gNpxfeDP/v7u82mCX1JYWneFuYszd1RbMFE5cEtgMAACAHEFdwQNBqoACgAVAAATNDYzMhYUBiMiJiU0NjMyFhUUBiImcV1KS1xcS0hfAk1gR0ZiXZZcBhBCWFt+WVZCQVlYQj9aWgACAF0AMwRjA/sABgANAAAJASMBNQEzEwEjATUBMwFvASLh/q0BU+GwASLh/q0BU+ECFv4dAdgXAdn+G/4dAdgXAdkAAAEAhQICAy8DHAADAAABIREhAy/9VgKqAgIBGgABALMFtgQnBoAAAwAAASE1IQQn/IwDdAW2ygAAAgCZA/8DJgaXAAoAFAAAEzQ2MzIWEAYjIiYFMjY1NCYiBhQWmcSFhMDAhIPGAUlAU1OAWFkFSYrEw/7pvr4KVUE/XFx+VwAAAgBs/50EwQWwAAsADwAAASERIREhESERIREhASERIQM0AY3+c/7N/msBlQEzAWv76gQWBBD+3f5HAbkBIwGg+e0BHQABAHoFaALmBt8AAwAAASEBIQFpAX3+sf7jBt/+iQAAAAEAqQItAjUDowAJAAATNDYyFhQGIyImqXCscHFVV28C6FNoaKdnagACAGcAMgR4A/kABgANAAAJARUBIwkBIQEVASMJAQFJAVP+reIBIv7eAr4BU/6t4gEi/t4D+f4oF/4oAeMB5P4oF/4oAeMB5AABAE8AlATLBSEACwAAEwkBNwkBFwkBBwkBTwFz/o3NAXABcs3+jQFzzf6O/pABYAF6AXvM/ocBecz+hf6GzAF3/okAAAMATAA2BSkFegADAA8AGwAAASERIQE0NjMyFhUUBiMiJhE0NjMyFhUUBiMiJgUp+yME3fzNb1dWcG1ZW2tvV1ZwbVlbawJPARcBXFNlZFRRZGX8eVNlZFRRZGUAAQBGBGEByAbfAAgAABMnNjc1IRUUBuulaAQBFnkEYWCjr8y7bf4AAAEAlQV+BDIG3wAIAAABFSEnByE1ATMEMv7purv+7wFmzAWMDq+vEwFOAAAAAQBnBX8EIAbhAAgAAAE3IRUBIwE1IQJEsQEr/pLe/pMBKwYzrg7+rAFXCwABALMFtgQnBoAAAwAAASE1IQQn/IwDdAW2ygAAAQCPBXcB9QbBAAkAAAEyFhQGIyImNDYBQlRfX1RSYWIGwV2RXFyRXQAAAAACAJAE7QKsBtgACwAVAAATNDYzMhYVFAYjIiY3FBYyNjU0JiIGkJ1xb5+bc3WZi0Z6Rkh2SAXgaJCOameMjmU1TU01OExMAAABAI4FgwQdBt4AFwAAARQGIyIuAiMiBhUnNDYzMh4CMzI2NQQdoHMuR344ICs7y55zJUCROB4qPgbRibkURBA9NwyGvRJGDzs4AAAAAgBFBXIEOQbeAAMABwAAASEBIQMhASEC/wE6/r7++MkBNf7r/v8G3v6UAWz+lAAAAfvDBWj+MAbfAAMAAAEhASH+MP7h/rIBfwVoAXcAAAAB/MYFaP8yBt8AAwAAASEBIf20AX7+sP7kBt/+iQAAAAH7ngWD/y0G3gAXAAADFAYjIi4CIyIGFSc0NjMyHgIzMjY1059zLkh+NyEqPMuecyVAkTgeKj4G0Ym5FEQQPTcMhr0SRg87OAAAAAACAKz9uQJv/1cACQATAAAFMhYUBiMiJjQ2FxQWMjY1NCYiBgGPY319Y2CDgwY0TTExTTSpe6x3dLF50SczMycpNDQAAAL7FQWI/zIGygADAAcAAAEhASEBIQEh/Zj+3/6eAVoCw/7m/tgBUwWIAUL+vgFCAAH8Z/3Y/e7/KAAKAAABNDYzMhYVFAYiJvxnbVZXbWyxav6BSF9fSEhhYQAAAQEIBYwCnQcuAAMAAAEhAyMBYAE9xdAHLv5eAAEAqQItAjUDowAJAAATNDYyFhQGIyImqXCscHFVV28C6FNoaKdnagABAH4EkQH/BwkACAAAARcGBxUhNTQSAVqlaAT+638HCWClqcq1cgECAAAAAAEARgRhAcgG3wAIAAATJzY3NSEVFAbrpWgEARZ5BGFgo6/Mu23+AAABAFD+KwHSALEACAAAEyc2NzUhBw4B9aVeBAEgAQF4/itfmbPbyWv6AAAAAAEAVgRhAdgG3wAJAAABFR4BFwcuAT0BAWwCLD6lY3oG38VWnGdgVv9vugAAAgCIBJEDqAcJAAgAEQAAARcGBxUhNTQSJRcGBxUhNTQSAWSlaQP+638B/KVoBP7rfwcJYKWpyrVyAQJPYKWpyrVyAQIAAAAAAgBXBGEDfQbfAAgAEQAAEyc2NzUhFRQGBSc2NzUhFRQG/KVoBAEWeQFApWgEARZ5BGFgo6/Mu23+WGCjr8y7bf4AAAACAFD+EwNyANoACAARAAATJzY3ESEHBgIFJzY3ESEHBgL9rV4EASABAXIBNq1oAwEgAQJ6/hNfosEBBfF1/vdYX7OxAQT1df75AAAAAQBMBEQBTQbfAAQAAAEDIxEhAU0j3gEBBi3+FwKbAAACAE0ERwLLBt8ABAAJAAABAyMRMwUDIxEzAUIwxfUBiS/E8wY4/g8CmKf+DwKYAAABAIMAMwK3A/sABgAACQEjATUBMwGUASPh/q0BU+ECFv4dAdgXAdkAAQBhADIClgP5AAYAAAkBFQEjCQEBQwFT/q3iASL+3gP5/igX/igB4wHkAAABACQAIAQsBd4AAwAANycBF8+rA12rIFwFYlwAAAAeAW4AAQAAAAAAAABOAAAAAQAAAAAAAQASAE4AAQAAAAAAAgAEAGEAAQAAAAAAAwAkAE4AAQAAAAAABAAXAE4AAQAAAAAABQAaAHIAAQAAAAAABgAVAIwAAQAAAAAABwA+AKEAAQAAAAAACAAiABYAAQAAAAAACQAPACgAAQAAAAAACgBNAN8AAQAAAAAACwAXAV8AAQAAAAAADAAdASwAAQAAAAAADQBCAUkAAQAAAAAADgAXAV8AAwABBAkAAACcAYsAAwABBAkAAQAkAicAAwABBAkAAgAIAk0AAwABBAkAAwBIAicAAwABBAkABAAuAicAAwABBAkABQA0Am8AAwABBAkABgAqAqMAAwABBAkABwB8As0AAwABBAkACABEAbcAAwABBAkACQAeAdsAAwABBAkACgCaA0kAAwABBAkACwAuBEkAAwABBAkADAA6A+MAAwABBAkADQCEBB0AAwABBAkADgAuBElDb3B5cmlnaHQgKGMpIDIwMTUgYnkgd3d3LmZvbnRpcmFuLmNvbSAoTW9zbGVtIEVicmFoaW1pKS4gQWxsIHJpZ2h0cyByZXNlcnZlZC5JUkFOU2Fuc1dlYihGYU51bSkgQm9sZDpWZXJzaW9uIDQuMjBWZXJzaW9uIDQuMjAgTWFyY2ggNCwgMjAxNklSQU5TYW5zV2ViRmFOdW0tQm9sZElSQU5TYW5zIGlzIGEgdHJhZGVtYXJrIG9mIHd3dy5mb250aXJhbi5jb20gKE1vc2xlbSBFYnJhaGltaSkuVG8gdXNlIHRoaXMgZm9udCwgaXQgaXMgbmVjZXNzYXJ5IHRvIG9idGFpbiB0aGUgbGljZW5zZSBmcm9tIHd3dy5mb250aXJhbi5jb21odHRwOi8vd3d3Lm1vc2xlbWVicmFoaW1pLmNvbUNvcHlyaWdodCAoYykgMjAxNSBieSBodHRwOi8vd3d3LmZvbnRpcmFuLmNvbSBBbGwgUmlnaHRzIFJlc2VydmVkLgBDAG8AcAB5AHIAaQBnAGgAdAAgACgAYwApACAAMgAwADEANQAgAGIAeQAgAHcAdwB3AC4AZgBvAG4AdABpAHIAYQBuAC4AYwBvAG0AIAAoAE0AbwBzAGwAZQBtACAARQBiAHIAYQBoAGkAbQBpACkALgAgAEEAbABsACAAcgBpAGcAaAB0AHMAIAByAGUAcwBlAHIAdgBlAGQALgBJAFIAQQBOAFMAYQBuAHMAVwBlAGIAKABGAGEATgB1AG0AKQAgAEIAbwBsAGQAOgBWAGUAcgBzAGkAbwBuACAANAAuADIAMABWAGUAcgBzAGkAbwBuACAANAAuADIAMAAgAE0AYQByAGMAaAAgADQALAAgADIAMAAxADYASQBSAEEATgBTAGEAbgBzAFcAZQBiAEYAYQBOAHUAbQAtAEIAbwBsAGQASQBSAEEATgBTAGEAbgBzACAAaQBzACAAYQAgAHQAcgBhAGQAZQBtAGEAcgBrACAAbwBmACAAdwB3AHcALgBmAG8AbgB0AGkAcgBhAG4ALgBjAG8AbQAgACgATQBvAHMAbABlAG0AIABFAGIAcgBhAGgAaQBtAGkAKQAuAFQAbwAgAHUAcwBlACAAdABoAGkAcwAgAGYAbwBuAHQALAAgAGkAdAAgAGkAcwAgAG4AZQBjAGUAcwBzAGEAcgB5ACAAdABvACAAbwBiAHQAYQBpAG4AIAB0AGgAZQAgAGwAaQBjAGUAbgBzAGUAIABmAHIAbwBtACAAdwB3AHcALgBmAG8AbgB0AGkAcgBhAG4ALgBjAG8AbQBoAHQAdABwADoALwAvAHcAdwB3AC4AbQBvAHMAbABlAG0AZQBiAHIAYQBoAGkAbQBpAC4AYwBvAG0AQwBvAHAAeQByAGkAZwBoAHQAIAAoAGMAKQAgADIAMAAxADUAIABiAHkAIABoAHQAdABwADoALwAvAHcAdwB3AC4AZgBvAG4AdABpAHIAYQBuAC4AYwBvAG0AIABBAGwAbAAgAFIAaQBnAGgAdABzACAAUgBlAHMAZQByAHYAZQBkAC4AAAIAAAAAAAD9RAB4AAAAAAAAAAAAAAAAAAAAAAAAAAABrQAAAQIAAgADAQMBBAEFAQYBBwEIAQkBCgELAQwBDQEOAQ8BEAERARIBEwEUARUBFgEXARgBGQEaARsBHAEdAR4BHwEgASEBIgEjASQBJQEmAScBKAEpASoBKwEsAS0BLgEvATABMQEyATMBNAE1ATYBNwE4ATkBOgE7ATwBPQE+AT8BQAFBAUIBQwFEAUUBRgFHAUgBSQFKAUsBTAFNAU4BTwFQAVEBUgFTAVQBVQFWAVcBWAFZAVoBWwFcAV0BXgFfAWABYQFiAWMBZAFlAWYBZwFoAWkBagFrAWwBbQFuAW8BcAFxAXIBcwF0AXUBdgF3AXgBeQF6AXsBfAF9AX4BfwGAAYEBggGDAYQBhQGGAYcBiAGJAYoBiwGMAY0BjgGPAZABkQGSAZMBlAGVAZYBlwGYAZkBmgGbAZwBnQGeAZ8BoAGhAaIBowGkAaUBpgGnAagBqQGqAasBrAGtAa4BrwGwAbEBsgGzAbQBtQG2AbcBuAG5AboBuwG8Ab0BvgG/AcABwQHCAcMBxAHFAcYBxwHIAckBygHLAcwBzQHOAc8B0AHRAdIB0wHUAdUB1gHXAdgB2QHaAdsB3AHdAd4B3wHgAeEB4gHjAeQB5QHmAecB6AHpAeoB6wHsAe0B7gHvAfAB8QHyAfMB9AH1AfYB9wH4AfkB+gH7AfwB/QH+Af8CAAIBAgICAwIEAgUCBgIHAggCCQIKAgsCDAINAg4CDwIQAhECEgITAhQCFQIWAhcCGAIZAAQABQAGAAcACAAJAAoACwAMAA0ADgAPABAAEQASABMAFAAVABYAFwAYABkAGgAbABwAHQAeAB8AIAAhACIAIwAkACUAJgAnACgAKQAqACsALAAtAC4ALwAwADEAMgAzADQANQA2ADcAOAA5ADoAOwA8AD0APgA/AEAAQQBCAEMARABFAEYARwBIAEkASgBLAEwATQBOAE8AUABRAFIAUwBUAFUAVgBXAFgAWQBaAFsAXABdAF4AXwBgAGEAiwCKAhoCGwIcAh0AowCEAIUAvQCWAOgAhgCOAKkCHgDaAIMAkwCNAMMAqgDwALgCHwDYAOECIADcAN0A2QDfAiECIgIjAiQCJQImAicCKAC2ALcAxAIpALQAtQDFAioCKwC+AL8AvAROVUxMB3VuaTA2MjEHdW5pMDYyNwd1bmlGRThFB3VuaTA2MkQHdW5pRkVBMwd1bmlGRUE0B3VuaUZFQTIHdW5pMDYyRgd1bmkwNjMxB3VuaUZFQUUHdW5pMDYzMwd1bmlGRUIzB3VuaUZFQjQHdW5pRkVCMgd1bmkwNjM1B3VuaUZFQkIHdW5pRkVCQwd1bmlGRUJBB3VuaTA2MzcHdW5pRkVDMwd1bmlGRUM0B3VuaUZFQzIHdW5pMDYzOQd1bmlGRUNCB3VuaUZFQ0MHdW5pRkVDQQd1bmlGRURCB3VuaUZFREMHdW5pMDY0Mwd1bmlGRURBB3VuaTA2NDQHdW5pRkVERgd1bmlGRUUwB3VuaUZFREUHdW5pMDY0NQd1bmlGRUUzB3VuaUZFRTQHdW5pRkVFMgd1bmkwNjQ3B3VuaUZFRUIHdW5pRkVFQwd1bmlGRUVBB3VuaTA2NDgHdW5pRkVFRQd1bmkwNjQ5B3VuaUZFRjAHdW5pRkVGQgd1bmlGRUZDB3VuaTA2NDAHdW5pMDY2RQx1bmkwNjZFLmZpbmEMdW5pMDY2Ri5pbml0DHVuaTA2NkYubWVkaRBmZWhfZG90bGVzcy5pc29sDHVuaTA2QTEuZmluYQd1bmkwNjZGDHVuaTA2NkYuZmluYQxvbmVkb3QuYWJvdmUNdHdvZG90cy5hYm92ZQ90aHJlZWRvdHMuYWJvdmUPdGhyZWVkb3RzLmJlbG93B3VuaTA2NjAHdW5pMDY2MQd1bmkwNjYyB3VuaTA2NjMHdW5pMDY2NAd1bmkwNjY1B3VuaTA2NjYHdW5pMDY2Nwd1bmkwNjY4B3VuaTA2NjkHdW5pMDZGNAd1bmkwNkY1B3VuaTA2RjYHdW5pRkJBOAd1bmlGQkE5B3VuaTA2QkUHdW5pMDZEMgd1bmlGQkFGB3VuaTA2QTkHdW5pRkI4Rgd1bmkwNkFGB3VuaUZCOTQHdW5pRkI5NQd1bmlGQjkzB3VuaTA2QkEHdW5pRkI5Rgd1bmkwNjZBB3VuaTA2MUYHdW5pMDYwQwd1bmkwNjFCB3VuaTA2NkIHdW5pMDY2Qwd1bmkwNjZEB3VuaTA2NEIHdW5pMDY0RAd1bmkwNjRFB3VuaTA2NEYHdW5pMDY0Qwd1bmkwNjUwB3VuaTA2NTEHdW5pMDY1Mgd1bmkwNjUzB3VuaTA2NTQHdW5pMDY1NQd1bmkwNjcwB3VuaTA2NTYHdW5pMDYxNQd1bmlGRUFBBXdhc2xhDHVuaTA2NkUuaW5pdAx1bmkwNjZFLm1lZGkUYmVoX2RvdGxlc3NfYWx0LmluaXQUYmVoX2RvdGxlc3NfYWx0Lm1lZGkHdW5pMDZDMQd1bmkwNjg2B3VuaUZCN0IMb25lZG90LmJlbG93DXR3b2RvdHMuYmVsb3cNYWxlZl9hbHQuaXNvbA1hbGVmX2FsdC5maW5hB3VuaTA2MjMHdW5pRkU4NAd1bmkwNjI1B3VuaUZFODgHdW5pMDYyMgd1bmlGRTgyB3VuaTA2NzEHdW5pRkI1MQd1bmkwNjI4B3VuaUZFOTEHdW5pRkU5Mgd1bmlGRTkwB3VuaTA2N0UHdW5pRkI1Nwd1bmlGQjU4B3VuaUZCNTkHdW5pMDYyQQd1bmlGRTk3B3VuaUZFOTgHdW5pRkU5Ngd1bmkwNjJCB3VuaUZFOUIHdW5pRkU5Qwd1bmlGRTlBB3VuaTA2NzkHdW5pRkI2OAd1bmlGQjY5B3VuaUZCNjcHdW5pMDYyOQd1bmlGRTk0B3VuaUZCN0MHdW5pRkI3RAd1bmkwNjJDB3VuaUZFOUYHdW5pRkVBMAd1bmlGRTlFB3VuaTA2MkUHdW5pRkVBNwd1bmlGRUE4B3VuaUZFQTYHdW5pMDYzMAd1bmlGRUFDB3VuaTA2ODgHdW5pRkI4OQd1bmkwNjMyB3VuaUZFQjAHdW5pMDY5MQd1bmlGQjhEB3VuaTA2OTgHdW5pRkI4Qgd1bmkwNjM0B3VuaUZFQjcHdW5pRkVCOAd1bmlGRUI2B3VuaTA2MzYHdW5pRkVCRgd1bmlGRUMwB3VuaUZFQkUHdW5pMDYzOAd1bmlGRUM3B3VuaUZFQzgHdW5pRkVDNgd1bmkwNjNBB3VuaUZFQ0YHdW5pRkVEMAd1bmlGRUNFB3VuaUZCOTAHdW5pRkI5MQd1bmkwNjQxB3VuaUZFRDMHdW5pRkVENAd1bmlGRUQyB3VuaUZCNkEHdW5pRkI2Qwd1bmlGQjZEB3VuaUZCNkIHdW5pRkVENwd1bmlGRUQ4B3VuaTA2NDIHdW5pRkVENgd1bmlGRUU3B3VuaUZFRTgHdW5pMDY0Ngd1bmlGRUU2B3VuaTA2RDUHdW5pMDZDMAd1bmlGQkE1B3VuaTA2MjQHdW5pRkU4Ngd1bmlGQkU4B3VuaUZCRTkHdW5pRkVGMwd1bmlGRUY0B3VuaTA2NEEHdW5pRkVGMgd1bmkwNkNDB3VuaUZCRkUHdW5pRkJGRgd1bmlGQkZEB3VuaTA2RDMHdW5pRkJCMQd1bmkwNjI2B3VuaUZFOEIHdW5pRkU4Qwd1bmlGRThBB3VuaUZFRjcHdW5pRkVGOAd1bmlGRUY5B3VuaUZFRkEHdW5pRkVGNQd1bmlGRUY2EHVuaTA2NDQwNjcxLmlzb2wQdW5pMDY0NDA2NzEuZmluYQtoZWhfYWUuZmluYQd1bmkwNkMyB3VuaTA2QzIHdW5pRkJBNgd1bmkwNkMzB3VuaTA2QzMHdW5pRkJBQgd1bmlGQkFDB3VuaUZCQUQHdW5pMDZGMAd1bmkwNkYxB3VuaTA2RjIHdW5pMDZGMwd1bmkwNkY5B3VuaTA2RjcHdW5pMDZGOAx1bmkwNkY0LnVyZHUMdW5pMDZGNy51cmR1B3VuaUZFNzAHdW5pRkU3Mgd1bmlGRTc0B3VuaUZFNzYHdW5pRkU3OAd1bmlGRTdBB3VuaUZFN0MHdW5pRkU3RQxHaHVubmFfYWJvdmUHdW5pRkM1RQd1bmlGQzVGC3VuaTA2NTEwNjRCB3VuaUZDNjAHdW5pRkM2MQd1bmlGQzYyB3VuaUZDNjMLdW5pMDY1NDA2NEILdW5pMDY1NDA2NEULdW5pMDY1NDA2NEMLdW5pMDY1NDA2NEYLdW5pMDY1NDA2NTILdW5pMDY1NTA2NEQLdW5pMDY1NTA2NTAHdW5pRkRGMgd1bmlGREZDCGRpYWdvbmFsB3VuaTIwMEMKc2Fya2VzaF8zMQZ0b29tYW4EeWV5ZQV5ZXllMQd1bmkwMEFEB3VuaTAyQkMHdW5pMDJDOQlncmF2ZWNvbWIJYWN1dGVjb21iCXRpbGRlY29tYgd1bmkwMkYzB3VuaTAzMEYMZG90YmVsb3djb21iBXRvbm9zCWFub3RlbGVpYQ1xdW90ZXJldmVyc2VkBm1pbnV0ZQZzZWNvbmQAAAAAAQADAAgACgAQAAr//wAKAAAAAQAAAAAAAQAAAA4AAAAAAAAAAAACABIAAAAxAAEAMgAzAAIANABhAAEAYgBvAAMAcABwAAEAcQBxAAMAcgDlAAEA5gDtAAIA7gEHAAEBCAEWAAMBFwEYAAIBGQF7AAEBfAF+AAIBfwGYAAEBmQGbAAMBnAGcAAEBnQGeAAMBnwGsAAEAAAABAAAACgBGAHIAAWFyYWIACAAQAAJGQVIgABxVUkQgACgAAP//AAMAAQACAAAAAP//AAMAAQACAAAAAP//AAMAAQACAAAAA2tlcm4AFG1hcmsAHG1rbWsAJAAAAAIABAAFAAAAAgAAAAEAAAACAAIAAwAGAA4AFgAeACYALgA2AAQABQABADAABQABAAELcgAGAAEAAQ8aAAYAAQABERYAAgAJAAERqgACAAEAARPcAAEADAAiAAIAYgDYAAIAAwBiAG8AAABxAHEADgEJARYADwACAAoABAAxAAAANAA4AC4AOgA8ADMATgBaADYAcABwAEMAcgBzAEQAdgB4AEYAfQDEAEkAyQDlAJEA7wD2AK4AHQAAA1AAAQNWAAADXAAAA2IAAANoAAEDbgAAA3QAAANoAAADegAAA4AAAQOGAAADjAABA5IAAAOYAAADngAAA6QAAAOqAAADsAAAA7YAAAO8AAADwgAAA8gAAAPOAAAD1AAAA9oAAAPgAAAD5gABA+wAAQPyALYDggOIA44DlAOaA6ADpgOsA7IDuAOyA7gDvgPEA8oD0APWA9wD4gPoA+4D9AP6BAAEBgQMBBIEGAQeBCQEKgQwBCoEMAQeBDYEPARCBEgETgRIBE4EVARaBGAEZgRsBHIEeAR+BIQEigSQBJYEnARyBKIEqASuBAwEtAS6BMAExgTMBJYE0gS6BNgE3gTkBOoE8AT2BPAE/AUCBQgFDgUUBRoFIAUmBSwFMgU4BT4FRAVKBVAFVgVQBVwFYgVoBW4FaAV0BXoFgAWGBYAFjAWSBZgFngWYBaQFqgWwBbYFvAXCBAAFyAXOBdQF2gXgBeYF7AXmBfIF+AX+BgQGCgYQBhYGHAYiBigGLgY0BjoGQAZGBJYGTAZSBlgGXgZkBmoGcAZ2BnwDlAaCBogGjgaUBpoGoAamBqwGsga4Br4GuAbEBsoFaAbQBtYG3AbiBugFaAbuBWgG9AVoBvoHAAcGBwwHEgcYBx4HJASWByoHMAc2BzwHQgc8B0gElgdOBzAHVAdaB2AHPAdmBJYHbAcwB3IHPAd4B34HhAeKB5AHlgecB6IHqAeuB7QHugfAB8YHzAfSB9gH3gfkB+oH8Af2B/wIAggICA4IFAgaCCAIJggsCA4IMgg4CDIIPghECEoIUAhWCFwIYghoCG4IdAh6CIAIhgiACIwIkgiYCJ4IpAiqCLAIqgi2CJ4IvAjCCMgIzgjUCNoI4AjmBFoI7AjyCPgI/gkEBH4JCgkQCRYJHAkWCSIJKAkuCTQFgAk6BYAJQAlGCUwFgAlSBYAJWAeiCV4HoglkBJYJaglwCXYJfAmCCYgJjgd+CZQHfgmaB4oJoAmmCawFOAbWBJYJsglwBwAJuAm+CcQJygnQCdYJ3AniCegHAAnuCfQJ+gVKCgAFDgoGCgwKEgoYBVAKHgSWCiQJcAoqBVAKMAYQCjYGXgmOCjwKQgpICk4GXge0ClQKWgpgCmYKbAABAMgEJAABAMj/ugABAPAETAABAKAEEAABALQEEAABAOb/QgABANwD8gABANwETAABANwEOAABARIAyAABAMgEEAABAB7/TAABAMgD1AABANwEEAABAVoELgABAPkEBgABANwELgABANwEGgABAMcEGgABAMcEJAABARgEGgABAPwEOAABALcEOAABAW4EJAABAOcEOAABAL4EJAABAPoAlgABANIAlgABAdYDrAABAhz/YAABAQQGzAABARj/dAABASwGkAABAWj/dAABAkQFeAABAhz8cgABAyAETAABAlj/agABApQE7AABAZD8SgABAf4FPAABAcL/YAABAZADcAABAUD9CAABAaQDIAABAWj9HAABBkAEEAABBdz9gAABAyAD/AABAwz/JAABA1wD6AABAyD/YAABBmgD1AABBwj9+AABBqQEJAABB5T+hAABA6wEJAABA8D+/AABB2z+wAABBIgGQAABA1z/JAABA4QGQAABAqj/YAABBLAGLAABA3D/YAABAwwF3AABAjD8VAABAjAEsAABAhz/EAABAkQEsAABAfT/YAABAwwEnAABAbj8GAABAZAGcgABASz/YAABAZAGhgABAooExAABAtD/JAABAuQE2AABAcwE7AABAnb8uAABAQ4GpAABAOb/YAABAXIG4AABAbgExAABAhwEJAABApT9RAABAjAEJAABAmz/JAABAlgEJAABApT/JAABAtD9qAABAZAFFAABAeD/JAABAfQFUAABArz/EAABAeAEsAABAeX84AABAlgFKAABAoD/EAABAfQEiAABAeD89AABAkQEdAABAfT89AABAeADDAABArz8zAABAeADIAABAZoDDAABAdb/JAABA6wD6AABBCT/EAABA8D/YAABAa4FFAABAcz/YAABAa4EOAABBbQETAABBbT/YAABA4QEJAABAtD9HAABAvj89AABASwETAABAWT9qAABAfQCMAABAef8zAABAqgFeAABAlgDegABAvj/EAABAqgBfAABAoD9gAABAqMFCgABA6z/OAABA4QFbgABApQFZAABA9T+/AABASwG9AABAaT/EAABAUAHCAABAgj/JAABAvgF8AABA/z/JAABAyoCvAABAzT8uAABAxYCqAABAvj8uAABAmIFUAABAmL/EAABAPoEsAABAWgDwAABARj/JAABAjADXAABAjD/YAABApQFUAABAqj8cgABAlgFAAABAoD8XgABANwIhAABARgIrAABARj/OAABAQQGQAABARj9CAABAUAGQAABAVT9MAABASwHlAABAVT+/AABAUAHvAABARj/EAABARgHvAABAVQH0AABASz/JAABA9T9WAABAOYETAABASz9qAABAWgDhAABAWj9qAABA8D9gAABBBD8uAABBCT8kAABAZAETAABAXz8fAABAggDmAABAaT8fAABA4QFFAABA8D/TAABAVQGVAABAbgFPAABAZD/YAABA/wFKAABA1z/YAABA+gGGAABAVQHWAABAXwGQAABA/wGQAABA/z/EAABA5gGkAABAKAHvAABAWgGzAABA9QGkAABAegGVAABAeD/YAABAmkG1gABAlj/YAABArwEnAABAuT84AABAuQExAABAuT8uAABAuQFUAABAlj8hgABArwEsAABAuT9gAABAqgEdAABAvj9bAABAuQFAAABAkT8IgABAfQHRAABAfT8IgABAlgGaAABArz/LgABAjAGQAABApT/LgABAkQGzAABAlj8IgABAbgHRAABAib/OAABAggHCAABAk7/TAABAZAIPgABAib/TAABAeAIcAABAZAFUAABASz89AABAUD89AABAUAGfAABAWj84AABAWgGuAABAVT84AABAcwGkwABAXz84AABAZAGQAABAWj89AABA+gEsAABBvT+SAABA1wGpAABAyD+/AABA0j+/AABBFYEsAABB1j+cAABBmgFUAABB7z+6AABA1wFeAABA4T/EAABA+j/EAABB7z/JAABBEwGpAABA5j/EAABA0gGkAABApT/EAABA1wGkAABAvj/JAABBGAGkAABAwwH+AABApT8QAABAcwGaAABAfT/EAABAlgGVAABAuQGzAABAgj8aAABAUAGmgABAWj/EAABAhz/JAABBYwG9AABA6z/YAABAXIHHAABAaQGVAABBfAGhgABBHT/OAABAYYHHAABAcwGfAABA/wF3AABA+gF3AABAQ4GGAABASwFtAABAVT/YAABArwD1AABAzT8zAABArwD6AABAzT8pAABAZAEsAABATgHMAABAeYHHAABAXwGVAABAcz89AABAZAGGAABAWgDSAABAVT9WAABAcwDmAABAXz9bAABAcwC5AABA0j69gABAfQDIAABAyD7ZAABAbgC+AABAyD8VAABAUD9RAABAggDhAABAVT9bAABA0j8zAABA1z+6AABAbgD1AABAyD9bAABAeoFFAABARgGuAABAUAGBAABAmwDDAABATgGzAABAXwFKAABAfT/OAABAbUGpAABAhL/YAABAkQFHgABApT8zAABAeAFFAABAmz/OAABAeAEYAABAfn89AABAAwAIgACAD4AtAACAAMAYgBvAAAAcQBxAA4BCQEWAA8AAgAEADIAMwAAAOYA7QACARcBGAAKAXwBfgAMAB0AAAFEAAEBSgAAAVAAAAFWAAABXAABAWIAAAFoAAABbgAAAXQAAAF6AAEBgAAAAVwAAQGGAAABjAAAAZIAAAGYAAABngAAAWgAAAGkAAABqgAAAbAAAAG2AAABvAAAAcIAAAHIAAABzgAAAdQAAQHaAAEB2gAPACAAKgA0AD4ASABSAFwAZgBwAHoAhACSAKQAugDEAAIBSgFQAVYBXAACAVgBXgFkAWoAAgFmAWwBcgF4AAIBdAFKAXoBgAACAXwBggEuAYgAAgGEAYoBkAGWAAIBkgEsAZgBngACAZoBIgGgAVgAAgGcAaIBqAGuAAIBqgGwAbYBvAADAbgBvgHEAcoB0AHWAAQBzgHUAdoB4AHmAewB8gH4AAUB7AHyAfgB/gIEAgoCEAIWAhwCIgACAhICGAIeAiQAAgIgAiYCLAIyAAEAyAQkAAEAyP9qAAEAyAQ4AAEAoAPoAAEAtAPoAAEA5v8uAAEAtAQaAAEAtAQQAAEAyARMAAEAtAQ4AAEA/v+cAAEAvv+wAAEAyAPUAAEAyAQQAAEBRgPyAAEA+QQuAAEAjAQaAAEAswQaAAEA7wQQAAEBLAPeAAEA6ARgAAEAjwQkAAEBbgQQAAEA+wQkAAEA5gQQAAEA0v/iAAEDmAZUAAED/P9gAAEAKAVkAAEBGP8kAAEEOAZ8AAEETP9gAAEAoAV4AAEBfP8QAAEEVQZ8AAEE4f9gAAEA0QejAAEB1f8QAAED/AZoAAEAoAfuAAEBVP8kAAEDhAbMAAEEJP1EAAEBkPxoAAEEJAZoAAEErf4+AAEAoAVkAAECMPy4AAED6AbMAAEAjAaQAAEBVP84AAEEYAbMAAEAtAakAAEDwAb0AAED6P8kAAEAUAZAAAEBLP78AAEETAbMAAEEiP84AAEA3AYsAAEBpP8QAAEH0AV4AAEHRP90AAEFKAjoAAEFAP8QAAEB1gScAAECJv+IAAEMEgNwAAELzP1EAAEJJASwAAEIUP0cAAEGkAZeAAEGSv2AAAEBzAMqAAECWPzMAAESNAZAAAESmP7UAAEOdAQkAAEOxPzMAAEK3APoAAEK8P78AAEHMAZAAAEH+P78AAEDDAQQAAEDcP0IAAEFtANcAAEFPP1sAAEB4AMMAAEBkPz0AAEFoAP8AAEFPP1iAAEBzAMMAAEBkPzWAAEADAA6AAEAaADGAAIABwBiAGIAAABkAGYAAQBoAGsABABtAG0ACABvAG8ACQBxAHEACgEJARQACwACAAcAYgBiAAAAZABmAAEAaABrAAQAbQBtAAgAbwBvAAkAcQBxAAoBCQEUAAsAFwAAAI4AAACUAAAAmgAAAKAAAACmAAAArAAAALIAAAC4AAAAvgAAAMQAAADKAAAA0AAAANYAAADcAAAAsgAAAOIAAADoAAAA7gAAAPQAAAD6AAABAAAAAQYAAAEMABcAtAC6AMAAxgDMANIA2ADeAOQA6gDwAPYA/AECAQgBDgEUARoBIAEmASwBMgE4AAEAyAQkAAEAyARMAAEAyAQGAAEA0gRMAAEA3AQaAAEAtAQQAAEA0gQkAAEAyAPyAAEAyAP8AAEAyAO2AAEA5gPoAAEBZAQuAAEA7wRMAAEA+gPKAAEA+QQuAAEAxwQuAAEA3AQuAAEBBgRqAAEA1QR0AAEBoAR0AAEA+wRgAAEA5gRqAAEA0gakAAEA3AWqAAEAyAbCAAEAyAakAAEAyAZUAAEAqgZeAAEAoAaQAAEAyAeeAAEAqgbCAAEAjAdsAAEA0gZUAAEBHghmAAEAxwi2AAEAvggWAAEAqgcmAAEAswhSAAEAxwdEAAEA3AgRAAEAwAkaAAEAjwgWAAEBWglWAAEAtQl0AAEAoAlWAAEADAAcAAEALABGAAEABgBjAGcAbABuARUBFgABAAYAYwBnAGwAbgEVARYABgAAACgAAAAuAAAANAAAADoAAABAAAAARgAGADIAOAA+AEQASgBQAAEAvv+mAAEAvv+IAAEA/gCqAAEAAP90AAEAoABuAAEA5gCMAAEAvv1EAAEAvv3uAAEA4P1iAAEA3P0cAAEAtPsKAAEA0vwOAAIAnAAFAAAA3AEcAAUABwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJYAlgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP+c/5wAZABkAJYAlgCWAJYAyADIAAAAAAAAAAD/nP+cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJYAlgAAAAAAAAAAAAAAAAAAAAD/av9qAAIACgAFAAYAAAAMAA0AAgAuAC8ABAAyADIABgB7AIQABwCpAK4AEQDUANUAFwDmAOYAGQDoAO0AGgEjASMAIAACAAoABQAGAAEADAANAAIALgAvAAMAMgAyAAEAewCEAAEAqQCuAAIA1ADVAAMA5gDmAAEA6ADtAAEBIwEjAAQAAgAvAAQABAAGAAcABwACAAgACAAGAAsACwAGAA8ADwAGABMAEwAGABYAFwAGABoAGgADABsAGwAGAB4AHgABACIAIgAEACYAJwAGACoAKwAGADAAMAAEADsAOwAEAFAAUAAGAFMAUwABAFUAVgABAFkAWQAEAHcAdwACAIsAiwACAJkAmQAGAJ0AnQACAJ4AngAGAKEAoQACAKIAogAGAKUApQAGALAAsAAGALQAtAAGALcAuAAGALsAuwADALwAvAAGAL8AvwABAMEAwgAGAMkAyQAGAMsAywAEAM8AzwAEANEA0QAGANgA2AACANoA2gAEANwA3AAEAN0A3QACAOIA4gAEAO8A7wAGAPEA8gAGAPUA9QAGASIBIgAFAAECnAAFAAAADQAkAFwAfACWAHwAzgEGAWIBxAIgAlgCWACWAAkAQ/84/zgARP84/zgASP84/zgAS/+c/5wATf84/zgA+f84/zgA+v84/zgA/P84/zgA/v84/zgABQBB/zj/OABG/2r/agBf/5z/nABg/wb/BgD3/zj/OAAEAEH/OP84AEb/av9qAGD/Bv8GAPf/OP84AAkAQ/84/zgARP84/zgASP84/zgAS/84/zgATf84/zgA+f84/zgA+v84/zgA/P84/zgA/v84/zgACQBD/5z/nABE/5z/nABI/5z/nABMAGQAZABN/5z/nAD5/5z/nAD6/5z/nAD8/5z/nAD+/5z/nAAPAEP/zv/OAET/zv/OAEUAZABkAEcAZABkAEj/zv/OAEkAZABkAEoAZABkAE3/zv/OAPn/zv/OAPr/zv/OAPsAZABkAPz/zv/OAP0AZABkAP7/zv/OAP8AZABkABAAQ/84/zgARP84/zgARQBkAGQARwBkAGQASP84/zgASQBkAGQASgBkAGQAS/84/zgATf84/zgA+f84/zgA+v84/zgA+wBkAGQA/P84/zgA/QBkAGQA/v84/zgA/wBkAGQADwBD/zj/OABE/zj/OABFAJYAlgBHAJYAlgBI/zj/OABJAJYAlgBKAJYAlgBN/zj/OAD5/zj/OAD6/zj/OAD7AJYAlgD8/zj/OAD9AJYAlgD+/zj/OAD/AJYAlgAJAEP/av9qAET/av9qAEj/av9qAEv/nP+cAE3/av9qAPn/av9qAPr/av9qAPz/av9qAP7/av9qAAsAQf84/zgARf84/zgARv9q/2oAR/84/zgASf84/zgASv84/zgAYP8G/wYA9/84/zgA+/84/zgA/f84/zgA//84/zgAAQANAEEARwBIAEkASgBMAE0AXwBgAPcA+wD8AP0AAAABAAAACgBgAMQAAWFyYWIACAAQAAJGQVIgACRVUkQgADgAAP//AAcAAAACAAMABgAHAAQAAQAA//8ABwAAAAIAAwAGAAcABAABAAD//wAIAAAAAgADAAUABgAHAAQAAQAIY2NtcAAyZmluYQA4aW5pdAA+aXNvbABEbGlnYQBKbG9jbABSbWVkaQBYcmxpZwBeAAAAAQAAAAAAAQAHAAAAAQABAAAAAQACAAAAAgAFAAYAAAABAAgAAAABAAMAAAABAAQACQAUABwAJAAsADQAPABEAEwAVAAEAAEAAQBIAAEACQABAWIAAQAJAAEB8AABAAkAAQH+AAQACQABAowABAABAAEC6gAEAAkAAQMqAAEACQABA4oAAQABAAEEZAABARIACwAcAC4AQABSAGQAdgCIAMIAzAD2AQgAAgAGAAwBCwACAGgBEAACAGsAAgAGAAwBCgACAGgBFQACAGwAAgAGAAwBDAACAGgBEQACAGsAAgAGAAwBDQACAGgBEwACAGsAAgAGAAwBCQACAGgBEgACAGsAAgAGAAwBDgACAGgBFgACAGwABwAQABYAHAAiACgALgA0AQsAAgBiAQoAAgBjAQwAAgBkAQ0AAgBlAQkAAgBmAQ4AAgBnAQ8AAgBtAAEABAEUAAIAawAFAAwAEgAYAB4AJAEQAAIAYgERAAIAZAETAAIAZQESAAIAZgEUAAIAaQACAAYADAEVAAIAYwEWAAIAZwABAAQBDwACAGgAAgACAGIAaQAAAGsAbQAIAAIATAAjAAgADwATABcAGwAeACMAJwArANYAcgA3APUAvwBWAM0AmwCGAIsAjgCSAJYAngCiALAAtAC4ALwAwgDJAM0A2ADdAOMATgABACMABwAOABIAFgAaACAAIgAmACoAMAA1ADsAUABTAFUAWQB3AIUAiQCNAJEAlQCdAKEArwCzALcAuwDBAMsAzwDaANwA4gDxAAIADAADAPEA7wDyAAEAAwB2APAA8wACAEwAIwAJABAAFAAYABwAHwAkACgALADXAHMAOAD2AMAAVwDOAJwAhwCMAI8AkwCXAJ8AowCxALUAuQC9AMMAygDOANkA3gDkAE8AAQAjAAcADgASABYAGgAgACIAJgAqADAANQA7AFAAUwBVAFkAdwCFAIkAjQCRAJUAnQChAK8AswC3ALsAwQDLAM8A2gDcAOIA8QABAF4AAgAKADQABQAMABIAGAAeACQAMgACAAYA5gACAH4A6AACAIAA6gACAIIA7AACAIQABQAMABIAGAAeACQAMwACAAYA5wACAH4A6QACAIAA6wACAIIA7QACAIQAAQACACMAJAABAEIAAQAIAAUADAAWACAAKgAyARcABAAkAGgALQEXAAQAJABoAHYBFwAEACQBDwAtARcAAwAkAC0BFwADACQAdgABAAEAIwABAFgABgASACAAMAA6AEQATgABAAQBGAAEANgABgAiAAEABAF8AAUALwAnAAYAzwABAAQBfgACANkAAQAEAX0AAgDZAAEABAF+AAIA3gABAAQBfQACAN4AAQAGAAwAjgDYANkA3QDeAAIAcgA2AAYACgBwAA0AEQAVABkAHQAhACUAKQAtAC8AMQA2ADwA9ABSAFQAWABaAHgAfgCAAIIAhACIAIoAkACUAJgAmgCgAKQApgCoAKoArACuALIAtgC6AL4AxADMANAALQDTANUA2wDfAOEA5QB2AAEANgAFAAcACwAMAA4AEgAWABoAIAAiACYAKgAuADAANQA7AFAAUQBTAFUAWQB3AH0AfwCBAIMAhQCJAI0AkQCVAJkAnQChAKUApwCpAKsArQCvALMAtwC7AMEAywDPANEA0gDUANoA3ADgAOIA8QACAAwAAwD/AP4ARwABAAMASABLAE0AAA==') format('truetype');
    font-weight: normal;}
                body { font-family: 'fa';padding: 20px; direction: rtl; text-align: right; }
                #invoice { width: 100%; max-width: 800px; margin: auto; border: 1px solid #ddd; padding: 20px; }
                table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
                th { background: #f8f8f8; }
                .no-print { display: none; } /* برای مخفی کردن دکمه‌های غیرضروری */
            </style>
            </head>
            <body class="invoice">
            ${invoice.outerHTML}
            <script>
                window.onload = function() {
                window.print();
                window.onafterprint = function() { window.close(); }
                };
            </script>
            </body>
            </html>
        `);
        printWindow.document.close();
    }
}

// document.addEventListener("DOMContentLoaded", function () {
//     document.addEventListener("contextmenu", event => event.preventDefault()); // غیرفعال کردن راست کلیک

//     document.addEventListener("keydown", function (event) {
//         if (event.ctrlKey && (event.key === "u" || event.key === "U")) {
//             event.preventDefault(); // غیرفعال کردن Ctrl+U (مشاهده سورس)
//         }
//         if (event.ctrlKey && event.shiftKey && event.key === "I") {
//             event.preventDefault(); // غیرفعال کردن Ctrl+Shift+I (باز کردن DevTools)
//         }
//         if (event.ctrlKey && event.shiftKey && event.key === "J") {
//             event.preventDefault(); // غیرفعال کردن Ctrl+Shift+J (کنسول جاوااسکریپت)
//         }
//         if (event.ctrlKey && event.shiftKey && event.key === "C") {
//             event.preventDefault(); // غیرفعال کردن Ctrl+Shift+C (انتخاب المنت)
//         }
//         if (event.key === "F12") {
//             event.preventDefault(); // غیرفعال کردن دکمه F12
//         }
//     });
//     setInterval(function () {
//         let before = new Date().getTime();
//         debugger;
//         let after = new Date().getTime();
//         if (after - before > 100) {
//             location.reload() ; // تغییر مسیر اگه DevTools باز بشه
//         }
//     }, 1000);

// })

document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll("button[name='rejected_btn']").forEach(button => {
        button.addEventListener("click", function (event) {
            event.preventDefault(); // جلوگیری از ارسال فرم

            let transactionId = this.closest("tr").querySelector("input[name='transaction_id']").value;
            let userId = this.closest("tr").querySelector("input[name='user_id']").value;

            Swal.fire({
                title: "رد فاکتور",
                html: `<input type="text" id="transaction_id" class="swal2-input" value="${transactionId}" disabled style="font-size: 18px; width: 80%;">
                <input type="text" hidden id="user_id" class="swal2-input" value="${userId}" disabled style="font-size: 18px; width: 80%;">
                       <textarea id="reject_reason" name="description" class="swal2-textarea" placeholder="علت رد فاکتور را وارد کنید..." required style="font-size: 18px; width: 80%; height: 150px;"></textarea>`,
                showCancelButton: true,
                confirmButtonText: "رد فاکتور",
                cancelButtonText: "انصراف",
                preConfirm: () => {
                    const reason = Swal.getPopup().querySelector("#reject_reason").value;
                    if (!reason) {
                        Swal.showValidationMessage("لطفاً علت رد فاکتور را وارد کنید!");
                    }
                    return { reason: reason };
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    let form = document.createElement("form");
                    form.method = "POST";
                    form.action = "";

                    let transactionInput = document.createElement("input");
                    transactionInput.type = "hidden";
                    transactionInput.name = "transaction_id";
                    transactionInput.value = transactionId;

                    let userInput = document.createElement("input");
                    userInput.type = "hidden";
                    userInput.name = "user_id";
                    userInput.value = userId;

                    let reasonInput = document.createElement("input");
                    reasonInput.type = "hidden";
                    reasonInput.name = "reject_reason";
                    reasonInput.value = result.value.reason;

                    let submitButton = document.createElement("button");
                    submitButton.type = "submit";
                    submitButton.name = "submit_reject";

                    form.appendChild(transactionInput);
                    form.appendChild(userInput);
                    form.appendChild(reasonInput);
                    form.appendChild(submitButton);

                    document.body.appendChild(form);
                    submitButton.click();
                }
            });
        });
    });
});

document.addEventListener('DOMContentLoaded', function () {
    const titleInput = document.getElementById('title_input');
    const slugInput = document.getElementById('slug_input');

    titleInput.addEventListener('input', function () {
        let title = this.value;

        // نقشه تبدیل حروف فارسی به انگلیسی
        const farsiToEnglishMap = {
            'ا': 'a', 'ب': 'b', 'پ': 'p', 'ت': 't', 'ث': 'th', 'ج': 'j', 'چ': 'ch', 'ح': 'h', 'خ': 'kh',
            'د': 'd', 'ذ': 'dh', 'ر': 'r', 'ز': 'z', 'ژ': 'zh', 'س': 's', 'ش': 'sh', 'ص': 's', 'ض': 'z',
            'ط': 't', 'ظ': 'z', 'ع': 'a', 'غ': 'gh', 'ف': 'f', 'ق': 'q', 'ک': 'k', 'گ': 'g', 'ل': 'l',
            'م': 'm', 'ن': 'n', 'و': 'v', 'ه': 'h', 'ی': 'y', 'ء': '', 'آ': 'a', 'ئ': 'y', 'ى': 'y',
            'و': 'v', 'ک': 'k', 'گ': 'g', 'ل': 'l', 'م': 'm', 'ن': 'n'
        };

        // تبدیل حروف فارسی به انگلیسی
        title = title.replace(/[\u0600-\u06FF]/g, function (match) {
            return farsiToEnglishMap[match] || match;
        });

        // تبدیل فاصله‌ها به خط تیره و تبدیل حروف به حروف کوچک
        title = title.replace(/\s+/g, '-').toLowerCase();



        // تنظیم نامک در فیلد نامک
        slugInput.value = title;
    });
});

document.getElementById('imageUpload').addEventListener('change', function (event) {
    var previewContainer = document.getElementById('preview');
    previewContainer.innerHTML = ''; // پاک کردن پیش‌نمایش‌های قبلی

    var maxFiles = 3; // حداکثر تعداد فایل‌های مجاز
    var files = event.target.files;

    if (files && files.length > maxFiles) {

        document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>');
        document.body.classList.add('swal-open');
        Swal.fire({
            icon: 'error',
            title: 'خطا!',
            text: 'شما فقط می‌توانید حداکثر ' + maxFiles + ' تصویر انتخاب کنید.',
            confirmButtonText: 'متوجه شدم',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                document.querySelector('.swal2-container').classList.add('swal-active');
            },
            willClose: () => {
                document.body.classList.remove('swal-open');
                document.querySelector('.swal-overlay').remove();
            },
        });

        // پاک کردن ورودی فایل
        document.getElementById('imageUpload').value = '';

        return; // جلوگیری از ادامه اجرای کد
    }

    if (files && files.length > 0) {
        for (let i = 0; i < files.length; i++) {
            let file = files[i];
            var reader = new FileReader();

            reader.onload = function (e) {
                var img = document.createElement('img');
                img.src = e.target.result;
                img.style.maxWidth = '200px'; // تنظیم حداکثر عرض تصویر
                img.style.margin = '5px'; // اضافه کردن فاصله بین تصاویر
                img.classList.add('preview-image'); // اضافه کردن کلاس برای استایل‌دهی
                previewContainer.appendChild(img);
            }

            reader.readAsDataURL(file);
        }
    } else {
        previewContainer.innerHTML = '<p>هیچ فایلی انتخاب نشده است.</p>';
    }
});

document.addEventListener('DOMContentLoaded', function () {
    const copyBtn = document.getElementById('copy_link');
    const input = document.getElementById('link_user');

    copyBtn.addEventListener('click', function () {
        const text = input.value;
        console.log('در حال تلاش برای کپی:', text);

        navigator.clipboard.writeText(text).then(function () {
            console.log('کپی موفقیت‌آمیز بود!');
            Swal.fire({
                icon: 'success',
                title: 'لینک کپی شد!',
                text: 'لینک معرفی با موفقیت در کلیپ‌بورد ذخیره شد.',
                confirmButtonText: 'باشه'
            });
        }).catch(function (err) {
            console.error('خطا در کپی:', err);
            Swal.fire({
                icon: 'error',
                title: 'خطا!',
                text: 'کپی لینک انجام نشد: ' + err,
                confirmButtonText: 'باشه'
            });
        });
    });
});

