<?php

if (isset($_POST['save_notif'])) {
    global $wpdb;
    $table = 'custom_notifications';
    $messages = [];
    $slug = sanitize_text_field($_POST['slug']);
    $Key = trim($_POST['key_protection']); // اگر `id` وجود داشت، مقدار عددی آن را بگیر
    $title = sanitize_text_field($_POST['title']);
    $description = sanitize_textarea_field($_POST['description']);
    $exsiting_slug = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE slug = %s AND key_protection != %s", $slug, $Key)
    );

    if ($exsiting_slug) {
        $messages[] = 'نامک انتخابی قبلا ثبت شده است';
    }
    if (!empty($messages)) {
        $message = implode('<br>', $messages);
    } else {
            $fields = [
                'key_protection',
                'send_id',
                'title',
                'slug',
                'description',
                'send_for',
                'status',
            ];
            handleFormSubmission(
                $table,
                $fields,
                [
                    'title' => 'عنوان اعلان',
                    'slug' => 'نامک اعلان',
                    'description' => 'توضیحات اعلان',
                ],
            );
    }
}
